/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.hive.ql.udf.generic.InstantFormatter;

abstract class InstantFormatterCache<T>
implements InstantFormatter {
    protected final ZoneId zoneId;
    protected final Function<String, T> loader;
    protected String lastPattern;
    protected T formatter;

    protected InstantFormatterCache(ZoneId zoneId, Function<String, T> loader) {
        this.zoneId = zoneId;
        this.loader = loader;
    }

    protected final T getFormatter(String pattern) {
        Objects.requireNonNull(pattern);
        if (!pattern.equals(this.lastPattern)) {
            this.lastPattern = pattern;
            this.formatter = this.loader.apply(pattern);
        }
        return this.formatter;
    }
}

