/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDecimalToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDoubleToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastLongToTimestamp;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

@Description(name="timestamp", value="cast(date as timestamp) - Returns timestamp")
@VectorizedExpressions(value={CastLongToTimestamp.class, CastDateToTimestamp.class, CastDoubleToTimestamp.class, CastDecimalToTimestamp.class, CastStringToTimestamp.class})
public class GenericUDFTimestamp
extends GenericUDF {
    private final transient ObjectInspectorConverters.Converter[] tsConvertors = new ObjectInspectorConverters.Converter[1];
    private final transient PrimitiveObjectInspector.PrimitiveCategory[] tsInputTypes = new PrimitiveObjectInspector.PrimitiveCategory[1];
    private boolean intToTimestampInSeconds = false;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 1, 1);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgGroups(arguments, 0, this.tsInputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.BOOLEAN_GROUP);
        SessionState ss = SessionState.get();
        if (ss != null) {
            boolean strict = ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION);
            PrimitiveObjectInspectorUtils.PrimitiveGrouping grouping = PrimitiveObjectInspectorUtils.getPrimitiveGrouping((PrimitiveObjectInspector.PrimitiveCategory)this.tsInputTypes[0]);
            if (strict && grouping == PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP) {
                throw new UDFArgumentException("Casting NUMERIC types to TIMESTAMP is prohibited (" + String.valueOf(HiveConf.ConfVars.HIVE_STRICT_TIMESTAMP_CONVERSION) + ")");
            }
            this.intToTimestampInSeconds = ss.getConf().getBoolVar(HiveConf.ConfVars.HIVE_INT_TIMESTAMP_CONVERSION_IN_SECONDS);
        }
        this.obtainTimestampConverter(arguments, 0, this.tsInputTypes, this.tsConvertors);
        return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
    }

    @Override
    public void configure(MapredContext context) {
        if (context == null) {
            return;
        }
        this.intToTimestampInSeconds = HiveConf.getBoolVar((Configuration)context.getJobConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INT_TIMESTAMP_CONVERSION_IN_SECONDS);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        PrimitiveObjectInspectorConverter.TimestampConverter ts = (PrimitiveObjectInspectorConverter.TimestampConverter)this.tsConvertors[0];
        ts.setIntToTimestampInSeconds(this.intToTimestampInSeconds);
        return ts.convert(arguments[0].get());
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "CAST( " + children[0] + " AS TIMESTAMP)";
    }

    public boolean isIntToTimestampInSeconds() {
        return this.intToTimestampInSeconds;
    }
}

