/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.esri.serde;

import com.esri.core.geometry.ogc.OGCGeometry;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.udf.esri.GeometryUtils;
import org.apache.hadoop.hive.ql.udf.esri.shims.HiveShims;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJsonSerDe
extends AbstractSerDe {
    static final Logger LOG = LoggerFactory.getLogger((String)BaseJsonSerDe.class.getName());
    protected static JsonFactory jsonFactory = new JsonFactory();
    protected static TimeZone tz = TimeZone.getDefault();
    protected int numColumns;
    protected int geometryColumn = -1;
    protected ArrayList<String> columnNames;
    protected ArrayList<ObjectInspector> columnOIs;
    protected boolean[] columnSet;
    protected StructObjectInspector rowOI;
    protected String attrLabel = "attributes";
    ArrayList<Writable> rowBase;
    ArrayList<Writable> row;

    public void initialize(Configuration cfg, Properties tbl, Properties partitionProperties) throws SerDeException {
        int c;
        this.geometryColumn = -1;
        String columnNameProperty = tbl.getProperty(HiveShims.serdeConstants.LIST_COLUMNS);
        String columnTypeProperty = tbl.getProperty(HiveShims.serdeConstants.LIST_COLUMN_TYPES);
        ArrayList typeInfos = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        this.columnNames = new ArrayList();
        this.columnNames.addAll(Arrays.asList(columnNameProperty.toLowerCase().split(",")));
        this.numColumns = this.columnNames.size();
        this.columnOIs = new ArrayList(this.numColumns);
        this.columnSet = new boolean[this.numColumns];
        for (c = 0; c < this.numColumns; ++c) {
            TypeInfo colTypeInfo = (TypeInfo)typeInfos.get(c);
            if (colTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE) {
                throw new SerDeException("Only primitive field types are accepted");
            }
            if (colTypeInfo.getTypeName().equals("binary")) {
                if (this.geometryColumn >= 0) {
                    throw new SerDeException("Multiple binary columns defined.  Define only one binary column for geometries");
                }
                this.columnOIs.add((ObjectInspector)GeometryUtils.geometryTransportObjectInspector);
                this.geometryColumn = c;
                continue;
            }
            this.columnOIs.add(TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)colTypeInfo));
        }
        this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(this.columnNames, this.columnOIs);
        this.rowBase = new ArrayList(this.numColumns);
        this.row = new ArrayList(this.numColumns);
        for (c = 0; c < this.numColumns; ++c) {
            Writable writable;
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(c);
            try {
                writable = (Writable)poi.getPrimitiveWritableClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new SerDeException("Error creating Writable from ObjectInspector", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SerDeException("Error creating Writable from ObjectInspector", (Throwable)e);
            }
            this.rowBase.add(writable);
            this.row.add(null);
        }
    }

    public Object deserialize(Writable json_in) throws SerDeException {
        Text json = (Text)json_in;
        for (int i = 0; i < this.numColumns; ++i) {
            this.row.set(i, null);
        }
        try {
            JsonParser parser = jsonFactory.createJsonParser(json.toString());
            JsonToken token = parser.nextToken();
            while (token != null) {
                if (token == JsonToken.START_OBJECT) {
                    if ("geometry".equals(parser.getCurrentName())) {
                        if (this.geometryColumn > -1) {
                            OGCGeometry ogcGeom = this.parseGeom(parser);
                            this.row.set(this.geometryColumn, (Writable)(ogcGeom == null ? null : GeometryUtils.geometryToEsriShapeBytesWritable(ogcGeom)));
                        } else {
                            parser.skipChildren();
                        }
                    } else if (this.attrLabel.equals(parser.getCurrentName())) {
                        token = parser.nextToken();
                        while (token != JsonToken.END_OBJECT && token != null) {
                            String name = parser.getText().toLowerCase();
                            parser.nextToken();
                            int fieldIndex = this.columnNames.indexOf(name);
                            if (fieldIndex >= 0) {
                                this.setRowFieldFromParser(fieldIndex, parser);
                            }
                            token = parser.nextToken();
                        }
                        token = parser.nextToken();
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object obj, ObjectInspector oi) throws SerDeException {
        StandardStructObjectInspector structOI = (StandardStructObjectInspector)oi;
        List fieldWritables = structOI.getStructFieldsDataAsList(obj);
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jsonGen = jsonFactory.createJsonGenerator((Writer)writer);
            jsonGen.writeStartObject();
            jsonGen.writeObjectFieldStart(this.attrLabel);
            for (int i = 0; i < fieldWritables.size(); ++i) {
                if (i == this.geometryColumn) continue;
                try {
                    this.generateJsonFromValue(fieldWritables.get(i), i, jsonGen);
                    continue;
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            jsonGen.writeEndObject();
            if (this.geometryColumn > -1) {
                Object got = fieldWritables.get(this.geometryColumn);
                if (got == null) {
                    jsonGen.writeObjectField("geometry", null);
                } else {
                    BytesWritable bytesWritable = null;
                    bytesWritable = got instanceof BytesWritable ? (BytesWritable)got : new BytesWritable((byte[])got);
                    OGCGeometry ogcGeometry = GeometryUtils.geometryFromEsriShape(bytesWritable);
                    jsonGen.writeRaw(",\"geometry\":" + this.outGeom(ogcGeometry));
                }
            }
            jsonGen.writeEndObject();
            jsonGen.close();
        }
        catch (JsonGenerationException e) {
            LOG.error("Error generating JSON", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Error generating JSON", (Throwable)e);
            return null;
        }
        return new Text(writer.toString());
    }

    private void generateJsonFromValue(Object value, int fieldIndex, JsonGenerator jsonGen) throws JsonProcessingException, IOException {
        String label = this.columnNames.get(fieldIndex);
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(fieldIndex);
        if (value == null) {
            jsonGen.writeObjectField(label, null);
        } else if (value instanceof LazyPrimitive) {
            this.generateJsonFromLazy((LazyPrimitive)value, fieldIndex, label, poi, jsonGen);
        } else if (value instanceof Writable) {
            this.generateJsonFromWritable((Writable)value, fieldIndex, label, poi, jsonGen);
        } else {
            jsonGen.writeObjectField(label, value);
        }
    }

    private void generateJsonFromLazy(LazyPrimitive<?, ?> value, int fieldIndex, String label, PrimitiveObjectInspector poi, JsonGenerator jsonGen) throws IOException {
        this.generateJsonFromWritable(value.getWritableObject(), fieldIndex, label, poi, jsonGen);
    }

    private void generateJsonFromWritable(Writable value, int fieldIndex, String label, PrimitiveObjectInspector poi, JsonGenerator jsonGen) throws IOException {
        Object prim = poi.getPrimitiveJavaObject((Object)value);
        Long epoch = HiveShims.getPrimitiveEpoch(prim, tz);
        if (epoch == null) {
            jsonGen.writeObjectField(label, prim);
        } else {
            jsonGen.writeObjectField(label, (Object)epoch);
        }
    }

    protected abstract String outGeom(OGCGeometry var1);

    protected abstract OGCGeometry parseGeom(JsonParser var1);

    private Date parseDate(JsonParser parser) throws IOException {
        Date jsd = null;
        if (JsonToken.VALUE_NUMBER_INT.equals((Object)parser.getCurrentToken())) {
            long epoch = parser.getLongValue();
            jsd = new Date(epoch - (long)tz.getOffset(epoch));
        } else {
            try {
                long epoch = this.parseTime(parser.getText(), "yyyy-MM-dd");
                jsd = new Date(epoch + 43200000L);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return jsd;
    }

    private Timestamp parseTime(JsonParser parser) throws IOException {
        Timestamp jst = null;
        if (JsonToken.VALUE_NUMBER_INT.equals((Object)parser.getCurrentToken())) {
            long epoch = parser.getLongValue();
            jst = new Timestamp(epoch);
        } else {
            String[] formats;
            String value = parser.getText();
            int point = value.indexOf(46);
            String dateStr = point < 0 ? value : value.substring(0, point + 4);
            for (String format : formats = new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd"}) {
                try {
                    jst = new Timestamp(this.parseTime(dateStr, format));
                    break;
                }
                catch (ParseException parseException) {
                }
            }
        }
        return jst;
    }

    private long parseTime(String value, String format) throws ParseException {
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        dtFmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dtFmt.parse(value).getTime();
    }

    private void setRowFieldFromParser(int fieldIndex, JsonParser parser) throws JsonParseException, IOException {
        PrimitiveObjectInspector poi = (PrimitiveObjectInspector)this.columnOIs.get(fieldIndex);
        if (JsonToken.VALUE_NULL == parser.getCurrentToken()) {
            return;
        }
        this.row.set(fieldIndex, this.rowBase.get(fieldIndex));
        switch (poi.getPrimitiveCategory()) {
            case BYTE: {
                ((ByteWritable)this.row.get(fieldIndex)).set(parser.getByteValue());
                break;
            }
            case SHORT: {
                ((ShortWritable)this.row.get(fieldIndex)).set(parser.getShortValue());
                break;
            }
            case INT: {
                ((IntWritable)this.row.get(fieldIndex)).set(parser.getIntValue());
                break;
            }
            case LONG: {
                ((LongWritable)this.row.get(fieldIndex)).set(parser.getLongValue());
                break;
            }
            case DOUBLE: {
                ((DoubleWritable)this.row.get(fieldIndex)).set(parser.getDoubleValue());
                break;
            }
            case FLOAT: {
                ((FloatWritable)this.row.get(fieldIndex)).set(parser.getFloatValue());
                break;
            }
            case BOOLEAN: {
                ((BooleanWritable)this.row.get(fieldIndex)).set(parser.getBooleanValue());
                break;
            }
            case DATE: {
                HiveShims.setDateWritable(this.row.get(fieldIndex), this.parseDate(parser));
                break;
            }
            case TIMESTAMP: {
                HiveShims.setTimeWritable((Object)this.row.get(fieldIndex), this.parseTime(parser));
                break;
            }
            default: {
                ((Text)this.row.get(fieldIndex)).set(parser.getText());
            }
        }
    }
}

