/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCompactorUtil {
    private static final String CLASS_NAME = RemoteCompactorUtil.class.getName();
    protected static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    public static Table resolveTable(HiveConf conf, IMetaStoreClient msc, CompactionInfo ci) throws MetaException {
        try {
            return msc.getTable(MetaStoreUtils.getDefaultCatalog((Configuration)conf), ci.dbname, ci.tableName);
        }
        catch (TException e) {
            LOG.error("Unable to find table " + ci.getFullTableName(), (Throwable)e);
            throw new MetaException(e.toString());
        }
    }

    public static List<Partition> getPartitionsByNames(IMetaStoreClient msc, String dbName, String tableName, String partName) throws MetaException {
        try {
            GetPartitionsByNamesRequest req = MetaStoreUtils.convertToGetPartitionsByNamesRequest((String)dbName, (String)tableName, Collections.singletonList(partName));
            return msc.getPartitionsByNames(req).getPartitions();
        }
        catch (TException e) {
            LOG.error("Unable to get partitions by name = {}.{}.{}", new Object[]{dbName, tableName, partName});
            throw new MetaException(e.toString());
        }
    }
}

