/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.events;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.events.PreAlterDataConnectorEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizableEvent;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlterDataConnectorEvent
extends HiveMetaStoreAuthorizableEvent {
    private static final Logger LOG = LoggerFactory.getLogger(AlterDataConnectorEvent.class);
    private String COMMAND_STR = "alter connector";

    public AlterDataConnectorEvent(PreEventContext preEventContext) {
        super(preEventContext);
    }

    @Override
    public HiveMetaStoreAuthzInfo getAuthzContext() {
        HiveMetaStoreAuthzInfo ret = new HiveMetaStoreAuthzInfo(this.preEventContext, HiveOperationType.ALTERDATACONNECTOR, this.getInputHObjs(), this.getOutputHObjs(), this.COMMAND_STR);
        return ret;
    }

    private List<HivePrivilegeObject> getInputHObjs() {
        LOG.debug("==> AlterDataConnectorEvent.getInputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterDataConnectorEvent event = (PreAlterDataConnectorEvent)this.preEventContext;
        DataConnector connector = event.getOldDataConnector();
        if (connector != null) {
            ret.add(this.getHivePrivilegeObject(connector));
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, connector);
            LOG.debug("<== AlterDataConnectorEvent.getInputHObjs(): ret={}", ret);
        }
        return ret;
    }

    private List<HivePrivilegeObject> getOutputHObjs() {
        LOG.debug("==> AlterDataConnectorEvent.getOutputHObjs()");
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        PreAlterDataConnectorEvent event = (PreAlterDataConnectorEvent)this.preEventContext;
        DataConnector connector = event.getNewDataConnector();
        if (connector != null) {
            ret.add(this.getHivePrivilegeObject(connector));
            this.COMMAND_STR = this.buildCommandString(this.COMMAND_STR, connector);
            LOG.debug("<== AlterDataConnectorEvent.getOutputHObjs(): ret={}", ret);
        }
        return ret;
    }

    private String buildCommandString(String cmdStr, DataConnector connector) {
        Object ret = cmdStr;
        if (connector != null) {
            String dcName = connector.getName();
            ret = (String)ret + (String)(StringUtils.isNotEmpty((CharSequence)dcName) ? " " + dcName : "");
        }
        return ret;
    }
}

