/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionDistinctMerger
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger(UnionDistinctMerger.class);
    private static final String PATTERN_STRING = UnionOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + UnionOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%";

    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> testRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        testRules.put(new RuleRegExp("AdjacentDistinctUnion", PATTERN_STRING), new UnionMergeProcessor(this));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, testRules, new UnionMergeContext(pCtx));
        NoSkipGraphWalker ogw = new NoSkipGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private class UnionMergeProcessor
    implements SemanticNodeProcessor {
        private UnionMergeProcessor(UnionDistinctMerger unionDistinctMerger) {
        }

        @Override
        public Void process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            UnionMergeContext context = (UnionMergeContext)procCtx;
            HashSet<Operator> allOps = new HashSet<Operator>(context.pCtx.getAllOps());
            for (int i = 1; i <= 8; ++i) {
                Operator op = (Operator)stack.get(stack.size() - i);
                if (!allOps.contains(op)) {
                    return null;
                }
                if (i == 1 || op.getChildOperators().size() <= 1) continue;
                return null;
            }
            UnionOperator upperUnionOperator = (UnionOperator)stack.get(stack.size() - 8);
            GroupByOperator upperFinalGroupByOperator = (GroupByOperator)stack.get(stack.size() - 5);
            UnionOperator lowerUnionOperator = (UnionOperator)stack.get(stack.size() - 4);
            GroupByOperator lowerFinalGroupByOperator = (GroupByOperator)stack.get(stack.size() - 1);
            if (((GroupByDesc)upperFinalGroupByOperator.getConf()).getAggregators().isEmpty() && ((GroupByDesc)lowerFinalGroupByOperator.getConf()).getAggregators().isEmpty()) {
                LOG.info("Detect duplicate UNION-DISTINCT GBY patterns. Remove the latter one.");
                lowerUnionOperator.removeParent(upperFinalGroupByOperator);
                for (Operator<OperatorDesc> lowerUnionParent : lowerUnionOperator.getParentOperators()) {
                    lowerUnionParent.replaceChild(lowerUnionOperator, upperUnionOperator);
                    upperUnionOperator.getParentOperators().add(lowerUnionParent);
                }
                lowerUnionOperator.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
                for (Operator<OperatorDesc> lowerFinalGroupByChild : lowerFinalGroupByOperator.getChildOperators()) {
                    lowerFinalGroupByChild.replaceParent(lowerFinalGroupByOperator, upperFinalGroupByOperator);
                    upperFinalGroupByOperator.getChildOperators().add(lowerFinalGroupByChild);
                }
                ((UnionDesc)upperUnionOperator.getConf()).setNumInputs(upperUnionOperator.getNumParent());
            }
            return null;
        }
    }

    private static class UnionMergeContext
    implements NodeProcessorCtx {
        public final ParseContext pCtx;

        public UnionMergeContext(ParseContext pCtx) {
            this.pCtx = pCtx;
        }
    }

    private static class NoSkipGraphWalker
    extends DefaultGraphWalker {
        public NoSkipGraphWalker(SemanticDispatcher disp) {
            super(disp);
        }

        @Override
        public void startWalking(Collection<Node> startNodes, HashMap<Node, Object> nodeOutput) throws SemanticException {
            this.toWalk.addAll(startNodes);
            while (!this.toWalk.isEmpty()) {
                Node nd = (Node)this.toWalk.remove(0);
                this.walk(nd);
                this.retMap.clear();
            }
        }
    }
}

