/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewMetadata.class);
    final CreationMetadata creationMetadata;

    MaterializedViewMetadata(CreationMetadata creationMetadata) {
        this.creationMetadata = creationMetadata;
    }

    public MaterializedViewMetadata(String catalogName, String dbName, String mvName, Set<SourceTable> sourceTables, MaterializationSnapshot snapshot) {
        this.creationMetadata = new CreationMetadata(catalogName, dbName, mvName, this.toFullTableNames(sourceTables));
        this.creationMetadata.setValidTxnList(snapshot.asJsonString());
        this.creationMetadata.setSourceTables(Collections.unmodifiableList(new ArrayList<SourceTable>(sourceTables)));
    }

    public Set<String> getSourceTableFullNames() {
        if (!this.creationMetadata.isSetSourceTables()) {
            return Collections.emptySet();
        }
        return this.toFullTableNames(this.creationMetadata.getSourceTables());
    }

    private Set<String> toFullTableNames(Collection<SourceTable> sourceTables) {
        return Collections.unmodifiableSet(sourceTables.stream().map(sourceTable -> TableName.getDbTable((String)sourceTable.getTable().getDbName(), (String)sourceTable.getTable().getTableName())).collect(Collectors.toSet()));
    }

    public Set<TableName> getSourceTableNames() {
        if (!this.creationMetadata.isSetSourceTables()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.creationMetadata.getSourceTables().stream().map(sourceTable -> new TableName(sourceTable.getTable().getCatName(), sourceTable.getTable().getDbName(), sourceTable.getTable().getTableName())).collect(Collectors.toSet()));
    }

    public Collection<SourceTable> getSourceTables() {
        if (!this.creationMetadata.isSetSourceTables()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableList(this.creationMetadata.getSourceTables());
    }

    public MaterializationSnapshot getSnapshot() {
        if (this.creationMetadata.getValidTxnList() == null || this.creationMetadata.getValidTxnList().isEmpty()) {
            LOG.debug("Could not obtain materialization snapshot of materialized view {}.{}", (Object)this.creationMetadata.getDbName(), (Object)this.creationMetadata.getTblName());
            return null;
        }
        return MaterializationSnapshot.fromJson((String)this.creationMetadata.getValidTxnList());
    }

    public long getMaterializationTime() {
        return this.creationMetadata.getMaterializationTime();
    }

    public MaterializedViewMetadata reset(MaterializationSnapshot snapshot) {
        Set newSourceTables = this.creationMetadata.getSourceTables().stream().map(this::from).collect(Collectors.toSet());
        return new MaterializedViewMetadata(this.creationMetadata.getCatName(), this.creationMetadata.getDbName(), this.creationMetadata.getTblName(), Collections.unmodifiableSet(newSourceTables), snapshot);
    }

    private SourceTable from(SourceTable sourceTable) {
        SourceTable newSourceTable = new SourceTable();
        newSourceTable.setTable(sourceTable.getTable());
        newSourceTable.setInsertedCount(0L);
        newSourceTable.setUpdatedCount(0L);
        newSourceTable.setDeletedCount(0L);
        return newSourceTable;
    }
}

