/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.CharacterCodingException;
import java.text.ParseException;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFTimestampFieldString;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateParser;

public final class VectorUDFDayOfWeekString
extends VectorUDFTimestampFieldString {
    private static final long serialVersionUID = 1L;

    public VectorUDFDayOfWeekString(int colNum, int outputColumnNum) {
        super(colNum, outputColumnNum, -1, -1);
    }

    public VectorUDFDayOfWeekString() {
    }

    @Override
    protected long getField(byte[] bytes, int start, int length) throws ParseException {
        try {
            String decoded = Text.decode((byte[])bytes, (int)start, (int)length);
            Date date = DateParser.parseDate((String)decoded);
            if (date == null) {
                throw new ParseException("Unable to parse date string", 0);
            }
            return date.getDayOfWeek();
        }
        catch (CharacterCodingException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }
}

