/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TopNKeyFilter;
import org.apache.hadoop.hive.ql.exec.TopNKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TopNKeyDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorTopNKeyDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.slf4j.Logger;

public class VectorTopNKeyOperator
extends Operator<TopNKeyDesc>
implements VectorizationOperator {
    private static final long serialVersionUID = 1L;
    private VectorTopNKeyDesc vectorDesc;
    private VectorizationContext vContext;
    private transient int[] temporarySelected;
    private transient VectorHashKeyWrapperBatch partitionKeyWrapperBatch;
    private transient VectorHashKeyWrapperBatch keyWrappersBatch;
    private transient Map<KeyWrapper, TopNKeyFilter> topNKeyFilters;
    private transient Set<KeyWrapper> disabledPartitions;
    private transient Comparator<VectorHashKeyWrapperBase> keyWrapperComparator;
    private transient long incomingBatches;

    public VectorTopNKeyOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) {
        this(ctx);
        this.conf = (TopNKeyDesc)conf;
        this.vContext = vContext;
        this.vectorDesc = (VectorTopNKeyDesc)vectorDesc;
    }

    @VisibleForTesting
    public VectorTopNKeyOperator() {
    }

    public VectorTopNKeyOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        VectorExpression[] keyExpressions = this.vectorDesc.getKeyExpressions();
        this.initKeyExpressions(hconf, keyExpressions);
        VectorExpression[] partitionKeyExpressions = this.vectorDesc.getPartitionKeyColumns();
        this.initKeyExpressions(hconf, partitionKeyExpressions);
        this.temporarySelected = new int[1024];
        this.keyWrappersBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(keyExpressions);
        this.keyWrapperComparator = this.keyWrappersBatch.getComparator(((TopNKeyDesc)this.conf).getColumnSortOrder(), ((TopNKeyDesc)this.conf).getNullOrder());
        this.partitionKeyWrapperBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(partitionKeyExpressions);
        this.topNKeyFilters = new HashMap<KeyWrapper, TopNKeyFilter>();
        this.disabledPartitions = new HashSet<KeyWrapper>();
        this.incomingBatches = 0L;
    }

    private void initKeyExpressions(Configuration hconf, VectorExpression[] keyExpressions) throws HiveException {
        VectorExpression.doTransientInit(keyExpressions, hconf);
        for (VectorExpression keyExpression : keyExpressions) {
            keyExpression.init(hconf);
        }
    }

    @Override
    public void process(Object data, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)data;
        if (!this.disabledPartitions.isEmpty() && this.disabledPartitions.size() == this.topNKeyFilters.size()) {
            this.vectorForward(batch);
            return;
        }
        ++this.incomingBatches;
        System.arraycopy(batch.selected, 0, this.temporarySelected, 0, batch.selected.length);
        int[] selectedBackup = batch.selected;
        batch.selected = this.temporarySelected;
        int sizeBackup = batch.size;
        boolean selectedInUseBackup = batch.selectedInUse;
        for (VectorExpression keyExpression : this.vectorDesc.getKeyExpressions()) {
            keyExpression.evaluate(batch);
        }
        this.partitionKeyWrapperBatch.evaluateBatch(batch);
        VectorHashKeyWrapperBase[] partitionKeyWrappers = this.partitionKeyWrapperBatch.getVectorHashKeyWrappers();
        this.keyWrappersBatch.evaluateBatch(batch);
        VectorHashKeyWrapperBase[] keyWrappers = this.keyWrappersBatch.getVectorHashKeyWrappers();
        int size = 0;
        int[] selected = new int[batch.selected.length];
        for (int i = 0; i < batch.size; ++i) {
            int j = batch.selectedInUse ? batch.selected[i] : i;
            VectorHashKeyWrapperBase partitionKey = partitionKeyWrappers[i];
            if (this.disabledPartitions.contains(partitionKey)) {
                selected[size++] = j;
                continue;
            }
            TopNKeyFilter topNKeyFilter = this.topNKeyFilters.get(partitionKey);
            if (topNKeyFilter == null && this.topNKeyFilters.size() < ((TopNKeyDesc)this.conf).getMaxNumberOfPartitions()) {
                topNKeyFilter = new TopNKeyFilter(((TopNKeyDesc)this.conf).getTopN(), this.keyWrapperComparator);
                this.topNKeyFilters.put(partitionKey.copyKey(), topNKeyFilter);
            }
            if (topNKeyFilter != null && !topNKeyFilter.canForward(keyWrappers[i])) continue;
            selected[size++] = j;
        }
        if (batch.size != size) {
            batch.selectedInUse = true;
            batch.selected = selected;
            batch.size = size;
        }
        if (size > 0) {
            this.vectorForward(batch);
        }
        batch.selected = selectedBackup;
        batch.size = sizeBackup;
        batch.selectedInUse = selectedInUseBackup;
        if (this.incomingBatches % ((TopNKeyDesc)this.conf).getCheckEfficiencyNumBatches() == 0L) {
            VectorTopNKeyOperator.checkTopNFilterEfficiency(this.topNKeyFilters, this.disabledPartitions, ((TopNKeyDesc)this.conf).getEfficiencyThreshold(), this.LOG, ((TopNKeyDesc)this.conf).getCheckEfficiencyNumRows());
        }
    }

    public static void checkTopNFilterEfficiency(Map<KeyWrapper, TopNKeyFilter> filters, Set<KeyWrapper> disabledPartitions, float efficiencyThreshold, Logger log, long checkEfficiencyNumRows) {
        for (Map.Entry<KeyWrapper, TopNKeyFilter> each : filters.entrySet()) {
            KeyWrapper partitionKey = each.getKey();
            TopNKeyFilter filter = each.getValue();
            log.debug("Checking TopN Filter efficiency {}, threshold: {}", (Object)filter, (Object)Float.valueOf(efficiencyThreshold));
            if (filter.getTotal() < checkEfficiencyNumRows || !(filter.forwardingRatio() >= efficiencyThreshold)) continue;
            log.info("Disabling TopN Filter {}", (Object)filter);
            disabledPartitions.add(partitionKey);
        }
    }

    @Override
    public VectorizationContext getInputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public VectorDesc getVectorDesc() {
        return this.vectorDesc;
    }

    @Override
    public void setNextVectorBatchGroupStatus(boolean isLastGroupBatch) throws HiveException {
        for (Operator op : this.childOperators) {
            op.setNextVectorBatchGroupStatus(isLastGroupBatch);
        }
    }

    @Override
    public String getName() {
        return TopNKeyOperator.getOperatorName();
    }

    @Override
    public OperatorType getType() {
        return OperatorType.TOPNKEY;
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (this.topNKeyFilters.size() == 1) {
            TopNKeyFilter filter = this.topNKeyFilters.values().iterator().next();
            this.LOG.info("Closing TopNKeyFilter: {}", (Object)filter);
            filter.clear();
        } else {
            this.LOG.info("Closing {} TopNKeyFilters", (Object)this.topNKeyFilters.size());
            for (TopNKeyFilter each : this.topNKeyFilters.values()) {
                this.LOG.debug("Closing TopNKeyFilter: {}", (Object)each);
                each.clear();
            }
        }
        this.topNKeyFilters.clear();
        this.disabledPartitions.clear();
        super.closeOp(abort);
    }

    @Override
    public boolean supportSkewJoinOptimization() {
        return true;
    }

    @Override
    public boolean columnNamesRowResolvedCanBeObtained() {
        return true;
    }

    @Override
    public boolean supportAutomaticSortMergeJoin() {
        return true;
    }

    @Override
    public boolean supportUnionRemoveOptimization() {
        return true;
    }
}

