/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.show;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.ddl.database.show.ShowDatabasesFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.io.IOUtils;

public class ShowDatabasesOperation
extends DDLOperation<ShowDatabasesDesc> {
    public ShowDatabasesOperation(DDLOperationContext context, ShowDatabasesDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        List<String> databases = this.context.getDb().getAllDatabases();
        if (((ShowDatabasesDesc)this.desc).getPattern() != null) {
            LOG.debug("pattern: {}", (Object)((ShowDatabasesDesc)this.desc).getPattern());
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowDatabasesDesc)this.desc).getPattern()), 2);
            databases = databases.stream().filter(name -> pattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
        }
        LOG.info("Found {} database(s) matching the SHOW DATABASES statement.", (Object)databases.size());
        DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowDatabasesDesc)this.desc).getResFile()), this.context);
        try {
            ShowDatabasesFormatter formatter = ShowDatabasesFormatter.getFormatter(this.context.getConf());
            formatter.showDatabases(outStream, databases);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show databases"});
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

