/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.security;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    public static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);

    public static String getPassword(Configuration config, String key) throws IOException {
        return SecurityUtil.getPassword(config, key, "cert.stores.credential.provider.path");
    }

    public static String getPassword(Configuration config, String key, String pathPropertyName) throws IOException {
        CredentialProvider.CredentialEntry entry;
        String provider = config.getString(pathPropertyName);
        if (provider != null) {
            LOG.info("Attempting to retrieve password for key {} from {} configured credential provider path {}", new Object[]{key, pathPropertyName, provider});
            org.apache.hadoop.conf.Configuration c = new org.apache.hadoop.conf.Configuration();
            c.set("hadoop.security.credential.provider.path", provider);
            CredentialProvider credentialProvider = (CredentialProvider)CredentialProviderFactory.getProviders((org.apache.hadoop.conf.Configuration)c).get(0);
            entry = credentialProvider.getCredentialEntry(key);
            if (entry == null) {
                throw new IOException(String.format("No credential entry found for %s. Please create an entry in the configured credential provider", key));
            }
        } else {
            throw new IOException("No credential provider path " + pathPropertyName + " configured for storage of certificate store passwords");
        }
        String password = String.valueOf(entry.getCredential());
        return password;
    }
}

