/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.conf;

public interface Validator {
    public void validate(String var1) throws IllegalArgumentException;

    public static enum TYPE {
        INT{

            @Override
            protected boolean inRange(String value, Object lower, Object upper) {
                int ivalue = Integer.parseInt(value);
                if (lower != null && ivalue < (Integer)lower) {
                    return false;
                }
                return upper == null || ivalue <= (Integer)upper;
            }
        }
        ,
        LONG{

            @Override
            protected boolean inRange(String value, Object lower, Object upper) {
                long lvalue = Long.parseLong(value);
                if (lower != null && lvalue < (Long)lower) {
                    return false;
                }
                return upper == null || lvalue <= (Long)upper;
            }
        }
        ,
        FLOAT{

            @Override
            protected boolean inRange(String value, Object lower, Object upper) {
                float fvalue = Float.parseFloat(value);
                if (lower != null && fvalue < ((Float)lower).floatValue()) {
                    return false;
                }
                return upper == null || !(fvalue > ((Float)upper).floatValue());
            }
        };


        public static TYPE valueOf(Object lower, Object upper) {
            if (lower instanceof Integer || upper instanceof Integer) {
                return INT;
            }
            if (lower instanceof Long || upper instanceof Long) {
                return LONG;
            }
            if (lower instanceof Float || upper instanceof Float) {
                return FLOAT;
            }
            throw new IllegalArgumentException("invalid range from " + String.valueOf(lower) + " to " + String.valueOf(upper));
        }

        protected abstract boolean inRange(String var1, Object var2, Object var3);
    }
}

