/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.dispatch.unit.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.collector.dispatch.unit.UnitConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnitConvert
implements UnitConvert {
    private static final Logger log = LoggerFactory.getLogger(AbstractUnitConvert.class);

    @Override
    public String convert(String value, String originUnit, String newUnit) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (!this.checkUnit(originUnit) || !this.checkUnit(newUnit)) {
            return null;
        }
        if (originUnit.equalsIgnoreCase(newUnit)) {
            log.warn("The origin unit is the same as the new unit, no need to convert");
            return value;
        }
        BigDecimal wrappedValue = new BigDecimal(value);
        Map<String, Long> unitMap = this.convertUnitEnumToMap();
        Long multipleScale = unitMap.get(originUnit.toUpperCase());
        wrappedValue = wrappedValue.multiply(new BigDecimal(multipleScale));
        Long divideScale = unitMap.get(newUnit.toUpperCase());
        wrappedValue = wrappedValue.divide(new BigDecimal(divideScale), 12, RoundingMode.HALF_UP);
        return wrappedValue.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    @Override
    public boolean checkUnit(String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return false;
        }
        Map<String, Long> convertedUnitEnumToMap = this.convertUnitEnumToMap();
        return convertedUnitEnumToMap.containsKey(unit.toUpperCase());
    }

    abstract Map<String, Long> convertUnitEnumToMap();
}

