/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;

public abstract class TransportIpAddress
extends IpAddress {
    private static final LogAdapter logger = LogFactory.getLogger(TransportIpAddress.class);
    static final long serialVersionUID = 695596530250216972L;
    protected int port = 0;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port specified: " + port);
        }
        this.port = port;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.port >= 0 && this.port <= 65535;
    }

    @Override
    public int compareTo(Variable o) {
        int result = super.compareTo(o);
        if (result == 0) {
            return this.port - ((TransportIpAddress)o).getPort();
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof TransportIpAddress && super.equals(o) && ((TransportIpAddress)o).getPort() == this.port;
    }

    @Override
    public boolean parseAddress(String address) {
        try {
            StringTokenizer st = new StringTokenizer(address, "/");
            String addr = st.nextToken();
            String port = st.nextToken();
            if (super.parseAddress(addr)) {
                this.port = Integer.parseInt(port);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Address parse(String address) {
        UdpAddress a = new UdpAddress();
        if (a.parseAddress(address)) {
            return a;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + "/" + this.port;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ 2 + this.port;
    }

    public void setTransportAddress(OctetString transportAddress) throws UnknownHostException {
        OctetString inetAddr = transportAddress.substring(0, transportAddress.length() - 2);
        byte[] addr = inetAddr.getValue();
        if (addr.length == 8 || addr.length == 20) {
            byte[] ipaddr = new byte[addr.length - 4];
            System.arraycopy(addr, 0, ipaddr, 0, ipaddr.length);
            int sz = ipaddr.length;
            int scope = (addr[sz] << 24) + ((addr[sz + 1] & 0xFF) << 16) + ((addr[sz + 2] & 0xFF) << 8) + (addr[sz + 3] & 0xFF);
            try {
                Class[] params = new Class[]{String.class, byte[].class, Integer.TYPE};
                Method m = Inet6Address.class.getMethod("getByAddress", params);
                Object[] args = new Object[]{null, ipaddr, scope};
                Object o = m.invoke(Inet6Address.class, args);
                this.setInetAddress((InetAddress)o);
            }
            catch (Exception ex) {
                logger.warn((Serializable)((Object)("Java < 1.5 does not support scoped IPv6 addresses, ignoring scope ID for " + transportAddress)));
                this.setInetAddress(InetAddress.getByAddress(ipaddr));
            }
        } else {
            this.setInetAddress(InetAddress.getByAddress(addr));
        }
        this.port = (transportAddress.get(transportAddress.length() - 2) & 0xFF) << 8;
        this.port += transportAddress.get(transportAddress.length() - 1) & 0xFF;
    }

    public byte[] getValue() {
        byte[] addr = this.getInetAddress().getAddress();
        int scopeSize = 0;
        int scopeID = 0;
        if (this.getInetAddress() instanceof Inet6Address) {
            try {
                Inet6Address ip6Addr = (Inet6Address)this.getInetAddress();
                Method m = Inet6Address.class.getMethod("getScopeId", new Class[0]);
                Object scope = m.invoke((Object)ip6Addr, new Object[0]);
                scopeID = ((Number)scope).intValue();
                scopeSize = 4;
            }
            catch (Exception ip6Addr) {
                // empty catch block
            }
        }
        byte[] retval = new byte[addr.length + 2 + scopeSize];
        System.arraycopy(addr, 0, retval, 0, addr.length);
        int offset = addr.length;
        if (scopeSize > 0) {
            retval[offset++] = (byte)((scopeID & 0xFF000000) >> 24);
            retval[offset++] = (byte)((scopeID & 0xFF0000) >> 16);
            retval[offset++] = (byte)((scopeID & 0xFF00) >> 8);
            retval[offset++] = (byte)(scopeID & 0xFF);
        }
        retval[offset++] = (byte)(this.port >> 8 & 0xFF);
        retval[offset] = (byte)(this.port & 0xFF);
        return retval;
    }

    @Override
    public void decodeBER(BERInputStream inputStream) throws IOException {
        OctetString os = new OctetString();
        os.decodeBER(inputStream);
        try {
            this.setTransportAddress(os);
        }
        catch (Exception ex) {
            String txt = "Wrong encoding of TransportAddress";
            logger.error((Serializable)((Object)txt));
            throw new IOException(txt + ": " + ex.getMessage());
        }
    }

    @Override
    public void encodeBER(OutputStream outputStream) throws IOException {
        OctetString os = new OctetString(this.getValue());
        os.encodeBER(outputStream);
    }

    @Override
    public int getBERLength() {
        return this.getValue().length;
    }

    @Override
    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    @Override
    public int getSyntax() {
        return 4;
    }
}

