/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.warehouse.db;

import org.apache.hertzbeat.warehouse.db.PromqlQueryExecutor;
import org.apache.hertzbeat.warehouse.store.history.tsdb.greptime.GreptimeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component(value="greptimePromqlQueryExecutor")
@ConditionalOnProperty(prefix="warehouse.store.greptime", name={"enabled"}, havingValue="true")
public class GreptimePromqlQueryExecutor
extends PromqlQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(GreptimePromqlQueryExecutor.class);
    private static final String QUERY_PATH = "/v1/prometheus";
    private static final String Datasource = "Greptime-promql";
    private final GreptimeProperties greptimeProperties;

    public GreptimePromqlQueryExecutor(GreptimeProperties greptimeProperties, RestTemplate restTemplate) {
        super(restTemplate, new PromqlQueryExecutor.HttpPromqlProperties(greptimeProperties.httpEndpoint() + QUERY_PATH, greptimeProperties.username(), greptimeProperties.password()));
        this.greptimeProperties = greptimeProperties;
    }

    @Override
    public String getDatasource() {
        return Datasource;
    }
}

