/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.pool;

import com.xugu.cloudjdbc.Connection;
import com.xugu.cloudjdbc.Error;
import com.xugu.pool.BaseSql;
import com.xugu.pool.CallableStatementWrapper;
import com.xugu.pool.PreparedStatementWrapper;
import com.xugu.pool.XgPooledConnection;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

public class ConnectionWrapper
extends BaseSql {
    private Connection xc = null;
    private XgPooledConnection xpc = null;
    private long startTime = 0L;
    private final Object mutex = new Object();
    private boolean isDirectConn = false;
    private String invalidHandleStr = "\u903b\u8f91\u8fde\u63a5\u4e0d\u518d\u6709\u6548";
    private boolean closed;

    public ConnectionWrapper(XgPooledConnection xgPConnection, Connection xgConn, boolean isD) {
        this.xc = xgConn;
        this.xpc = xgPConnection;
        this.isDirectConn = isD;
        this.closed = this.xc.isClosed();
        this.xgPConn = this.xpc;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.xc.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.close(true);
    }

    @Override
    public void commit() throws SQLException {
        this.xc.commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return this.xc.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return this.xc.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return this.xc.createClob();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return this.xc.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return this.xc.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return this.xc.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        try {
            return this.xc.createStruct(typeName, attributes);
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return this.xc.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.xc.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        try {
            return this.xc.getClientInfo();
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        try {
            return this.xc.getClientInfo(name);
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return this.xc.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return this.xc.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.xc.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return 0;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkClosed();
        try {
            return this.xc.getTypeMap();
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        try {
            return this.xc.getWarnings();
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.xc.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.xc.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        try {
            return this.xc.isValid(timeout);
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return false;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        try {
            return this.xc.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new CallableStatementWrapper(this, this.xpc, this.xc.prepareCall(sql));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new CallableStatementWrapper(this, this.xpc, this.xc.prepareCall(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new CallableStatementWrapper(this, this.xpc, this.xc.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql, autoGeneratedKeys));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql, columnIndexes));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql, columnNames));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql, resultSetType, resultSetConcurrency));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new PreparedStatementWrapper(this, this.xpc, this.xc.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
            return null;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkClosed();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.xc.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.xc.rollback();
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        try {
            this.xc.rollback(savepoint);
        }
        catch (SQLException e) {
            this.checkAndFireConnectionError(e);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        this.xc.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.xc.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        this.xc.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.xc.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        return this.xc.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        return this.xc.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.xc.setTransactionIsolation(level);
    }

    public Object unwrap(Class iface) throws SQLException {
        this.checkClosed();
        return this.xc.unwrap(iface);
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw Error.createSQLException("[E50074]" + this.invalidHandleStr, "xugu :50074", 50074);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close(boolean closeEvent) throws SQLException {
        SQLException sqlEx = null;
        Object object = this.getMutex();
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (!this.getAutoCommit()) {
                try {
                    this.rollback();
                }
                catch (SQLException ex) {
                    sqlEx = ex;
                }
            }
            try {
                this.xc.closeAllOpenStatements();
            }
            catch (SQLException ex) {
                sqlEx = ex;
            }
            if (this.isDirectConn) {
                this.xc.close();
            } else {
                this.xc.clearBuffer();
                this.xc.getIO().resumeConnectState();
                this.sqlE = null;
                this.autoCommit = true;
                this.openStatements = null;
            }
            if (closeEvent) {
                this.xpc.callListener(1, null, this);
            } else {
                this.xc.close();
                this.closed = true;
            }
        }
    }

    boolean getIsDirect() {
        return this.isDirectConn;
    }

    long getStartTime() {
        return this.startTime;
    }

    Object getMutex() {
        return this.mutex;
    }
}

