/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Utf16Sink
extends CharSink<Utf16Sink> {
    default public Utf16Sink escapeJsonStr(@NotNull CharSequence cs) {
        return this.escapeJsonStr(cs, 0, cs.length());
    }

    default public Utf16Sink escapeJsonStr(@NotNull CharSequence cs, int lo, int hi) {
        int i = lo;
        while (i < hi) {
            char c;
            if ((c = cs.charAt(i++)) < ' ') {
                this.escapeJsonStrChar(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    this.putAscii('\\');
                }
            }
            this.put(c);
        }
        return this;
    }

    @Override
    default public int getEncoding() {
        return 16;
    }

    @Override
    default public Utf16Sink put(@Nullable Utf8Sequence us) {
        if (us != null) {
            Utf8s.utf8ToUtf16(us, this);
        }
        return this;
    }

    default public Utf16Sink put(@Nullable Utf8Sequence us, int lo, int hi) {
        if (us != null) {
            Utf8s.utf8ToUtf16(us, lo, hi, this);
        }
        return this;
    }

    default public Utf16Sink put(long lo, long hi) {
        for (long addr = lo; addr < hi; addr += 2L) {
            this.put(Unsafe.getUnsafe().getChar(addr));
        }
        return this;
    }

    default public Utf16Sink put(char @NotNull [] chars, int start, int len) {
        for (int i = 0; i < len; ++i) {
            this.put(chars[i + start]);
        }
        return this;
    }

    default public void putAsPrintable(CharSequence nonPrintable) {
        int n = nonPrintable.length();
        for (int i = 0; i < n; ++i) {
            char c = nonPrintable.charAt(i);
            this.putAsPrintable(c);
        }
    }

    default public void putAsPrintable(char c) {
        if (c > '\u001f' && c != '\u007f') {
            this.put(c);
        } else {
            this.put('\\');
            this.put('u');
            int s = c & 0xFF;
            this.put('0');
            this.put('0');
            this.put(Numbers.hexDigits[s / 16]);
            this.put(Numbers.hexDigits[s % 16]);
        }
    }

    @Override
    default public Utf16Sink putAscii(char c) {
        return (Utf16Sink)this.put(c);
    }

    @Override
    default public Utf16Sink putAscii(@Nullable CharSequence cs) {
        return (Utf16Sink)this.put(cs);
    }

    @Override
    default public Utf16Sink putNonAscii(long lo, long hi) {
        Utf8s.utf8ToUtf16(lo, hi, this);
        return this;
    }

    default public Utf16Sink repeat(@NotNull CharSequence value, int n) {
        for (int i = 0; i < n; ++i) {
            this.put(value);
        }
        return this;
    }
}

