/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.std.Numbers;
import io.questdb.std.datetime.microtime.TimestampFormatUtils;
import io.questdb.std.datetime.millitime.DateFormatUtils;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CharSink<T extends CharSink<?>> {
    default public void escapeJsonStrChar(char c) {
        switch (c) {
            case '\b': {
                this.putAscii("\\b");
                break;
            }
            case '\f': {
                this.putAscii("\\f");
                break;
            }
            case '\n': {
                this.putAscii("\\n");
                break;
            }
            case '\r': {
                this.putAscii("\\r");
                break;
            }
            case '\t': {
                this.putAscii("\\t");
                break;
            }
            default: {
                this.putAscii("\\u00");
                this.put(c >> 4);
                this.putAscii(Numbers.hexDigits[c & 0xF]);
            }
        }
    }

    default public void fillAscii(char c, int n) {
        for (int i = 0; i < n; ++i) {
            this.putAscii(c);
        }
    }

    public int getEncoding();

    default public T put(@NotNull CharSequence cs, int lo, int hi) {
        for (int i = lo; i < hi; ++i) {
            this.put(cs.charAt(i));
        }
        return (T)this;
    }

    default public T put(@Nullable Sinkable sinkable) {
        if (sinkable != null) {
            sinkable.toSink(this);
        }
        return (T)this;
    }

    public T put(char var1);

    default public T put(@Nullable CharSequence cs) {
        if (cs != null) {
            int n = cs.length();
            for (int i = 0; i < n; ++i) {
                this.put(cs.charAt(i));
            }
        }
        return (T)this;
    }

    public T put(@Nullable Utf8Sequence var1);

    default public T put(int value) {
        Numbers.append(this, value);
        return (T)this;
    }

    default public T put(long value) {
        Numbers.append(this, value);
        return (T)this;
    }

    default public T put(float value) {
        Numbers.append(this, value);
        return (T)this;
    }

    default public T put(double value) {
        Numbers.append(this, value);
        return (T)this;
    }

    default public T put(boolean value) {
        return this.putAscii(value ? "true" : "false");
    }

    public T putAscii(char var1);

    public T putAscii(@Nullable CharSequence var1);

    default public T putAscii(char @NotNull [] chars, int start, int len) {
        for (int i = 0; i < len; ++i) {
            this.putAscii(chars[i + start]);
        }
        return (T)this;
    }

    default public T putAscii(@NotNull CharSequence cs, int start, int len) {
        for (int i = start; i < len; ++i) {
            this.putAscii(cs.charAt(i));
        }
        return (T)this;
    }

    default public T putAsciiQuoted(@NotNull CharSequence cs) {
        this.putAscii('\"').putAscii(cs).putAscii('\"');
        return (T)this;
    }

    default public T putEOL() {
        return this.putAscii("\r\n");
    }

    default public T putISODate(long value) {
        TimestampFormatUtils.appendDateTimeUSec(this, value);
        return (T)this;
    }

    default public T putISODateMillis(long value) {
        DateFormatUtils.appendDateTime(this, value);
        return (T)this;
    }

    public T putNonAscii(long var1, long var3);

    default public T putQuoted(@NotNull CharSequence cs) {
        this.putAscii('\"').put(cs).putAscii('\"');
        return (T)this;
    }

    default public T putQuoted(@NotNull Utf8Sequence cs) {
        this.putAscii('\"').put(cs).putAscii('\"');
        return (T)this;
    }

    default public T putSize(long bytes) {
        long b;
        long l = b = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        return b < 1024L ? this.put(bytes).put(' ').put('B') : (b <= 1048524L ? this.put((double)Math.round((double)bytes / 1024.0 * 1000.0) / 1000.0).put(" KiB") : (b <= 0x3FFF3333L ? this.put((double)Math.round((double)bytes / 1048576.0 * 1000.0) / 1000.0).put(" MiB") : (b <= 0xFFFCCCCCCCL ? this.put((double)Math.round((double)bytes / 1.073741824E9 * 1000.0) / 1000.0).put(" GiB") : (b <= 0x3FFF333333333L ? this.put((double)Math.round((double)bytes / 1.099511627776E12 * 1000.0) / 1000.0).put(" TiB") : (b <= 0xFFFCCCCCCCCCCCCL ? this.put((double)Math.round((double)(bytes >> 10) / 1.099511627776E12 * 1000.0) / 1000.0).put(" PiB") : this.put((double)Math.round((double)(bytes >> 20) / 1.099511627776E12 * 1000.0) / 1000.0).put(" EiB"))))));
    }
}

