/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractUtf8SequenceHashSet;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8s;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utf8SequenceHashSet
extends AbstractUtf8SequenceHashSet
implements Sinkable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final ObjList<Utf8Sequence> list = new ObjList(this.free);
    private boolean hasNull = false;

    public Utf8SequenceHashSet() {
        this(16);
    }

    public Utf8SequenceHashSet(Utf8SequenceHashSet that) {
        this(that.capacity, that.loadFactor);
        this.addAll(that);
    }

    public Utf8SequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.4);
    }

    public Utf8SequenceHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.clear();
    }

    public boolean add(@Nullable Utf8Sequence key) {
        if (key == null) {
            return this.addNull();
        }
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public final void addAll(@NotNull Utf8SequenceHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    public void addAt(int index, @NotNull Utf8Sequence key) {
        Utf8String s = Utf8s.toUtf8String(key);
        this.keys[index] = s;
        this.hashCodes[index] = Utf8s.hashCode(key);
        this.list.add(s);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    public boolean addNull() {
        if (this.hasNull) {
            return false;
        }
        --this.free;
        this.hasNull = true;
        this.list.add(null);
        return true;
    }

    @Override
    public final void clear() {
        Arrays.fill(this.keys, null);
        this.free = this.capacity;
        this.list.clear();
        this.hasNull = false;
    }

    @Override
    public boolean contains(@Nullable Utf8Sequence key) {
        return key == null ? this.hasNull : this.keyIndex(key) < 0;
    }

    @Override
    public boolean excludes(@Nullable Utf8Sequence key) {
        return key == null ? !this.hasNull : this.keyIndex(key) > -1;
    }

    public Utf8Sequence get(int index) {
        return this.list.getQuick(index);
    }

    public Utf8Sequence getLast() {
        return this.list.getLast();
    }

    public ObjList<Utf8Sequence> getList() {
        return this.list;
    }

    @Override
    public Utf8Sequence keyAt(int index) {
        int index1 = -index - 1;
        return this.keys[index1];
    }

    @Override
    public int remove(@Nullable Utf8Sequence key) {
        if (key == null) {
            return this.removeNull();
        }
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            Utf8Sequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public int removeNull() {
        if (this.hasNull) {
            this.hasNull = false;
            int index = this.list.remove(null);
            ++this.free;
            return index;
        }
        return -1;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put(this.list);
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity;
        int size = this.size();
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        Utf8Sequence[] oldKeys = this.keys;
        int[] oldHashCodes = this.hashCodes;
        this.keys = new Utf8Sequence[len];
        this.hashCodes = new int[len];
        Arrays.fill(this.keys, null);
        this.mask = len - 1;
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            Utf8Sequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.hashCodes[index] = oldHashCodes[i];
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.hashCodes[index] = 0;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.hashCodes[to] = this.hashCodes[from];
        this.erase(from);
    }
}

