/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import java.util.Arrays;

public abstract class AbstractLongHashSet
implements Mutable {
    protected static final int MIN_INITIAL_CAPACITY = 16;
    protected static final long noEntryKey = -1L;
    protected final int initialCapacity;
    protected final double loadFactor;
    protected final long noEntryKeyValue;
    protected int capacity;
    protected int free;
    protected long[] keys;
    protected int mask;

    public AbstractLongHashSet(int initialCapacity, double loadFactor) {
        this(initialCapacity, loadFactor, -1L);
    }

    public AbstractLongHashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.noEntryKeyValue = noKeyValue;
        this.free = this.capacity = Math.max(initialCapacity, 16);
        this.initialCapacity = this.capacity;
        this.loadFactor = loadFactor;
        this.keys = new long[Numbers.ceilPow2((int)((double)this.capacity / loadFactor))];
        this.mask = this.keys.length - 1;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.free = this.capacity;
    }

    public boolean excludes(long key) {
        return this.keyIndex(key) > -1;
    }

    public int keyIndex(long key) {
        int hashCode = Hash.hashLong32(key);
        int index = hashCode & this.mask;
        if (this.keys[index] == this.noEntryKeyValue) {
            return index;
        }
        if (key == this.keys[index]) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    public int remove(long key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            this.removeAt(index);
            return -index - 1;
        }
        return -1;
    }

    public void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            long key = this.keys[from];
            while (key != this.noEntryKeyValue) {
                int to;
                int hashCode = Hash.hashLong32(key);
                int idealHit = hashCode & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != this.noEntryKeyValue ? this.probe(key, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }

    public void restoreInitialCapacity() {
        this.capacity = this.initialCapacity;
        this.keys = new long[Numbers.ceilPow2((int)((double)this.capacity / this.loadFactor))];
        this.mask = this.keys.length - 1;
        this.clear();
    }

    public int size() {
        return this.capacity - this.free;
    }

    private int probe(long key, int index) {
        do {
            if (this.keys[index = index + 1 & this.mask] != this.noEntryKeyValue) continue;
            return index;
        } while (key != this.keys[index]);
        return -index - 1;
    }

    protected abstract void erase(int var1);

    protected abstract void move(int var1, int var2);
}

