/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemory;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.PartitionFrameCursorFactory;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameReduceTaskFactory;
import io.questdb.cairo.sql.async.PageFrameReducer;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.bind.CompiledFilterSymbolBindVariable;
import io.questdb.griffin.engine.table.AsyncFilterAtom;
import io.questdb.griffin.engine.table.AsyncFilteredNegativeLimitRecordCursor;
import io.questdb.griffin.engine.table.AsyncFilteredRecordCursor;
import io.questdb.griffin.engine.table.FilteredRecordCursorFactory;
import io.questdb.jit.CompiledFilter;
import io.questdb.mp.SCSequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncJitFilteredRecordCursorFactory
extends AbstractRecordCursorFactory {
    private static final PageFrameReducer REDUCER = AsyncJitFilteredRecordCursorFactory::filter;
    private final RecordCursorFactory base;
    private final ObjList<Function> bindVarFunctions;
    private final MemoryCARW bindVarMemory;
    private final SCSequence collectSubSeq = new SCSequence();
    private final CompiledFilter compiledFilter;
    private final AsyncFilteredRecordCursor cursor;
    private final Function filter;
    private final PageFrameSequence<AsyncJitFilterAtom> frameSequence;
    private final Function limitLoFunction;
    private final int limitLoPos;
    private final int maxNegativeLimit;
    private final AsyncFilteredNegativeLimitRecordCursor negativeLimitCursor;
    private final int sharedQueryWorkerCount;
    private DirectLongList negativeLimitRows;

    public AsyncJitFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull MessageBus messageBus, @NotNull RecordCursorFactory base, @NotNull ObjList<Function> bindVarFunctions, @NotNull CompiledFilter compiledFilter, @NotNull Function filter, @NotNull PageFrameReduceTaskFactory reduceTaskFactory, @Nullable ObjList<Function> perWorkerFilters, @Nullable Function limitLoFunction, int limitLoPos, int sharedQueryWorkerCount) {
        super(base.getMetadata());
        assert (!(base instanceof FilteredRecordCursorFactory));
        assert (!(base instanceof AsyncJitFilteredRecordCursorFactory));
        this.base = base;
        this.compiledFilter = compiledFilter;
        this.filter = filter;
        this.cursor = new AsyncFilteredRecordCursor(configuration, filter, base.getScanDirection());
        this.negativeLimitCursor = new AsyncFilteredNegativeLimitRecordCursor(configuration, base.getScanDirection());
        this.bindVarMemory = Vm.getCARWInstance(configuration.getSqlJitBindVarsMemoryPageSize(), configuration.getSqlJitBindVarsMemoryMaxPages(), 37);
        this.bindVarFunctions = bindVarFunctions;
        int columnCount = base.getMetadata().getColumnCount();
        IntList columnTypes = new IntList(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int columnType = base.getMetadata().getColumnType(i);
            columnTypes.add(columnType);
        }
        AsyncJitFilterAtom atom = new AsyncJitFilterAtom(configuration, filter, perWorkerFilters, compiledFilter, this.bindVarMemory, bindVarFunctions, columnTypes);
        this.frameSequence = new PageFrameSequence<AsyncJitFilterAtom>(configuration, messageBus, atom, REDUCER, reduceTaskFactory, sharedQueryWorkerCount, 0);
        this.limitLoFunction = limitLoFunction;
        this.limitLoPos = limitLoPos;
        this.maxNegativeLimit = configuration.getSqlMaxNegativeLimit();
        this.sharedQueryWorkerCount = sharedQueryWorkerCount;
    }

    public static void prepareBindVarMemory(SqlExecutionContext executionContext, SymbolTableSource symbolTableSource, ObjList<Function> bindVarFunctions, MemoryCARW bindVarMemory) throws SqlException {
        if (bindVarFunctions.size() > 0) {
            bindVarMemory.truncate();
            int n = bindVarFunctions.size();
            for (int i = 0; i < n; ++i) {
                Function function = bindVarFunctions.getQuick(i);
                AsyncJitFilteredRecordCursorFactory.writeBindVarFunction(bindVarMemory, function, symbolTableSource, executionContext);
            }
        }
    }

    public PageFrameSequence<AsyncJitFilterAtom> execute(SqlExecutionContext executionContext, SCSequence collectSubSeq, int order) throws SqlException {
        return this.frameSequence.of(this.base, executionContext, collectSubSeq, order);
    }

    @Override
    public boolean followedLimitAdvice() {
        return this.limitLoFunction != null;
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public ObjList<Function> getBindVarFunctions() {
        return this.bindVarFunctions;
    }

    @Override
    public MemoryCARW getBindVarMemory() {
        return this.bindVarMemory;
    }

    @Override
    public CompiledFilter getCompiledFilter() {
        return this.compiledFilter;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        int order;
        long rowsRemaining;
        int baseOrder;
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), executionContext);
            rowsRemaining = this.limitLoFunction.getLong(null);
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = PartitionFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (order != baseOrder && rowsRemaining != Long.MAX_VALUE) {
            if (rowsRemaining > (long)this.maxNegativeLimit) {
                throw SqlException.position(this.limitLoPos).put("absolute LIMIT value is too large, maximum allowed value: ").put(this.maxNegativeLimit);
            }
            if (this.negativeLimitRows == null) {
                this.negativeLimitRows = new DirectLongList(this.maxNegativeLimit, 46);
            }
            this.negativeLimitCursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining, this.negativeLimitRows);
            return this.negativeLimitCursor;
        }
        this.cursor.of(this.execute(executionContext, this.collectSubSeq, order), rowsRemaining);
        return this.cursor;
    }

    @Override
    @NotNull
    public Function getFilter() {
        return this.filter;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public TableToken getTableToken() {
        return this.base.getTableToken();
    }

    @Override
    public void halfClose() {
        Misc.free(this.frameSequence);
        this.cursor.freeRecords();
        this.negativeLimitCursor.freeRecords();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    public boolean supportsFilterStealing() {
        return this.limitLoFunction == null;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.base.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order;
        long rowsRemaining;
        int baseOrder;
        sink.type("Async JIT Filter");
        sink.meta("workers").val(this.sharedQueryWorkerCount);
        int n = baseOrder = this.base.getScanDirection() == 2 ? 1 : 0;
        if (this.limitLoFunction != null) {
            try {
                this.limitLoFunction.init(this.frameSequence.getSymbolTableSource(), sink.getExecutionContext());
                rowsRemaining = this.limitLoFunction.getLong(null);
            }
            catch (Exception e) {
                rowsRemaining = Long.MAX_VALUE;
            }
            if (rowsRemaining > -1L) {
                order = baseOrder;
            } else {
                order = PartitionFrameCursorFactory.reverse(baseOrder);
                rowsRemaining = -rowsRemaining;
            }
        } else {
            rowsRemaining = Long.MAX_VALUE;
            order = baseOrder;
        }
        if (rowsRemaining != Long.MAX_VALUE) {
            sink.attr("limit").val(rowsRemaining);
        }
        sink.attr("filter").val(this.frameSequence.getAtom());
        sink.child(this.base, order);
    }

    @Override
    public boolean usesCompiledFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void filter(int workerId, @NotNull PageFrameMemoryRecord record, @NotNull PageFrameReduceTask task, @NotNull SqlExecutionCircuitBreaker circuitBreaker, @Nullable PageFrameSequence<?> stealingFrameSequence) {
        DirectLongList rows = task.getFilteredRows();
        long frameRowCount = task.getFrameRowCount();
        PageFrameSequence<AsyncJitFilterAtom> frameSequence = task.getFrameSequence(AsyncJitFilterAtom.class);
        AsyncJitFilterAtom atom = frameSequence.getAtom();
        PageFrameMemory frameMemory = task.populateFrameMemory();
        record.init(frameMemory);
        rows.clear();
        if (frameMemory.hasColumnTops()) {
            boolean owner = stealingFrameSequence != null && stealingFrameSequence == task.getFrameSequence();
            int filterId = atom.maybeAcquireFilter(workerId, owner, circuitBreaker);
            Function filter = atom.getFilter(filterId);
            try {
                for (long r = 0L; r < frameRowCount; ++r) {
                    record.setRowIndex(r);
                    if (!filter.getBool(record)) continue;
                    rows.add(r);
                }
                return;
            }
            finally {
                atom.releaseFilter(filterId);
            }
        }
        task.populateJitData();
        DirectLongList dataAddresses = task.getDataAddresses();
        DirectLongList auxAddresses = task.getAuxAddresses();
        long hi = atom.compiledFilter.call(dataAddresses.getAddress(), dataAddresses.size(), auxAddresses.getAddress(), atom.bindVarMemory.getAddress(), atom.bindVarFunctions.size(), rows.getAddress(), frameRowCount, 0L);
        rows.setPos(hi);
        if (frameMemory.getFrameFormat() == 0) {
            atom.preTouchColumns(record, rows, frameRowCount);
        }
    }

    private static void writeBindVarFunction(MemoryCARW bindVarMemory, Function function, SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        int columnType = function.getType();
        short columnTypeTag = ColumnType.tagOf(columnType);
        switch (columnTypeTag) {
            case 1: {
                bindVarMemory.putLong(function.getBool(null) ? 1L : 0L);
                return;
            }
            case 2: {
                bindVarMemory.putLong(function.getByte(null));
                return;
            }
            case 14: {
                bindVarMemory.putLong(function.getGeoByte(null));
                return;
            }
            case 3: {
                bindVarMemory.putLong(function.getShort(null));
                return;
            }
            case 15: {
                bindVarMemory.putLong(function.getGeoShort(null));
                return;
            }
            case 4: {
                bindVarMemory.putLong(function.getChar(null));
                return;
            }
            case 5: {
                bindVarMemory.putLong(function.getInt(null));
                return;
            }
            case 25: {
                bindVarMemory.putLong(function.getIPv4(null));
                return;
            }
            case 16: {
                bindVarMemory.putLong(function.getGeoInt(null));
                return;
            }
            case 12: {
                assert (function instanceof CompiledFilterSymbolBindVariable);
                function.init(symbolTableSource, executionContext);
                bindVarMemory.putLong(function.getInt(null));
                return;
            }
            case 9: {
                bindVarMemory.putFloat(function.getFloat(null));
                bindVarMemory.putFloat(Float.NaN);
                return;
            }
            case 6: {
                bindVarMemory.putLong(function.getLong(null));
                return;
            }
            case 17: {
                bindVarMemory.putLong(function.getGeoLong(null));
                return;
            }
            case 7: {
                bindVarMemory.putLong(function.getDate(null));
                return;
            }
            case 8: {
                bindVarMemory.putLong(function.getTimestamp(null));
                return;
            }
            case 10: {
                bindVarMemory.putDouble(function.getDouble(null));
                return;
            }
        }
        throw SqlException.position(0).put("unsupported bind variable type: ").put(ColumnType.nameOf(columnTypeTag));
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
        Misc.free(this.negativeLimitRows);
        this.halfClose();
        Misc.free(this.compiledFilter);
        Misc.free(this.filter);
        Misc.free(this.bindVarMemory);
        Misc.freeObjList(this.bindVarFunctions);
    }

    public static class AsyncJitFilterAtom
    extends AsyncFilterAtom {
        final ObjList<Function> bindVarFunctions;
        final MemoryCARW bindVarMemory;
        final CompiledFilter compiledFilter;

        public AsyncJitFilterAtom(CairoConfiguration configuration, Function filter, ObjList<Function> perWorkerFilters, CompiledFilter compiledFilter, MemoryCARW bindVarMemory, ObjList<Function> bindVarFunctions, IntList columnTypes) {
            super(configuration, filter, perWorkerFilters, columnTypes);
            this.compiledFilter = compiledFilter;
            this.bindVarMemory = bindVarMemory;
            this.bindVarFunctions = bindVarFunctions;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            super.init(symbolTableSource, executionContext);
            Function.init(this.bindVarFunctions, symbolTableSource, executionContext, null);
            AsyncJitFilteredRecordCursorFactory.prepareBindVarMemory(executionContext, symbolTableSource, this.bindVarFunctions, this.bindVarMemory);
        }
    }
}

