/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageFrameMemoryPool;
import io.questdb.cairo.sql.PageFrameMemoryRecord;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cairo.sql.async.PageFrameSequence;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import io.questdb.std.Os;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;

class AsyncFilteredRecordCursor
implements RecordCursor {
    private static final Log LOG = LogFactory.getLog(AsyncFilteredRecordCursor.class);
    private final Function filter;
    private final PageFrameMemoryPool frameMemoryPool;
    private final boolean hasDescendingOrder;
    private final PageFrameMemoryRecord record;
    private boolean allFramesActive;
    private long cursor = -1L;
    private int frameIndex;
    private int frameLimit;
    private long frameRowCount;
    private long frameRowIndex;
    private PageFrameSequence<?> frameSequence;
    private boolean isOpen;
    private long ogRowsRemaining;
    private PageFrameMemoryRecord recordB;
    private DirectLongList rows;
    private long rowsRemaining;

    public AsyncFilteredRecordCursor(@NotNull CairoConfiguration configuration, Function filter, int scanDirection) {
        this.filter = filter;
        this.hasDescendingOrder = scanDirection == 2;
        this.record = new PageFrameMemoryRecord(0);
        this.frameMemoryPool = new PageFrameMemoryPool(configuration.getSqlParquetFrameCacheCapacity());
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        long frameRowsLeft;
        if (this.frameIndex == -1) {
            this.fetchNextFrame();
            circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
        }
        if (this.rowsRemaining < 1L) {
            return;
        }
        if (this.frameRowIndex < this.frameRowCount) {
            frameRowsLeft = Math.min(this.frameRowCount - this.frameRowIndex, this.rowsRemaining);
            this.rowsRemaining -= frameRowsLeft;
            this.frameRowIndex += frameRowsLeft;
            counter.add(frameRowsLeft);
            if (this.rowsRemaining < 1L) {
                this.frameSequence.cancel(0);
                return;
            }
        }
        this.collectCursor(false);
        while (this.frameIndex < this.frameLimit) {
            this.fetchNextFrame();
            if (this.frameRowCount > 0L && this.frameRowIndex < this.frameRowCount) {
                frameRowsLeft = Math.min(this.frameRowCount - this.frameRowIndex, this.rowsRemaining);
                this.rowsRemaining -= frameRowsLeft;
                this.frameRowIndex += frameRowsLeft;
                counter.add(frameRowsLeft);
                if (this.rowsRemaining < 1L) {
                    this.frameSequence.cancel(0);
                    return;
                }
                this.collectCursor(false);
            }
            if (!this.allFramesActive) {
                this.throwTimeoutException();
            }
            circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
        }
    }

    @Override
    public void close() {
        if (this.isOpen) {
            this.isOpen = false;
            Misc.free(this.frameMemoryPool);
            if (this.frameSequence != null) {
                LOG.debug().$("closing [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(this.frameIndex).$(", frameCount=").$(this.frameLimit).$(", frameId=").$(this.frameSequence.getId()).$(", cursor=").$(this.cursor).I$();
                this.collectCursor(true);
                if (this.frameLimit > -1) {
                    this.frameSequence.await();
                }
                this.frameSequence.clear();
            }
        }
    }

    public void freeRecords() {
        Misc.free(this.record);
        Misc.free(this.recordB);
        Misc.free(this.frameMemoryPool);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        this.recordB = new PageFrameMemoryRecord(this.record, 1);
        return this.recordB;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.frameIndex == -1) {
            this.fetchNextFrame();
        }
        if (this.rowsRemaining < 0L) {
            return false;
        }
        if (this.frameRowIndex < this.frameRowCount) {
            this.record.setRowIndex(this.rows.get(this.rowIndex()));
            ++this.frameRowIndex;
            return this.checkLimit();
        }
        this.collectCursor(false);
        if (this.frameIndex < this.frameLimit) {
            this.fetchNextFrame();
            if (this.frameRowCount > 0L && this.frameRowIndex < this.frameRowCount) {
                this.record.setRowIndex(this.rows.get(this.rowIndex()));
                ++this.frameRowIndex;
                return this.checkLimit();
            }
        }
        if (!this.allFramesActive) {
            this.throwTimeoutException();
        }
        return false;
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.frameSequence.getSymbolTableSource().newSymbolTable(columnIndex);
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        PageFrameMemoryRecord frameMemoryRecord = (PageFrameMemoryRecord)record;
        this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(atRowId), frameMemoryRecord);
        frameMemoryRecord.setRowIndex(Rows.toLocalRowID(atRowId));
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
        long frameRowsLeft;
        if (this.frameIndex == -1) {
            this.fetchNextFrame();
        }
        long rowCountLeft = Math.min(this.rowsRemaining, rowCount.get());
        if (this.frameRowIndex < this.frameRowCount) {
            frameRowsLeft = Math.min(this.frameRowCount - this.frameRowIndex, rowCountLeft);
            this.rowsRemaining -= frameRowsLeft;
            this.frameRowIndex += frameRowsLeft;
            rowCount.dec(frameRowsLeft);
            if ((rowCountLeft -= frameRowsLeft) == 0L) {
                return;
            }
        }
        this.collectCursor(false);
        while (this.frameIndex < this.frameLimit) {
            this.fetchNextFrame();
            if (this.frameRowCount > 0L && this.frameRowIndex < this.frameRowCount) {
                frameRowsLeft = Math.min(this.frameRowCount - this.frameRowIndex, rowCountLeft);
                this.rowsRemaining -= frameRowsLeft;
                this.frameRowIndex += frameRowsLeft;
                rowCount.dec(frameRowsLeft);
                if ((rowCountLeft -= frameRowsLeft) == 0L) {
                    return;
                }
            }
            this.collectCursor(false);
            if (this.allFramesActive) continue;
            this.throwTimeoutException();
        }
    }

    @Override
    public void toTop() {
        this.collectCursor(false);
        this.filter.toTop();
        this.frameSequence.toTop();
        this.rowsRemaining = this.ogRowsRemaining;
        this.frameIndex = -1;
        this.frameRowIndex = -1L;
        this.frameRowCount = -1L;
        this.allFramesActive = true;
    }

    private boolean checkLimit() {
        if (--this.rowsRemaining < 0L) {
            this.frameSequence.cancel(0);
            return false;
        }
        return true;
    }

    private void collectCursor(boolean forceCollect) {
        if (this.cursor > -1L) {
            this.frameSequence.collect(this.cursor, forceCollect);
            this.cursor = -1L;
            this.record.clear();
        }
    }

    private void fetchNextFrame() {
        if (this.frameLimit == -1) {
            this.frameSequence.prepareForDispatch();
            this.frameLimit = this.frameSequence.getFrameCount() - 1;
        }
        try {
            do {
                this.cursor = this.frameSequence.next();
                if (this.cursor > -1L) {
                    PageFrameReduceTask task = this.frameSequence.getTask(this.cursor);
                    LOG.debug().$("collected [shard=").$(this.frameSequence.getShard()).$(", frameIndex=").$(task.getFrameIndex()).$(", frameCount=").$(this.frameSequence.getFrameCount()).$(", frameId=").$(this.frameSequence.getId()).$(", active=").$(this.frameSequence.isActive()).$(", cursor=").$(this.cursor).I$();
                    if (task.hasError()) {
                        throw CairoException.nonCritical().position(task.getErrorMessagePosition()).put(task.getErrorMsg()).setCancellation(task.isCancelled()).setInterruption(task.isCancelled()).setOutOfMemory(task.isOutOfMemory());
                    }
                    this.allFramesActive &= this.frameSequence.isActive();
                    this.rows = task.getFilteredRows();
                    this.frameRowCount = this.rows.size();
                    this.frameIndex = task.getFrameIndex();
                    this.frameRowIndex = 0L;
                    if (this.frameRowCount > 0L && this.frameSequence.isActive()) {
                        this.record.init(task.getFrameMemory());
                        break;
                    }
                    this.frameRowCount = 0L;
                    this.collectCursor(false);
                    continue;
                }
                if (this.cursor == -2L) break;
                Os.pause();
            } while (this.frameIndex < this.frameLimit);
        }
        catch (Throwable th) {
            if (th instanceof CairoException) {
                CairoException ce = (CairoException)th;
                if (ce.isInterruption() || ce.isCancellation()) {
                    LOG.error().$("filter error [ex=").$safe(((CairoException)th).getFlyweightMessage()).I$();
                    this.throwTimeoutException();
                } else {
                    LOG.error().$("filter error [ex=").$(th).I$();
                    throw ce;
                }
            }
            LOG.error().$("filter error [ex=").$(th).I$();
            throw CairoException.nonCritical().put(th.getMessage());
        }
    }

    private long rowIndex() {
        return this.hasDescendingOrder ? this.frameRowCount - this.frameRowIndex - 1L : this.frameRowIndex;
    }

    private void throwTimeoutException() {
        if (this.frameSequence.getCancelReason() == 3) {
            throw CairoException.queryCancelled();
        }
        throw CairoException.queryTimedOut();
    }

    void of(PageFrameSequence<?> frameSequence, long rowsRemaining) {
        this.isOpen = true;
        this.frameSequence = frameSequence;
        this.rowsRemaining = rowsRemaining;
        this.ogRowsRemaining = rowsRemaining;
        this.frameIndex = -1;
        this.frameLimit = -1;
        this.frameRowIndex = -1L;
        this.frameRowCount = -1L;
        this.allFramesActive = true;
        this.frameMemoryPool.of(frameSequence.getPageFrameAddressCache());
        this.record.of(frameSequence.getSymbolTableSource());
        if (this.recordB != null) {
            this.recordB.of(frameSequence.getSymbolTableSource());
        }
    }
}

