/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDescendingRecordListCursor
extends AbstractPageFrameRecordCursor {
    protected final DirectLongList rows;
    protected SqlExecutionCircuitBreaker circuitBreaker;
    protected boolean isOpen;
    private boolean isTreeMapBuilt;
    private long rowIndex;

    public AbstractDescendingRecordListCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @Nullable DirectLongList rows) {
        super(configuration, metadata);
        this.rows = rows;
        this.isOpen = true;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.rowIndex = this.rows.size() - 1L;
            this.isTreeMapBuilt = true;
        }
        if (this.rowIndex > -1L) {
            counter.add(this.rowIndex + 1L);
            this.rowIndex = -1L;
        }
    }

    @Override
    public void close() {
        this.isOpen = false;
        super.close();
    }

    @Override
    public boolean hasNext() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.rowIndex = this.rows.size() - 1L;
            this.isTreeMapBuilt = true;
        }
        if (this.rowIndex > -1L) {
            long rowId = this.rows.get(this.rowIndex--);
            this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId), this.recordA);
            this.recordA.setRowIndex(Rows.toLocalRowID(rowId));
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) throws SqlException {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.rows.clear();
        this.isTreeMapBuilt = false;
        this.isOpen = true;
        super.init();
    }

    @Override
    public long preComputedStateSize() {
        return this.isTreeMapBuilt ? 1L : 0L;
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.rows.size() : -1L;
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.rowIndex = this.rows.size() - 1L;
            this.isTreeMapBuilt = true;
        }
        if (this.rowIndex > -1L) {
            long rowsLeft = this.rowIndex + 1L;
            long rowsToSkip = Math.min(rowsLeft, rowCount.get());
            rowCount.dec(rowsToSkip);
            this.rowIndex -= rowsToSkip;
        }
    }

    @Override
    public void toTop() {
        this.rowIndex = this.rows.size() - 1L;
    }

    protected abstract void buildTreeMap();
}

