/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.join.AbstractJoinCursor;
import io.questdb.griffin.engine.join.AbstractJoinRecordCursorFactory;
import io.questdb.griffin.engine.join.JoinRecord;
import io.questdb.griffin.model.JoinContext;
import io.questdb.std.Misc;

public class HashJoinRecordCursorFactory
extends AbstractJoinRecordCursorFactory {
    private final HashJoinRecordCursor cursor;
    private final RecordSink masterSink;
    private final RecordSink slaveKeySink;

    public HashJoinRecordCursorFactory(CairoConfiguration configuration, RecordMetadata metadata, RecordCursorFactory masterFactory, RecordCursorFactory slaveFactory, ColumnTypes joinColumnTypes, ColumnTypes valueTypes, RecordSink masterSink, RecordSink slaveKeySink, RecordSink slaveChainSink, int columnSplit, JoinContext joinContext) {
        super(metadata, joinContext, masterFactory, slaveFactory);
        Map joinKeyMap = null;
        RecordChain slaveChain = null;
        try {
            joinKeyMap = MapFactory.createUnorderedMap(configuration, joinColumnTypes, valueTypes);
            slaveChain = new RecordChain(slaveFactory.getMetadata(), slaveChainSink, configuration.getSqlHashJoinValuePageSize(), configuration.getSqlHashJoinValueMaxPages());
            this.masterSink = masterSink;
            this.slaveKeySink = slaveKeySink;
            this.cursor = new HashJoinRecordCursor(columnSplit, joinKeyMap, slaveChain);
        }
        catch (Throwable th) {
            Misc.free(joinKeyMap);
            Misc.free(slaveChain);
            this.close();
            throw th;
        }
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.masterFactory.followedOrderByAdvice();
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor slaveCursor = this.slaveFactory.getCursor(executionContext);
        RecordCursor masterCursor = null;
        try {
            masterCursor = this.masterFactory.getCursor(executionContext);
            this.cursor.of(masterCursor, slaveCursor, executionContext.getCircuitBreaker());
            return this.cursor;
        }
        catch (Throwable e) {
            Misc.free(slaveCursor);
            Misc.free(masterCursor);
            throw e;
        }
    }

    @Override
    public int getScanDirection() {
        return this.masterFactory.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public boolean supportsUpdateRowId(TableToken tableToken) {
        return this.masterFactory.supportsUpdateRowId(tableToken);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Hash Join");
        sink.attr("condition").val(this.joinContext);
        sink.child(this.masterFactory);
        sink.child("Hash", this.slaveFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long computeCursorSizeFromMap(RecordCursor masterCursor, Map map, RecordSink keySink) {
        Record masterRecord = masterCursor.getRecord();
        long size = 0L;
        try {
            masterCursor.toTop();
            while (masterCursor.hasNext()) {
                MapKey key = map.withKey();
                key.put(masterRecord, keySink);
                MapValue value = key.findValue();
                if (value == null) continue;
                size += value.getLong(2);
            }
            long l = size;
            return l;
        }
        finally {
            masterCursor.toTop();
        }
    }

    @Override
    protected void _close() {
        Misc.freeIfCloseable(this.getMetadata());
        Misc.free(this.masterFactory);
        Misc.free(this.slaveFactory);
        Misc.free(this.cursor);
    }

    private class HashJoinRecordCursor
    extends AbstractJoinCursor {
        private final Map joinKeyMap;
        private final JoinRecord recordA;
        private final RecordChain slaveChain;
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isMapBuilt;
        private boolean isOpen;
        private Record masterRecord;
        private long size;
        private boolean useSlaveCursor;

        public HashJoinRecordCursor(int columnSplit, Map joinKeyMap, RecordChain slaveChain) {
            super(columnSplit);
            this.size = -1L;
            this.recordA = new JoinRecord(columnSplit);
            this.joinKeyMap = joinKeyMap;
            this.slaveChain = slaveChain;
            this.isOpen = true;
        }

        @Override
        public void close() {
            if (this.isOpen) {
                this.isOpen = false;
                this.joinKeyMap.close();
                this.slaveChain.close();
                super.close();
            }
        }

        @Override
        public Record getRecord() {
            return this.recordA;
        }

        @Override
        public boolean hasNext() {
            this.buildMapOfSlaveRecords();
            if (this.useSlaveCursor && this.slaveChain.hasNext()) {
                return true;
            }
            while (this.masterCursor.hasNext()) {
                MapKey key = this.joinKeyMap.withKey();
                key.put(this.masterRecord, HashJoinRecordCursorFactory.this.masterSink);
                MapValue value = key.findValue();
                if (value == null) continue;
                this.slaveChain.of(value.getInt(0));
                this.slaveChain.hasNext();
                this.useSlaveCursor = true;
                return true;
            }
            return false;
        }

        @Override
        public long preComputedStateSize() {
            return this.isMapBuilt ? 1L : 0L;
        }

        @Override
        public long size() {
            if (this.size != -1L) {
                return this.size;
            }
            this.buildMapOfSlaveRecords();
            this.size = HashJoinRecordCursorFactory.computeCursorSizeFromMap(this.masterCursor, this.joinKeyMap, HashJoinRecordCursorFactory.this.masterSink);
            return this.size;
        }

        @Override
        public void toTop() {
            this.masterCursor.toTop();
            this.useSlaveCursor = false;
            if (!this.isMapBuilt) {
                this.slaveCursor.toTop();
                this.joinKeyMap.clear();
                this.slaveChain.clear();
            }
        }

        private void buildMapOfSlaveRecords() {
            if (!this.isMapBuilt) {
                TableUtils.populateRecordHashMap(this.circuitBreaker, this.slaveCursor, this.joinKeyMap, HashJoinRecordCursorFactory.this.slaveKeySink, this.slaveChain);
                this.isMapBuilt = true;
            }
        }

        private void of(RecordCursor masterCursor, RecordCursor slaveCursor, SqlExecutionCircuitBreaker circuitBreaker) {
            if (!this.isOpen) {
                this.isOpen = true;
                this.joinKeyMap.reopen();
                this.slaveChain.reopen();
            }
            this.masterCursor = masterCursor;
            this.slaveCursor = slaveCursor;
            this.circuitBreaker = circuitBreaker;
            this.masterRecord = masterCursor.getRecord();
            Record slaveRecord = this.slaveChain.getRecord();
            this.recordA.of(this.masterRecord, slaveRecord);
            this.slaveChain.setSymbolTableResolver(slaveCursor);
            this.useSlaveCursor = false;
            this.size = -1L;
            this.isMapBuilt = false;
        }
    }
}

