/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.LongLongHashMap;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;

public class FastGroupByAllocator
implements GroupByAllocator {
    private final boolean aligned;
    private final LongLongHashMap chunks = new LongLongHashMap();
    private final long defaultChunkSize;
    private final long maxChunkSize;
    private long allocated;
    private long lim;
    private long ptr;

    public FastGroupByAllocator(long defaultChunkSize, long maxChunkSize) {
        this(defaultChunkSize, maxChunkSize, true);
    }

    public FastGroupByAllocator(long defaultChunkSize, long maxChunkSize, boolean aligned) {
        this.defaultChunkSize = defaultChunkSize;
        this.maxChunkSize = maxChunkSize;
        this.aligned = aligned;
    }

    @Override
    public long allocated() {
        return this.allocated;
    }

    @Override
    public void close() {
        int n = this.chunks.capacity();
        for (int i = 0; i < n; ++i) {
            long ptr = this.chunks.keyAtRaw(i);
            if (ptr == -1L) continue;
            long size = this.chunks.valueAtRaw(i);
            Unsafe.free(ptr, size, 32);
        }
        this.chunks.restoreInitialCapacity();
        this.allocated = 0L;
        this.lim = 0L;
        this.ptr = 0L;
    }

    @Override
    public void free(long ptr, long size) {
        long chunkSize;
        if (size < this.defaultChunkSize) {
            return;
        }
        int index = this.chunks.keyIndex(ptr);
        if (index < 0 && size == (chunkSize = this.chunks.valueAt(index))) {
            Unsafe.free(ptr, chunkSize, 32);
            this.chunks.removeAt(index);
            this.allocated -= chunkSize;
            if (this.ptr == this.alignMaybe(ptr + chunkSize)) {
                this.lim = 0L;
                this.ptr = 0L;
            }
        }
    }

    @Override
    public long malloc(long size) {
        if (size > this.maxChunkSize) {
            throw CairoException.nonCritical().put("too large allocation requested: ").put(size);
        }
        if (this.ptr + size <= this.lim) {
            long allocatedPtr = this.ptr;
            this.ptr = this.alignMaybe(allocatedPtr + size);
            return allocatedPtr;
        }
        long chunkSize = Math.max(size, this.defaultChunkSize);
        long allocatedPtr = Unsafe.malloc(chunkSize, 32);
        this.chunks.put(allocatedPtr, chunkSize);
        this.allocated += chunkSize;
        this.ptr = this.alignMaybe(allocatedPtr + size);
        this.lim = allocatedPtr + chunkSize;
        return allocatedPtr;
    }

    @Override
    public long realloc(long ptr, long oldSize, long newSize) {
        long chunkSize;
        int index;
        if (newSize > this.maxChunkSize) {
            throw CairoException.nonCritical().put("too large allocation requested: ").put(newSize);
        }
        if (newSize <= oldSize) {
            return ptr;
        }
        if (this.ptr == this.alignMaybe(ptr + oldSize) && ptr + newSize <= this.lim) {
            this.ptr = this.alignMaybe(ptr + newSize);
            return ptr;
        }
        if (oldSize >= this.defaultChunkSize && (index = this.chunks.keyIndex(ptr)) < 0 && (chunkSize = this.chunks.valueAt(index)) == oldSize) {
            long chunkPtr = Unsafe.realloc(ptr, chunkSize, newSize, 32);
            this.allocated += newSize - chunkSize;
            this.chunks.removeAt(index);
            this.chunks.put(chunkPtr, newSize);
            this.lim = chunkPtr + newSize;
            this.ptr = this.alignMaybe(this.lim);
            return chunkPtr;
        }
        long allocatedPtr = this.malloc(newSize);
        Vect.memcpy(allocatedPtr, ptr, oldSize);
        return allocatedPtr;
    }

    private long alignMaybe(long ptr) {
        return this.aligned ? Bytes.align8b(ptr) : ptr;
    }
}

