/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class RPadFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "rpad(SI)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function lenFunc = args.getQuick(1);
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new RPadFunc(strFunc, lenFunc, maxLength);
    }

    public static class RPadFunc
    extends StrFunction
    implements BinaryFunction {
        private final Function lenFunc;
        private final int maxLength;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;

        public RPadFunc(Function strFunc, Function lenFunc, int maxLength) {
            this.strFunc = strFunc;
            this.lenFunc = lenFunc;
            this.maxLength = maxLength;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "rpad";
        }

        @Override
        public Function getRight() {
            return this.lenFunc;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.rPad(this.strFunc.getStrA(rec), this.lenFunc.getInt(rec), this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.rPad(this.strFunc.getStrB(rec), this.lenFunc.getInt(rec), this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            CharSequence str = this.strFunc.getStrA(rec);
            int len = this.lenFunc.getInt(rec);
            if (str != null && len >= 0) {
                return len;
            }
            return -1;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private StringSink rPad(CharSequence str, int len, StringSink sink) {
            if (str != null && len >= 0) {
                if (len > this.maxLength) {
                    throw CairoException.nonCritical().put("breached memory limit set for ").put(RPadFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(", requiredLength=").put(len).put(']');
                }
                sink.clear();
                if (len > str.length()) {
                    sink.put(str);
                    for (int i = 0; i < len - str.length(); ++i) {
                        sink.put(' ');
                    }
                } else {
                    sink.put(str, str.length() - len, str.length());
                }
                return sink;
            }
            return null;
        }
    }
}

