/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IPv4Function;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class BitwiseOrIPv4FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "|(XX)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new BitwiseOrIPv4Function(args.getQuick(0), args.getQuick(1));
    }

    public static final class BitwiseOrIPv4Function
    extends IPv4Function
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public BitwiseOrIPv4Function(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public int getIPv4(Record rec) {
            int l = this.left.getIPv4(rec);
            int r = this.right.getIPv4(rec);
            return l != 0 && r != 0 ? l | r : 0;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left).val('|').val(this.right);
        }
    }
}

