/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractStdDevGroupByFunction
extends DoubleFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function arg;
    protected int valueIndex;

    protected AbstractStdDevGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        double d = this.arg.getDouble(record);
        mapValue.putDouble(this.valueIndex, 0.0);
        mapValue.putDouble(this.valueIndex + 1, 0.0);
        mapValue.putLong(this.valueIndex + 2, 0L);
        if (Numbers.isFinite(d)) {
            this.aggregate(mapValue, d);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double d = this.arg.getDouble(record);
        if (Numbers.isFinite(d)) {
            this.aggregate(mapValue, d);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(6);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putLong(this.valueIndex + 2, 1L);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putDouble(this.valueIndex + 1, Double.NaN);
        mapValue.putLong(this.valueIndex + 2, 0L);
    }

    @Override
    public boolean supportsParallelism() {
        return false;
    }

    protected void aggregate(MapValue mapValue, double value) {
        double mean = mapValue.getDouble(this.valueIndex);
        double sum = mapValue.getDouble(this.valueIndex + 1);
        long count = mapValue.getLong(this.valueIndex + 2) + 1L;
        double oldMean = mean;
        mean += (value - mean) / (double)count;
        mapValue.putDouble(this.valueIndex, mean);
        mapValue.putDouble(this.valueIndex + 1, sum += (value - mean) * (value - oldMean));
        mapValue.addLong(this.valueIndex + 2, 1L);
    }
}

