/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.eq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.eq.AbstractEqBinaryFunction;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.SingleCharCharSequence;

public class EqSymCharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "=(KA)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        SymbolFunction symFunc = (SymbolFunction)args.getQuick(0);
        Function chrFunc = args.getQuick(1);
        if (chrFunc.isConstant()) {
            char constValue = chrFunc.getChar(null);
            if (symFunc.getStaticSymbolTable() != null) {
                return new ConstCheckColumnFunc(symFunc, constValue);
            }
            return new ConstCheckFunc(symFunc, constValue);
        }
        return new Func(symFunc, chrFunc);
    }

    private static class ConstCheckColumnFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final SymbolFunction arg;
        private final char constant;
        private int valueIndex;

        public ConstCheckColumnFunc(SymbolFunction arg, char constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != (this.arg.getInt(rec) == this.valueIndex);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            this.arg.init(symbolTableSource, executionContext);
            StaticSymbolTable symbolTable = this.arg.getStaticSymbolTable();
            assert (symbolTable != null);
            this.valueIndex = symbolTable.keyOf(SingleCharCharSequence.get(this.constant));
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }

    private static class ConstCheckFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final char constant;

        public ConstCheckFunc(Function arg, char constant) {
            this.arg = arg;
            this.constant = constant;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.arg.getSymbol(rec), this.constant);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val('!');
            }
            sink.val("='").val(this.constant).val('\'');
        }
    }

    private static class Func
    extends AbstractEqBinaryFunction {
        public Func(Function symFunc, Function chrFunc) {
            super(symFunc, chrFunc);
        }

        @Override
        public boolean getBool(Record rec) {
            return this.negated != Chars.equalsNc(this.left.getSymbol(rec), this.right.getChar(rec));
        }
    }
}

