/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.Path;

public class WalTableListFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(WalTableListFunctionFactory.class);
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "wal_tables()";
    private static final int bufferedTxnSizeColumn;
    private static final int errorMessageColumn;
    private static final int errorTagColumn;
    private static final int memoryPressureLevelColumn;
    private static final int nameColumn;
    private static final int sequencerTxnColumn;
    private static final int suspendedColumn;
    private static final int writerTxnColumn;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new WalTableListCursorFactory(configuration, sqlExecutionContext)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("name", 11));
        nameColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("suspended", 1));
        suspendedColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("writerTxn", 6));
        writerTxnColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("bufferedTxnSize", 6));
        bufferedTxnSizeColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("sequencerTxn", 6));
        sequencerTxnColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("errorTag", 11));
        errorTagColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("errorMessage", 11));
        errorMessageColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("memoryPressure", 5));
        memoryPressureLevelColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class WalTableListCursorFactory
    extends AbstractRecordCursorFactory {
        private final TableListRecordCursor cursor;
        private final FilesFacade ff;
        private final SqlExecutionContext sqlExecutionContext;
        private CairoEngine engine;
        private Path rootPath;

        public WalTableListCursorFactory(CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
            super(METADATA);
            this.ff = configuration.getFilesFacade();
            this.rootPath = new Path();
            this.rootPath.of(configuration.getDbRoot());
            this.sqlExecutionContext = sqlExecutionContext;
            this.cursor = new TableListRecordCursor();
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.engine = executionContext.getCairoEngine();
            this.cursor.init();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(WalTableListFunctionFactory.SIGNATURE);
        }

        @Override
        protected void _close() {
            this.rootPath = Misc.free(this.rootPath);
        }

        private class TableListRecordCursor
        implements NoRandomAccessRecordCursor {
            private final TableListRecord record = new TableListRecord();
            private final ObjHashSet<TableToken> tableBucket = new ObjHashSet();
            private final TxReader txReader;
            private int tableIndex;

            private TableListRecordCursor() {
                this.txReader = new TxReader(WalTableListCursorFactory.this.ff);
                this.tableIndex = -1;
            }

            @Override
            public void close() {
                this.tableBucket.clear();
                this.txReader.close();
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                TableToken tableToken;
                ++this.tableIndex;
                int n = this.tableBucket.size();
                while (!(this.tableIndex >= n || WalTableListCursorFactory.this.engine.isWalTable(tableToken = this.tableBucket.get(this.tableIndex)) && !WalTableListCursorFactory.this.engine.isTableDropped(tableToken) && this.record.switchTo(tableToken))) {
                    ++this.tableIndex;
                }
                return this.tableIndex < n;
            }

            @Override
            public long preComputedStateSize() {
                return this.tableBucket.size();
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.tableIndex = -1;
            }

            private void init() {
                this.tableBucket.clear();
                WalTableListCursorFactory.this.engine.getTableTokens(this.tableBucket, false);
                this.toTop();
            }

            public class TableListRecord
            implements Record {
                private long bufferedTxnSize;
                private String errorMessage;
                private String errorTag;
                private int memoryPressureLevel;
                private long sequencerTxn;
                private boolean suspendedFlag;
                private String tableName;
                private long writerTxn;

                @Override
                public boolean getBool(int col) {
                    if (col == suspendedColumn) {
                        return this.suspendedFlag;
                    }
                    return false;
                }

                @Override
                public int getInt(int col) {
                    if (col == memoryPressureLevelColumn) {
                        return this.memoryPressureLevel;
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    if (col == writerTxnColumn) {
                        return this.writerTxn;
                    }
                    if (col == bufferedTxnSizeColumn) {
                        return this.bufferedTxnSize;
                    }
                    if (col == sequencerTxnColumn) {
                        return this.sequencerTxn;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public CharSequence getStrA(int col) {
                    if (col == nameColumn) {
                        return this.tableName;
                    }
                    if (col == errorTagColumn) {
                        return this.errorTag;
                    }
                    if (col == errorMessageColumn) {
                        return this.errorMessage;
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private boolean switchTo(TableToken tableToken) {
                    try {
                        long txnFd = -1L;
                        int rootLen = -1;
                        SeqTxnTracker seqTxnTracker = WalTableListCursorFactory.this.engine.getTableSequencerAPI().getTxnTracker(tableToken);
                        this.memoryPressureLevel = seqTxnTracker.getMemPressureControl().getMemoryPressureLevel();
                        this.tableName = tableToken.getTableName();
                        if (seqTxnTracker.isInitialised()) {
                            this.suspendedFlag = seqTxnTracker.isSuspended();
                            this.sequencerTxn = seqTxnTracker.getSeqTxn();
                            this.writerTxn = seqTxnTracker.getWriterTxn();
                            this.bufferedTxnSize = seqTxnTracker.getLagTxnCount();
                            if (this.suspendedFlag) {
                                this.errorTag = seqTxnTracker.getErrorTag().text();
                                this.errorMessage = seqTxnTracker.getErrorMessage();
                                return true;
                            }
                            this.errorTag = "";
                            this.errorMessage = "";
                            return true;
                        }
                        try {
                            this.suspendedFlag = false;
                            rootLen = WalTableListCursorFactory.this.rootPath.size();
                            WalTableListCursorFactory.this.rootPath.concat(tableToken).concat("txn_seq");
                            txnFd = TableUtils.openRO(WalTableListCursorFactory.this.ff, WalTableListCursorFactory.this.rootPath, "_txnlog", LOG);
                            this.sequencerTxn = WalTableListCursorFactory.this.ff.readNonNegativeLong(txnFd, 4L);
                            WalTableListCursorFactory.this.rootPath.trimTo(rootLen).concat(tableToken).concat("_txn").$();
                            if (!WalTableListCursorFactory.this.ff.exists(WalTableListCursorFactory.this.rootPath.$())) {
                                boolean bl2 = false;
                                return bl2;
                            }
                            TableListRecordCursor.this.txReader.ofRO(WalTableListCursorFactory.this.rootPath.$(), 3);
                            CairoEngine engine = WalTableListCursorFactory.this.sqlExecutionContext.getCairoEngine();
                            MillisecondClock millisecondClock = engine.getConfiguration().getMillisecondClock();
                            long spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
                            TableUtils.safeReadTxn(TableListRecordCursor.this.txReader, millisecondClock, spinLockTimeout);
                            this.bufferedTxnSize = TableListRecordCursor.this.txReader.getLagTxnCount();
                            boolean bl = true;
                            return bl;
                        }
                        finally {
                            if (txnFd > -1L) {
                                WalTableListCursorFactory.this.ff.close(txnFd);
                                TableListRecordCursor.this.txReader.close();
                            }
                            if (rootLen > -1) {
                                WalTableListCursorFactory.this.rootPath.trimTo(rootLen);
                            }
                        }
                    }
                    catch (CairoException ex) {
                        if (!ex.errnoFileCannotRead()) throw ex;
                        return false;
                    }
                }
            }
        }
    }
}

