/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.sql.FunctionExtension;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.engine.functions.StrArrayFunction;
import io.questdb.std.Chars;
import io.questdb.std.GenericLexer;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.NotNull;

public class StringToStringArrayFunction
extends StrArrayFunction
implements FunctionExtension {
    private static final int BRANCH_AFTER_ITEM = 2;
    private static final int BRANCH_AFTER_LAST_ITEM = 3;
    private static final int BRANCH_BEFORE_ITEM = 0;
    private static final int BRANCH_DOUBLE_QUOTE = 4;
    private static final int BRANCH_ITEM = 1;
    private final ObjList<CharSequence> items = new ObjList();
    private final StringSink sink = new StringSink();

    public StringToStringArrayFunction(int position, CharSequence type) throws SqlException {
        char ch;
        if (type == null) {
            throw SqlException.$(position, "NULL is not allowed");
        }
        int charIndex = this.findArrayOpeningBracketIndex(position, type);
        int branch = 0;
        int stringStartIndex = -1;
        int stringEndIndex = -1;
        int lastBackslashIndex = -1;
        StringSink sink = Misc.getThreadLocalSink();
        int len = type.length();
        ++charIndex;
        block7: while (charIndex < len) {
            if (lastBackslashIndex == charIndex - 1) {
                if (branch == 1 || branch == 4) {
                    sink.put(type, stringStartIndex, lastBackslashIndex);
                } else {
                    branch = 1;
                }
                stringStartIndex = stringEndIndex = charIndex;
            } else {
                ch = type.charAt(charIndex);
                switch (ch) {
                    case '\\': {
                        if (branch == 2) {
                            throw SqlException.$(position, "unexpected character after '\"'");
                        }
                        lastBackslashIndex = charIndex;
                        break;
                    }
                    case '\"': {
                        if (branch == 2) {
                            throw SqlException.$(position, "unexpected character after '\"'");
                        }
                        if (branch == 1) {
                            throw SqlException.$(position, "unexpected '\"' character");
                        }
                        if (branch == 0) {
                            stringStartIndex = charIndex + 1;
                            branch = 4;
                            break;
                        }
                        stringEndIndex = charIndex - 1;
                        branch = 2;
                        break;
                    }
                    case '{': {
                        if (branch == 4) break;
                        throw SqlException.$(position, "unexpected '{' character");
                    }
                    case '}': {
                        if (branch == 4) break;
                        if (branch == 0 && this.items.size() > 0) {
                            throw SqlException.$(position, "unexpected '}' character");
                        }
                        if (branch == 1 || branch == 2) {
                            this.commit(type, stringStartIndex, stringEndIndex, sink);
                        }
                        branch = 3;
                        break block7;
                    }
                    case ',': {
                        if (branch == 4) break;
                        if (branch == 0) {
                            throw SqlException.$(position, "unexpected ',' character");
                        }
                        this.commit(type, stringStartIndex, stringEndIndex, sink);
                        branch = 0;
                        break;
                    }
                    default: {
                        if (GenericLexer.WHITESPACE_CH.contains(ch)) break;
                        if (branch == 2) {
                            throw SqlException.$(position, "unexpected character after '\"'");
                        }
                        if (branch == 0) {
                            stringStartIndex = charIndex;
                            branch = 1;
                        }
                        stringEndIndex = charIndex;
                    }
                }
            }
            ++charIndex;
        }
        if (branch != 3) {
            throw SqlException.$(position, "array must end with '}'");
        }
        ++charIndex;
        while (charIndex < len) {
            ch = type.charAt(charIndex);
            if (!GenericLexer.WHITESPACE_CH.contains(ch)) {
                throw SqlException.$(position, "unexpected character after '}'");
            }
            ++charIndex;
        }
    }

    @Override
    public FunctionExtension extendedOps() {
        return this;
    }

    @Override
    public int getArrayLength() {
        return this.items.size();
    }

    @Override
    public Record getRecord(Record rec) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CharSequence getStrA(Record rec) {
        return this.initSink();
    }

    @Override
    public CharSequence getStrA(Record rec, int arrayIndex) {
        return this.items.getQuick(arrayIndex);
    }

    @Override
    public CharSequence getStrB(Record rec) {
        return this.initSink();
    }

    @Override
    public CharSequence getStrB(Record rec, int arrayIndex) {
        return this.getStrA(rec, arrayIndex);
    }

    @Override
    public int getStrLen(Record rec) {
        return this.initSink().length();
    }

    @Override
    public int getStrLen(Record rec, int arrayIndex) {
        return this.getStrA(rec, arrayIndex).length();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.items).val("::string[]");
    }

    private void commit(@NotNull CharSequence type, int stringStartIndex, int stringEndIndex, StringSink sink) {
        sink.put(type, stringStartIndex, stringEndIndex + 1);
        this.items.add(Chars.toString(sink));
        sink.clear();
    }

    private int findArrayOpeningBracketIndex(int position, CharSequence type) throws SqlException {
        int len = type.length();
        for (int charIndex = 0; charIndex < len; ++charIndex) {
            char ch = type.charAt(charIndex);
            if (ch == '{') {
                return charIndex;
            }
            if (!GenericLexer.WHITESPACE_CH.contains(ch)) break;
        }
        throw SqlException.$(position, "array must start with '{'");
    }

    StringSink initSink() {
        if (this.sink.length() > 0) {
            return this.sink;
        }
        this.sink.put('{');
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            this.sink.put(this.items.getQuick(i));
            if (i == n - 1) continue;
            this.sink.put(',');
        }
        this.sink.put('}');
        return this.sink;
    }
}

