/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.NoopArrayWriteState;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToStrFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastDoubleArrayToStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(D[]s)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0));
    }

    public static class Func
    extends AbstractCastToStrFunction {
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public Func(Function arg) {
            super(arg);
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.toSinkOrNull(this.sinkA, rec);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.toSinkOrNull(this.sinkB, rec);
        }

        private CharSequence toSinkOrNull(StringSink sink, Record rec) {
            ArrayView arrayView = this.arg.getArray(rec);
            if (arrayView.isNull()) {
                return null;
            }
            sink.clear();
            ArrayTypeDriver.arrayToJson(arrayView, sink, NoopArrayWriteState.INSTANCE);
            return sink;
        }
    }
}

