/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class DoubleArrayAndScalarDotProductFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "dot_product";

    @Override
    public String getSignature() {
        return "dot_product(D[]D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    @Override
    public boolean shouldSwapArgs() {
        return true;
    }

    private static class Func
    extends DoubleFunction
    implements BinaryFunction {
        private final Function leftArg;
        private final Function rightArg;

        public Func(Function leftArg, Function rightArg) {
            this.leftArg = leftArg;
            this.rightArg = rightArg;
        }

        @Override
        public double getDouble(Record rec) {
            ArrayView arr = this.leftArg.getArray(rec);
            if (arr.isNull()) {
                return Double.NaN;
            }
            double scalarValue = this.rightArg.getDouble(rec);
            if (Numbers.isNull(scalarValue)) {
                return Double.NaN;
            }
            double value = 0.0;
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    double v = flatView.getDoubleAtAbsIndex(i);
                    if (!Numbers.isFinite(v)) continue;
                    value += v * scalarValue;
                }
                return value;
            }
            return Func.calculateRecursive(arr, 0, 0, scalarValue, value);
        }

        @Override
        public Function getLeft() {
            return this.leftArg;
        }

        @Override
        public String getName() {
            return DoubleArrayAndScalarDotProductFunctionFactory.FUNCTION_NAME;
        }

        @Override
        public Function getRight() {
            return this.rightArg;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static double calculateRecursive(ArrayView view, int dim, int flatIndex, double scalarValue, double sum) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    double v = view.getDouble(flatIndex);
                    if (Numbers.isFinite(v)) {
                        sum += v * scalarValue;
                    }
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    sum = Func.calculateRecursive(view, dim + 1, flatIndex, scalarValue, sum);
                    flatIndex += stride;
                }
            }
            return sum;
        }
    }
}

