/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class ArrayDimLengthFunctionFactory
implements FunctionFactory {
    private static final String FUNCTION_NAME = "dim_length";

    @Override
    public String getSignature() {
        return "dim_length(D[]I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arrayArg = args.getQuick(0);
        Function dimArg = args.getQuick(1);
        int dimArgPos = argPositions.getQuick(1);
        if (dimArg.isConstant()) {
            int dim = dimArg.getInt(null);
            dimArg.close();
            int nDims = ColumnType.decodeArrayDimensionality(arrayArg.getType());
            if (dim < 1 || dim > nDims) {
                throw SqlException.position(dimArgPos).put("array dimension out of bounds [dim=").put(dim).put(", nDims=").put(nDims).put(']');
            }
            return new ArrayDimLengthConstFunction(arrayArg, dim);
        }
        return new ArrayDimLengthFunction(arrayArg, dimArg, dimArgPos);
    }

    static class ArrayDimLengthConstFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final int dimConstArg;

        ArrayDimLengthConstFunction(Function arrayArg, int dimConstArg) {
            this.arrayArg = arrayArg;
            this.dimConstArg = dimConstArg;
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            return array.getDimLen(this.dimConstArg - 1);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(ArrayDimLengthFunctionFactory.FUNCTION_NAME).val('(').val(this.arrayArg).val(", ").val(this.dimConstArg).val(')');
        }
    }

    static class ArrayDimLengthFunction
    extends IntFunction
    implements BinaryFunction {
        private final Function arrayArg;
        private final Function dimArg;
        private final int dimArgPos;
        private final int nDims;

        ArrayDimLengthFunction(Function arrayArg, Function dimArg, int dimArgPos) {
            this.arrayArg = arrayArg;
            this.dimArg = dimArg;
            this.nDims = ColumnType.decodeArrayDimensionality(arrayArg.getType());
            this.dimArgPos = dimArgPos;
        }

        @Override
        public int getInt(Record rec) {
            ArrayView array = this.arrayArg.getArray(rec);
            int dim = this.dimArg.getInt(rec);
            if (dim < 1 || dim > this.nDims) {
                throw CairoException.nonCritical().position(this.dimArgPos).put("array dimension out of bounds [dim=").put(dim).put(", nDims=").put(this.nDims).put(']');
            }
            return array.getDimLen(dim - 1);
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public Function getRight() {
            return this.dimArg;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(ArrayDimLengthFunctionFactory.FUNCTION_NAME).val('(').val(this.arrayArg).val(", ").val(this.dimArg).val(')');
        }
    }
}

