/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ErrorTag;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.cairo.wal.seq.EmptyOperationCursor;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableRecordMetadataSink;
import io.questdb.cairo.wal.seq.TableSequencerImpl;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.FilesFacade;
import io.questdb.std.ObjHashSet;
import io.questdb.std.QuietCloseable;
import io.questdb.std.str.Path;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class TableSequencerAPI
implements QuietCloseable {
    private static final Log LOG = LogFactory.getLog(TableSequencerAPI.class);
    final CairoConfiguration configuration;
    final ConcurrentHashMap<TableSequencerImpl> seqRegistry = new ConcurrentHashMap(false);
    private final Function<CharSequence, SeqTxnTracker> createTxnTracker;
    private final CairoEngine engine;
    private final long inactiveTtlUs;
    private final int recreateDistressedSequencerAttempts;
    private final ConcurrentHashMap<SeqTxnTracker> seqTxnTrackers = new ConcurrentHashMap(false);
    private final BiFunction<CharSequence, Object, TableSequencerImpl> openSequencerInstanceLambda = this::openSequencerInstance;
    volatile boolean closed;

    public TableSequencerAPI(CairoEngine engine, CairoConfiguration configuration) {
        this.configuration = configuration;
        this.engine = engine;
        this.inactiveTtlUs = configuration.getInactiveWalWriterTTL() * 1000L;
        this.recreateDistressedSequencerAttempts = configuration.getWalRecreateDistressedSequencerAttempts();
        this.createTxnTracker = dir -> new SeqTxnTracker(configuration);
    }

    public void applyRename(TableToken tableToken) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.notifyRename(tableToken);
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.releaseAll();
    }

    public void closeSequencer(TableToken tableToken) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.close();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(TableToken tableToken, boolean failedCreate) {
        block12: {
            LOG.info().$("dropping wal table [table=").$(tableToken).I$();
            try (TableSequencerImpl seq = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
                try {
                    seq.dropTable();
                }
                finally {
                    seq.unlockWrite();
                }
                this.getSeqTxnTracker(tableToken).notifyOnDrop();
            }
            catch (CairoException e) {
                LOG.info().$("failed to drop wal table [table=").$(tableToken).I$();
                if (failedCreate) break block12;
                throw e;
            }
        }
    }

    public void forAllWalTables(ObjHashSet<TableToken> tableTokenBucket, boolean includeDropped, TableSequencerCallback callback) {
        String root = this.configuration.getDbRoot();
        FilesFacade ff = this.configuration.getFilesFacade();
        Path path = Path.PATH.get();
        this.engine.getTableTokens(tableTokenBucket, includeDropped);
        int n = tableTokenBucket.size();
        for (int i = 0; i < n; ++i) {
            boolean isDropped;
            TableToken tableToken = tableTokenBucket.get(i);
            boolean bl = isDropped = includeDropped && this.engine.isTableDropped(tableToken);
            if (this.engine.isWalTable(tableToken) && !isDropped) {
                long lastTxn;
                int tableId;
                block16: {
                    tableId = tableToken.getTableId();
                    try {
                        if (!this.seqRegistry.containsKey(tableToken.getDirName())) {
                            path.of(root).concat(tableToken.getDirName()).concat("txn_seq");
                            long fdTxn = TableUtils.openRO(ff, path, "_txnlog", LOG);
                            lastTxn = ff.readNonNegativeLong(fdTxn, 4L);
                            ff.close(fdTxn);
                            break block16;
                        }
                        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.NONE);){
                            lastTxn = tableSequencer.lastTxn();
                        }
                    }
                    catch (CairoException ex) {
                        if (ex.errnoFileCannotRead() || ex.isTableDropped()) {
                            lastTxn = -1L;
                        }
                        LOG.critical().$("could not read WAL table transaction file [table=").$(tableToken).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
                        continue;
                    }
                }
                try {
                    if (!includeDropped && lastTxn <= -1L) continue;
                    callback.onTable(tableId, tableToken, lastTxn);
                }
                catch (CairoException ex) {
                    LOG.critical().$("could not process table sequencer [table=").$(tableToken).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
                }
                continue;
            }
            if (!isDropped) continue;
            try {
                callback.onTable(tableToken.getTableId(), tableToken, -1L);
                continue;
            }
            catch (CairoException ex) {
                LOG.critical().$("could not process table sequencer [table=").$(tableToken).$(", errno=").$(ex.getErrno()).$(", error=").$(ex).I$();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TransactionLogCursor getCursor(TableToken tableToken, long seqTxn) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            TransactionLogCursor cursor;
            try {
                cursor = tableSequencer.getTransactionLogCursor(seqTxn);
            }
            finally {
                tableSequencer.unlockRead();
            }
            TransactionLogCursor transactionLogCursor = cursor;
            return transactionLogCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TableMetadataChangeLog getMetadataChangeLog(TableToken tableToken, long structureVersionLo) {
        try (TableSequencerImpl tableSequencer = this.getOrOpenSequencer(tableToken, this.openSequencerInstanceLambda);){
            if (tableSequencer.metadataMatches(structureVersionLo)) {
                TableMetadataChangeLog tableMetadataChangeLog = EmptyOperationCursor.INSTANCE;
                return tableMetadataChangeLog;
            }
        }
        tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);
        try {
            try {
                TableMetadataChangeLog tableMetadataChangeLog = tableSequencer.getMetadataChangeLog(structureVersionLo);
                tableSequencer.unlockRead();
                return tableMetadataChangeLog;
            }
            catch (Throwable throwable) {
                tableSequencer.unlockRead();
                throw throwable;
            }
        }
        finally {
            if (tableSequencer != null) {
                tableSequencer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableMetadataChangeLog getMetadataChangeLogSlow(TableToken tableToken, long structureVersionLo) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            TableMetadataChangeLog metadataChangeLog;
            try {
                metadataChangeLog = tableSequencer.getMetadataChangeLogSlow(structureVersionLo);
            }
            finally {
                tableSequencer.unlockRead();
            }
            TableMetadataChangeLog tableMetadataChangeLog = metadataChangeLog;
            return tableMetadataChangeLog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextWalId(TableToken tableToken) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            int walId;
            try {
                walId = tableSequencer.getNextWalId();
            }
            finally {
                tableSequencer.unlockRead();
            }
            int n = walId;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTableMetadata(TableToken tableToken, TableRecordMetadataSink sink) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            try {
                long l = tableSequencer.getTableMetadata(sink);
                tableSequencer.unlockRead();
                return l;
            }
            catch (Throwable throwable) {
                tableSequencer.unlockRead();
                throw throwable;
            }
        }
    }

    public SeqTxnTracker getTxnTracker(TableToken tableToken) {
        return this.getSeqTxnTracker(tableToken);
    }

    public boolean initTxnTracker(TableToken tableToken, long writerTxn, long seqTxn) {
        SeqTxnTracker seqTxnTracker = this.getSeqTxnTracker(tableToken);
        boolean isSuspended = this.isSuspended(tableToken);
        return seqTxnTracker.initTxns(writerTxn, seqTxn, isSuspended);
    }

    public boolean isSuspended(TableToken tableToken) {
        return this.getSeqTxnTracker(tableToken).isSuspended();
    }

    public boolean isTxnTrackerInitialised(TableToken tableToken) {
        return this.getSeqTxnTracker(tableToken).isInitialised();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastTxn(TableToken tableToken) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            long lastTxn;
            try {
                lastTxn = sequencer.lastTxn();
            }
            finally {
                sequencer.unlockRead();
            }
            long l = lastTxn;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextStructureTxn(TableToken tableToken, long structureVersion, AlterOperation alterOp) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            long txn;
            try {
                txn = tableSequencer.nextStructureTxn(structureVersion, alterOp);
            }
            finally {
                tableSequencer.unlockWrite();
            }
            long l = txn;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextTxn(TableToken tableToken, int walId, long expectedSchemaVersion, int segmentId, int segmentTxn, long txnMinTimestamp, long txnMaxTimestamp, long txnRowCount) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            long txn;
            try {
                txn = tableSequencer.nextTxn(expectedSchemaVersion, walId, segmentId, segmentTxn, txnMinTimestamp, txnMaxTimestamp, txnRowCount);
            }
            finally {
                tableSequencer.unlockWrite();
            }
            long l = txn;
            return l;
        }
    }

    public boolean notifyOnCheck(TableToken tableToken, long seqTxn) {
        return this.getSeqTxnTracker(tableToken).notifyOnCheck(seqTxn);
    }

    public void notifySegmentClosed(TableToken tableToken, long txn, int walId, int segmentId) {
        this.engine.getWalListener().segmentClosed(tableToken, txn, walId, segmentId);
    }

    public void openSequencer(TableToken tableToken) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            sequencer.unlockWrite();
        }
    }

    public boolean prepareToConvertToNonWal(TableToken tableToken) {
        boolean isDropped;
        try (TableSequencerImpl seq = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            isDropped = seq.isDropped();
            seq.unlockWrite();
        }
        catch (CairoException e) {
            LOG.info().$("cannot open sequencer files, assumed table converted to non-wal [table=").$(tableToken).I$();
            return true;
        }
        TableSequencerImpl tableSequencer = this.seqRegistry.get(tableToken.getDirName());
        if (tableSequencer != null && tableSequencer.checkClose()) {
            LOG.info().$("table is converted to non-WAL, closed table sequencer [table=").$(tableToken).I$();
            this.seqRegistry.remove(tableToken.getDirName(), tableSequencer);
        }
        return !isDropped;
    }

    public void purgeTxnTracker(String dirName) {
        this.seqTxnTrackers.remove(dirName);
    }

    public void registerTable(int tableId, TableStructure tableDescriptor, TableToken tableToken) {
        try (TableSequencerImpl tableSequencer = this.getTableSequencerEntry(tableToken, SequencerLockType.WRITE, (key, tt) -> new TableSequencerImpl(this, this.engine, tableToken, this.getSeqTxnTracker((TableToken)tt), tableId, tableDescriptor));){
            SeqTxnTracker seqTxnTracker = this.getSeqTxnTracker(tableToken);
            seqTxnTracker.initTxns(0L, 0L, false);
            tableSequencer.unlockWrite();
        }
    }

    public boolean releaseAll() {
        this.seqTxnTrackers.clear();
        return this.releaseAll(Long.MAX_VALUE);
    }

    public boolean releaseInactive() {
        return this.releaseAll(this.configuration.getMicrosecondClock().getTicks() - this.inactiveTtlUs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableToken reload(TableToken tableToken) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                TableToken tableToken2 = tableSequencer.reload();
                tableSequencer.unlockWrite();
                return tableToken2;
            }
            catch (Throwable throwable) {
                tableSequencer.unlockWrite();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadMetadataConditionally(TableToken tableToken, long expectedStructureVersion, TableRecordMetadataSink sink) {
        try (TableSequencerImpl tableSequencer = this.openSequencerLocked(tableToken, SequencerLockType.READ);){
            try {
                if (tableSequencer.getStructureVersion() != expectedStructureVersion) {
                    tableSequencer.getTableMetadata(sink);
                }
            }
            finally {
                tableSequencer.unlockRead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTable(TableToken tableToken, long resumeFromTxn) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                if (!this.isSuspended(tableToken)) {
                    sequencer.resumeTable();
                    return;
                }
                long nextTxn = sequencer.lastTxn() + 1L;
                if (resumeFromTxn > nextTxn) {
                    throw CairoException.nonCritical().put("resume txn is higher than next available transaction [resumeFromTxn=").put(resumeFromTxn).put(", nextTxn=").put(nextTxn).put(']');
                }
                if (resumeFromTxn > 0L) {
                    try (TableWriter tableWriter = this.engine.getWriter(tableToken, "Resume WAL Data Application");){
                        long seqTxn = tableWriter.getAppliedSeqTxn();
                        if (resumeFromTxn - 1L > seqTxn) {
                            tableWriter.commitSeqTxn(resumeFromTxn - 1L);
                        }
                    }
                }
                sequencer.resumeTable();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    public void setDistressed(TableToken tableToken) {
        try (TableSequencerImpl sequencer = this.openSequencerLocked(tableToken, SequencerLockType.WRITE);){
            try {
                sequencer.setDistressed();
            }
            finally {
                sequencer.unlockWrite();
            }
        }
    }

    public void suspendTable(TableToken tableToken, ErrorTag errorTag, String errorMessage) {
        this.getSeqTxnTracker(tableToken).setSuspended(errorTag, errorMessage);
    }

    public boolean updateWriterTxns(TableToken tableToken, long writerTxn, long dirtyWriterTxn) {
        return this.getSeqTxnTracker(tableToken).updateWriterTxns(writerTxn, dirtyWriterTxn);
    }

    @NotNull
    private TableSequencerImpl getOrOpenSequencer(TableToken tableToken, BiFunction<CharSequence, Object, TableSequencerImpl> lambda) {
        int attempt = 0;
        while (attempt < this.recreateDistressedSequencerAttempts) {
            this.throwIfClosed();
            TableSequencerImpl entry = this.seqRegistry.computeIfAbsent(tableToken.getDirName(), tableToken, lambda);
            boolean isDistressed = entry.isDistressed();
            if (!isDistressed && !entry.isClosed()) {
                return entry;
            }
            if (!isDistressed) continue;
            ++attempt;
        }
        throw CairoException.critical(0).put("sequencer is distressed [table=").put(tableToken.getDirName()).put(']');
    }

    private SeqTxnTracker getSeqTxnTracker(TableToken tt) {
        return this.seqTxnTrackers.computeIfAbsent(tt.getDirName(), this.createTxnTracker);
    }

    @NotNull
    private TableSequencerImpl getTableSequencerEntry(TableToken tableToken, SequencerLockType lock, BiFunction<CharSequence, Object, TableSequencerImpl> getSequencerLambda) {
        int attempt = 0;
        while (attempt < this.recreateDistressedSequencerAttempts) {
            this.throwIfClosed();
            TableSequencerImpl entry = this.seqRegistry.computeIfAbsent(tableToken.getDirName(), tableToken, getSequencerLambda);
            if (lock == SequencerLockType.READ) {
                entry.readLock();
            } else if (lock == SequencerLockType.WRITE) {
                entry.writeLock();
            }
            boolean isDistressed = entry.isDistressed();
            if (!isDistressed && !entry.isClosed()) {
                return entry;
            }
            if (lock == SequencerLockType.READ) {
                entry.unlockRead();
            } else if (lock == SequencerLockType.WRITE) {
                entry.unlockWrite();
            }
            if (!isDistressed) continue;
            ++attempt;
        }
        throw CairoException.critical(0).put("sequencer is distressed [table=").put(tableToken.getDirName()).put(']');
    }

    private TableSequencerImpl openSequencerInstance(CharSequence tableDir, Object tableToken) {
        return new TableSequencerImpl(this, this.engine, (TableToken)tableToken, this.getSeqTxnTracker((TableToken)tableToken), 0, null);
    }

    @NotNull
    private TableSequencerImpl openSequencerLocked(TableToken tableToken, SequencerLockType lock) {
        return this.getTableSequencerEntry(tableToken, lock, this.openSequencerInstanceLambda);
    }

    private boolean releaseEntries(long deadline) {
        if (this.seqRegistry.isEmpty()) {
            return true;
        }
        boolean removed = false;
        Iterator<CharSequence> iterator = ((ConcurrentHashMap.KeySetView)this.seqRegistry.keySet()).iterator();
        while (iterator.hasNext()) {
            CharSequence tableDir = iterator.next();
            TableSequencerImpl sequencer = this.seqRegistry.get(tableDir);
            if (sequencer == null || deadline < sequencer.releaseTime || sequencer.isClosed() || !sequencer.checkClose()) continue;
            LOG.info().$("releasing idle table sequencer [tableDir=").$safe(tableDir).I$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    private void throwIfClosed() {
        if (this.closed) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    protected boolean releaseAll(long deadline) {
        return this.releaseEntries(deadline);
    }

    static enum SequencerLockType {
        WRITE,
        READ,
        NONE;

    }

    @FunctionalInterface
    public static interface TableSequencerCallback {
        public void onTable(int var1, TableToken var2, long var3);
    }
}

