/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypeDriver;
import io.questdb.cairo.SymbolMapReaderImpl;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.NullMemoryCMR;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMR;
import io.questdb.cairo.vm.api.MemoryCR;
import io.questdb.cairo.wal.SymbolMapDiff;
import io.questdb.cairo.wal.SymbolMapDiffEntry;
import io.questdb.cairo.wal.WalDataCursor;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalTxnType;
import io.questdb.cairo.wal.seq.SequencerMetadata;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class WalReader
implements Closeable {
    private static final Log LOG = LogFactory.getLog(WalReader.class);
    private final int columnCount;
    private final ObjList<MemoryCMR> columns;
    private final WalDataCursor dataCursor = new WalDataCursor();
    private final WalEventCursor eventCursor;
    private final WalEventReader events;
    private final FilesFacade ff;
    private final SequencerMetadata metadata;
    private final Path path;
    private final int rootLen;
    private final long rowCount;
    private final ObjList<IntObjHashMap<CharSequence>> symbolMaps = new ObjList();
    private final String tableName;
    private final String walName;

    public WalReader(CairoConfiguration configuration, TableToken tableToken, CharSequence walName, int segmentId, long rowCount) {
        this.tableName = tableToken.getTableName();
        this.walName = Chars.toString(walName);
        this.rowCount = rowCount;
        this.ff = configuration.getFilesFacade();
        this.path = new Path();
        this.path.of(configuration.getDbRoot()).concat(tableToken.getDirName()).concat(walName);
        this.rootLen = this.path.size();
        try {
            this.metadata = new SequencerMetadata(this.ff, configuration.getCommitMode(), true);
            this.metadata.open(this.path.slash().put(segmentId), this.rootLen, tableToken);
            this.columnCount = this.metadata.getColumnCount();
            this.events = new WalEventReader(this.ff);
            LOG.debug().$("open [table=").$safe(this.tableName).I$();
            int pathLen = this.path.size();
            this.eventCursor = this.events.of(this.path.slash().put(segmentId), -1L);
            this.path.trimTo(pathLen);
            this.openSymbolMaps(this.eventCursor, configuration);
            this.path.slash().put(segmentId);
            this.eventCursor.reset();
            int capacity = 2 * this.columnCount + 2;
            this.columns = new ObjList(capacity);
            this.columns.setPos(capacity + 2);
            this.columns.setQuick(0, NullMemoryCMR.INSTANCE);
            this.columns.setQuick(1, NullMemoryCMR.INSTANCE);
            this.dataCursor.of(this);
        }
        catch (Throwable e) {
            this.close();
            throw e;
        }
    }

    @Override
    public void close() {
        Misc.free(this.events);
        Misc.free(this.metadata);
        Misc.freeObjList(this.columns);
        Misc.free(this.path);
        LOG.debug().$("closed '").$safe(this.tableName).$('\'').$();
    }

    public MemoryCR getColumn(int absoluteIndex) {
        return this.columns.getQuick(absoluteIndex);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int columnIndex) {
        return this.metadata.getColumnName(columnIndex);
    }

    public int getColumnType(int columnIndex) {
        return this.metadata.getColumnType(columnIndex);
    }

    public WalDataCursor getDataCursor() {
        this.dataCursor.toTop();
        return this.dataCursor;
    }

    public WalEventCursor getEventCursor() {
        return this.eventCursor;
    }

    public int getRealColumnCount() {
        return this.metadata.getRealColumnCount();
    }

    public CharSequence getSymbolValue(int col, int key) {
        IntObjHashMap<CharSequence> symbolMap = this.symbolMaps.getQuick(col);
        return symbolMap.get(key);
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTimestampIndex() {
        return this.metadata.getTimestampIndex();
    }

    public String getWalName() {
        return this.walName;
    }

    public long openSegment() {
        try {
            if (this.ff.exists(this.path.$())) {
                this.openSegmentColumns();
                long l = this.rowCount;
                return l;
            }
            LOG.error().$("open segment failed, segment does not exist on the disk. [path=").$(this.path).I$();
            throw CairoException.critical(0).put("WAL data directory does not exist on disk at ").put(this.path);
        }
        finally {
            this.path.trimTo(this.rootLen);
        }
    }

    public long size() {
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumnAt(int columnIndex) {
        int pathLen = this.path.size();
        try {
            int columnType = this.metadata.getColumnType(columnIndex);
            if (columnType > 0) {
                String columnName = this.metadata.getColumnName(columnIndex);
                int dataMemIndex = WalReader.getPrimaryColumnIndex(columnIndex);
                int auxMemIndex = dataMemIndex + 1;
                MemoryCMR dataMem = this.columns.getQuick(dataMemIndex);
                if (ColumnType.isVarSize(columnType)) {
                    ColumnTypeDriver columnTypeDriver = ColumnType.getDriver(columnType);
                    long auxMemSize = columnTypeDriver.getAuxVectorSize(this.rowCount);
                    TableUtils.iFile(this.path.trimTo(pathLen), columnName);
                    MemoryCMR auxMem = this.columns.getQuick(auxMemIndex);
                    auxMem = this.openOrCreateMemory(this.path, this.columns, auxMemIndex, auxMem, auxMemSize);
                    long dataMemSize = columnTypeDriver.getDataVectorSizeAt(auxMem.addressOf(0L), this.rowCount - 1L);
                    TableUtils.dFile(this.path.trimTo(pathLen), columnName);
                    this.openOrCreateMemory(this.path, this.columns, dataMemIndex, dataMem, dataMemSize);
                } else {
                    long dataMemSize = this.rowCount << ColumnType.pow2SizeOf(columnType);
                    TableUtils.dFile(this.path.trimTo(pathLen), columnName);
                    this.openOrCreateMemory(this.path, this.columns, dataMemIndex, dataMem, columnIndex == this.getTimestampIndex() ? dataMemSize << 1 : dataMemSize);
                    Misc.free(this.columns.getAndSetQuick(auxMemIndex, null));
                }
            }
        }
        finally {
            this.path.trimTo(pathLen);
        }
    }

    @NotNull
    private MemoryCMR openOrCreateMemory(Path path, ObjList<MemoryCMR> columns, int primaryIndex, MemoryCMR mem, long columnSize) {
        if (mem != null && mem != NullMemoryCMR.INSTANCE) {
            mem.of(this.ff, path.$(), columnSize, columnSize, 10);
        } else {
            mem = Vm.getCMRInstance(this.ff, path.$(), columnSize, 10);
            columns.setQuick(primaryIndex, mem);
        }
        return mem;
    }

    private void openSegmentColumns() {
        for (int i = 0; i < this.columnCount; ++i) {
            this.loadColumnAt(i);
        }
    }

    private void openSymbolMaps(WalEventCursor eventCursor, CairoConfiguration configuration) {
        while (eventCursor.hasNext()) {
            if (!WalTxnType.isDataType(eventCursor.getType())) continue;
            WalEventCursor.DataInfo dataInfo = eventCursor.getDataInfo();
            SymbolMapDiff symbolDiff = dataInfo.nextSymbolMapDiff();
            while (symbolDiff != null) {
                IntObjHashMap<Object> symbolMap;
                int cleanSymbolCount = symbolDiff.getCleanSymbolCount();
                int columnIndex = symbolDiff.getColumnIndex();
                if (this.symbolMaps.size() <= columnIndex || this.symbolMaps.getQuick(columnIndex) == null) {
                    symbolMap = new IntObjHashMap();
                    if (cleanSymbolCount > 0) {
                        try (SymbolMapReaderImpl symbolMapReader = new SymbolMapReaderImpl(configuration, this.path, this.metadata.getColumnName(columnIndex), -1L, cleanSymbolCount);){
                            for (int key = 0; key < cleanSymbolCount; ++key) {
                                CharSequence symbol = symbolMapReader.valueOf(key);
                                symbolMap.put(key, String.valueOf(symbol));
                            }
                        }
                    }
                    this.symbolMaps.extendAndSet(columnIndex, symbolMap);
                } else {
                    symbolMap = this.symbolMaps.getQuick(columnIndex);
                }
                SymbolMapDiffEntry entry = symbolDiff.nextEntry();
                while (entry != null) {
                    symbolMap.put(entry.getKey(), String.valueOf(entry.getSymbol()));
                    entry = symbolDiff.nextEntry();
                }
                symbolDiff = dataInfo.nextSymbolMapDiff();
            }
        }
    }

    static int getPrimaryColumnIndex(int index) {
        return index * 2 + 2;
    }
}

