/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.sql;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.ByteList;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectPool;
import io.questdb.std.Rows;

public class PageFrameAddressCache
implements Mutable {
    private final ObjList<LongList> auxPageAddresses = new ObjList();
    private final ObjList<LongList> auxPageSizes = new ObjList();
    private final IntList columnIndexes = new IntList();
    private final IntList columnTypes = new IntList();
    private final ByteList frameFormats = new ByteList();
    private final LongList frameSizes = new LongList();
    private final ObjectPool<LongList> longListPool = new ObjectPool<LongList>(LongList::new, 64);
    private final long nativeCacheSizeThreshold;
    private final ObjList<LongList> pageAddresses = new ObjList();
    private final ObjList<LongList> pageSizes = new ObjList();
    private final LongList parquetAddresses = new LongList();
    private final LongList parquetFileSizes = new LongList();
    private final IntList parquetRowGroupHis = new IntList();
    private final IntList parquetRowGroupLos = new IntList();
    private final IntList parquetRowGroups = new IntList();
    private final LongList rowIdOffsets = new LongList();
    private long cacheSize;
    private int columnCount;

    public PageFrameAddressCache(CairoConfiguration configuration) {
        this.nativeCacheSizeThreshold = configuration.getSqlJitPageAddressCacheThreshold() / 8;
    }

    public void add(int frameIndex, PageFrame frame) {
        if (this.frameSizes.size() >= frameIndex + 1) {
            return;
        }
        if (frame.getFormat() == 0) {
            LongList framePageAddresses = this.longListPool.next();
            LongList framePageSizes = this.longListPool.next();
            LongList frameAuxPageAddresses = this.longListPool.next();
            LongList frameAuxPageSizes = this.longListPool.next();
            for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
                framePageAddresses.add(frame.getPageAddress(columnIndex));
                framePageSizes.add(frame.getPageSize(columnIndex));
                if (ColumnType.isVarSize(this.columnTypes.getQuick(columnIndex))) {
                    frameAuxPageAddresses.add(frame.getAuxPageAddress(columnIndex));
                    frameAuxPageSizes.add(frame.getAuxPageSize(columnIndex));
                    continue;
                }
                frameAuxPageAddresses.add(0L);
                frameAuxPageSizes.add(0L);
            }
            this.pageAddresses.add(framePageAddresses);
            this.cacheSize += (long)framePageAddresses.capacity();
            this.pageSizes.add(framePageSizes);
            this.cacheSize += (long)framePageSizes.capacity();
            this.auxPageAddresses.add(frameAuxPageAddresses);
            this.cacheSize += (long)frameAuxPageAddresses.capacity();
            this.auxPageSizes.add(frameAuxPageSizes);
            this.cacheSize += (long)frameAuxPageSizes.capacity();
        } else {
            this.pageAddresses.add(null);
            this.pageSizes.add(null);
            this.auxPageAddresses.add(null);
            this.auxPageSizes.add(null);
        }
        this.frameSizes.add(frame.getPartitionHi() - frame.getPartitionLo());
        this.frameFormats.add(frame.getFormat());
        this.parquetAddresses.add(frame.getParquetAddr());
        long fileSize = frame.getParquetFileSize();
        assert (fileSize > 0L || frame.getFormat() != 1);
        this.parquetFileSizes.add(fileSize);
        this.parquetRowGroups.add(frame.getParquetRowGroup());
        this.parquetRowGroupLos.add(frame.getParquetRowGroupLo());
        this.parquetRowGroupHis.add(frame.getParquetRowGroupHi());
        this.rowIdOffsets.add(Rows.toRowID(frame.getPartitionIndex(), frame.getPartitionLo()));
    }

    @Override
    public void clear() {
        this.frameSizes.clear();
        this.frameFormats.clear();
        this.parquetAddresses.clear();
        this.parquetRowGroups.clear();
        this.parquetFileSizes.clear();
        this.parquetRowGroupLos.clear();
        this.parquetRowGroupHis.clear();
        this.pageAddresses.clear();
        this.auxPageAddresses.clear();
        this.pageSizes.clear();
        this.auxPageSizes.clear();
        this.rowIdOffsets.clear();
        if (this.cacheSize < this.nativeCacheSizeThreshold) {
            this.longListPool.clear();
        } else {
            this.longListPool.resetCapacity();
        }
        this.cacheSize = 0L;
    }

    public LongList getAuxPageAddresses(int frameIndex) {
        return this.auxPageAddresses.getQuick(frameIndex);
    }

    public LongList getAuxPageSizes(int frameIndex) {
        return this.auxPageSizes.getQuick(frameIndex);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public IntList getColumnIndexes() {
        return this.columnIndexes;
    }

    public IntList getColumnTypes() {
        return this.columnTypes;
    }

    public byte getFrameFormat(int frameIndex) {
        return this.frameFormats.getQuick(frameIndex);
    }

    public long getFrameSize(int frameIndex) {
        return this.frameSizes.getQuick(frameIndex);
    }

    public LongList getPageAddresses(int frameIndex) {
        return this.pageAddresses.getQuick(frameIndex);
    }

    public LongList getPageSizes(int frameIndex) {
        return this.pageSizes.getQuick(frameIndex);
    }

    public long getParquetAddr(int frameIndex) {
        return this.parquetAddresses.getQuick(frameIndex);
    }

    public long getParquetFileSize(int frameIndex) {
        long fileSize = this.parquetFileSizes.getQuick(frameIndex);
        assert (fileSize > 0L);
        return fileSize;
    }

    public int getParquetRowGroup(int frameIndex) {
        return this.parquetRowGroups.getQuick(frameIndex);
    }

    public int getParquetRowGroupHi(int frameIndex) {
        return this.parquetRowGroupHis.getQuick(frameIndex);
    }

    public int getParquetRowGroupLo(int frameIndex) {
        return this.parquetRowGroupLos.getQuick(frameIndex);
    }

    public long getRowIdOffset(int frameIndex) {
        return this.rowIdOffsets.getQuick(frameIndex);
    }

    public boolean isVarSizeColumn(int columnIndex) {
        return ColumnType.isVarSize(this.columnTypes.getQuick(columnIndex));
    }

    public void of(RecordMetadata metadata, IntList columnIndexes) {
        this.columnCount = metadata.getColumnCount();
        this.columnTypes.clear();
        for (int columnIndex = 0; columnIndex < this.columnCount; ++columnIndex) {
            this.columnTypes.add(metadata.getColumnType(columnIndex));
        }
        this.columnIndexes.clear();
        this.columnIndexes.addAll(columnIndexes);
        this.clear();
    }
}

