/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.BorrowedArray;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.OrderedMap;
import io.questdb.cairo.map.OrderedMapRecord;
import io.questdb.cairo.map.OrderedMapValue;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectBinarySequence;
import io.questdb.std.Hash;
import io.questdb.std.IntList;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectString;
import io.questdb.std.str.DirectUtf8String;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class OrderedMapVarSizeRecord
implements OrderedMapRecord {
    private final BorrowedArray[] arrays;
    private final DirectBinarySequence[] bs;
    private final DirectString[] csA;
    private final DirectString[] csB;
    private final Interval[] intervals;
    private final Long256Impl[] keyLong256A;
    private final Long256Impl[] keyLong256B;
    private final ColumnTypes keyTypes;
    private final int splitIndex;
    private final DirectUtf8String[] usA;
    private final DirectUtf8String[] usB;
    private final OrderedMapValue value;
    private final long[] valueOffsets;
    private final long valueSize;
    private long keyAddress;
    private int keySize = -1;
    private int lastKeyIndex = -1;
    private int lastKeyOffset = -1;
    private long limit;
    private long startAddress;
    private IntList symbolTableIndex;
    private RecordCursor symbolTableResolver;
    private long valueAddress;

    OrderedMapVarSizeRecord(long valueSize, long[] valueOffsets, OrderedMapValue value, @NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes) {
        int i;
        int nColumns;
        int keyIndexOffset;
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.value = value;
        this.value.linkRecord(this);
        int n = this.splitIndex = valueOffsets != null ? valueOffsets.length : 0;
        if (valueTypes != null) {
            keyIndexOffset = valueTypes.getColumnCount();
            nColumns = keyTypes.getColumnCount() + valueTypes.getColumnCount();
        } else {
            keyIndexOffset = 0;
            nColumns = keyTypes.getColumnCount();
        }
        DirectString[] csA = null;
        DirectString[] csB = null;
        DirectUtf8String[] usA = null;
        DirectUtf8String[] usB = null;
        DirectBinarySequence[] bs = null;
        Long256Impl[] long256A = null;
        Long256Impl[] long256B = null;
        BorrowedArray[] arrays = null;
        Interval[] intervals = null;
        ArrayColumnTypes keyTypesCopy = new ArrayColumnTypes();
        int n2 = keyTypes.getColumnCount();
        block8: for (i = 0; i < n2; ++i) {
            int columnType = keyTypes.getColumnType(i);
            keyTypesCopy.add(columnType);
            switch (ColumnType.tagOf(columnType)) {
                case 11: {
                    if (csA == null) {
                        csA = new DirectString[nColumns];
                        csB = new DirectString[nColumns];
                    }
                    csA[i + keyIndexOffset] = new DirectString();
                    csB[i + keyIndexOffset] = new DirectString();
                    continue block8;
                }
                case 26: {
                    if (usA == null) {
                        usA = new DirectUtf8String[nColumns];
                        usB = new DirectUtf8String[nColumns];
                    }
                    usA[i + keyIndexOffset] = new DirectUtf8String();
                    usB[i + keyIndexOffset] = new DirectUtf8String();
                    continue block8;
                }
                case 18: {
                    if (bs == null) {
                        bs = new DirectBinarySequence[nColumns];
                    }
                    bs[i + keyIndexOffset] = new DirectBinarySequence();
                    continue block8;
                }
                case 13: {
                    if (long256A == null) {
                        long256A = new Long256Impl[nColumns];
                        long256B = new Long256Impl[nColumns];
                    }
                    long256A[i + keyIndexOffset] = new Long256Impl();
                    long256B[i + keyIndexOffset] = new Long256Impl();
                    continue block8;
                }
                case 32: {
                    if (intervals == null) {
                        intervals = new Interval[nColumns];
                    }
                    intervals[i + keyIndexOffset] = new Interval();
                    continue block8;
                }
                case 27: {
                    if (arrays == null) {
                        arrays = new BorrowedArray[nColumns];
                    }
                    arrays[i + keyIndexOffset] = new BorrowedArray();
                    continue block8;
                }
            }
        }
        this.keyTypes = keyTypesCopy;
        if (valueTypes != null) {
            n2 = valueTypes.getColumnCount();
            for (i = 0; i < n2; ++i) {
                if (ColumnType.tagOf(valueTypes.getColumnType(i)) != 13) continue;
                if (long256A == null) {
                    long256A = new Long256Impl[nColumns];
                    long256B = new Long256Impl[nColumns];
                }
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        }
        this.csA = csA;
        this.csB = csB;
        this.usA = usA;
        this.usB = usB;
        this.bs = bs;
        this.keyLong256A = long256A;
        this.keyLong256B = long256B;
        this.arrays = arrays;
        this.intervals = intervals;
    }

    private OrderedMapVarSizeRecord(long valueSize, long[] valueOffsets, ColumnTypes keyTypes, int splitIndex, DirectString[] csA, DirectString[] csB, DirectUtf8String[] usA, DirectUtf8String[] usB, DirectBinarySequence[] bs, Long256Impl[] keyLong256A, Long256Impl[] keyLong256B, BorrowedArray[] arrays, Interval[] intervals) {
        this.valueSize = valueSize;
        this.valueOffsets = valueOffsets;
        this.keyTypes = keyTypes;
        this.splitIndex = splitIndex;
        this.value = new OrderedMapValue(valueSize, valueOffsets);
        this.csA = csA;
        this.csB = csB;
        this.usA = usA;
        this.usB = usB;
        this.bs = bs;
        this.keyLong256A = keyLong256A;
        this.keyLong256B = keyLong256B;
        this.arrays = arrays;
        this.intervals = intervals;
    }

    @Override
    public OrderedMapVarSizeRecord clone() {
        BorrowedArray[] arrays;
        Interval[] intervals;
        Long256Impl[] long256B;
        Long256Impl[] long256A;
        DirectBinarySequence[] bs;
        DirectUtf8String[] usB;
        DirectUtf8String[] usA;
        int i;
        DirectString[] csB;
        DirectString[] csA;
        int n;
        if (this.csA != null) {
            n = this.csA.length;
            csA = new DirectString[n];
            csB = new DirectString[n];
            for (i = 0; i < n; ++i) {
                if (this.csA[i] == null) continue;
                csA[i] = new DirectString();
                csB[i] = new DirectString();
            }
        } else {
            csA = null;
            csB = null;
        }
        if (this.usA != null) {
            n = this.usA.length;
            usA = new DirectUtf8String[n];
            usB = new DirectUtf8String[n];
            for (i = 0; i < n; ++i) {
                if (this.usA[i] == null) continue;
                usA[i] = new DirectUtf8String();
                usB[i] = new DirectUtf8String();
            }
        } else {
            usA = null;
            usB = null;
        }
        if (this.bs != null) {
            n = this.bs.length;
            bs = new DirectBinarySequence[n];
            for (i = 0; i < n; ++i) {
                if (this.bs[i] == null) continue;
                bs[i] = new DirectBinarySequence();
            }
        } else {
            bs = null;
        }
        if (this.keyLong256A != null) {
            n = this.keyLong256A.length;
            long256A = new Long256Impl[n];
            long256B = new Long256Impl[n];
            for (i = 0; i < n; ++i) {
                if (this.keyLong256A[i] == null) continue;
                long256A[i] = new Long256Impl();
                long256B[i] = new Long256Impl();
            }
        } else {
            long256A = null;
            long256B = null;
        }
        if (this.intervals != null) {
            n = this.intervals.length;
            intervals = new Interval[n];
            for (i = 0; i < n; ++i) {
                if (this.intervals[i] == null) continue;
                intervals[i] = new Interval();
            }
        } else {
            intervals = null;
        }
        if (this.arrays != null) {
            n = this.arrays.length;
            arrays = new BorrowedArray[n];
            for (i = 0; i < n; ++i) {
                if (this.arrays[i] == null) continue;
                arrays[i] = new BorrowedArray();
            }
        } else {
            arrays = null;
        }
        return new OrderedMapVarSizeRecord(this.valueSize, this.valueOffsets, this.keyTypes, this.splitIndex, csA, csB, usA, usB, bs, long256A, long256B, arrays, intervals);
    }

    @Override
    public void copyToKey(MapKey destKey) {
        OrderedMap.VarSizeKey destFastKey = (OrderedMap.VarSizeKey)destKey;
        int keySize = Unsafe.getUnsafe().getInt(this.startAddress);
        destFastKey.copyFromRawKey(this.keyAddress, keySize);
    }

    @Override
    public void copyValue(MapValue destValue) {
        OrderedMapValue destFastValue = (OrderedMapValue)destValue;
        destFastValue.copyRawValue(this.valueAddress);
    }

    @Override
    public ArrayView getArray(int index, int columnType) {
        long address = this.addressOfColumn(index);
        BorrowedArray ba = this.arrays[index];
        return ArrayTypeDriver.getPlainValue(address, ba);
    }

    @Override
    public BinarySequence getBin(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        int len = Unsafe.getUnsafe().getInt(address);
        if (len == -1) {
            return null;
        }
        DirectBinarySequence bs = this.bs[columnIndex];
        bs.of(address + 4L, len);
        return bs;
    }

    @Override
    public long getBinLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public boolean getBool(int columnIndex) {
        return Unsafe.getBool(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getByte(int columnIndex) {
        return Unsafe.getUnsafe().getByte(this.addressOfColumn(columnIndex));
    }

    @Override
    public char getChar(int columnIndex) {
        return Unsafe.getUnsafe().getChar(this.addressOfColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        return Unsafe.getUnsafe().getDouble(this.addressOfColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        return Unsafe.getUnsafe().getFloat(this.addressOfColumn(columnIndex));
    }

    @Override
    public byte getGeoByte(int columnIndex) {
        return this.getByte(columnIndex);
    }

    @Override
    public int getGeoInt(int columnIndex) {
        return this.getInt(columnIndex);
    }

    @Override
    public long getGeoLong(int columnIndex) {
        return this.getLong(columnIndex);
    }

    @Override
    public short getGeoShort(int columnIndex) {
        return this.getShort(columnIndex);
    }

    @Override
    public int getIPv4(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public int getInt(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public Interval getInterval(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        long lo = Unsafe.getUnsafe().getLong(address);
        long hi = Unsafe.getUnsafe().getLong(address + 8L);
        Interval interval = this.intervals[columnIndex];
        return interval.of(lo, hi);
    }

    @Override
    public long getLong(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public long getLong128Hi(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex) + 8L);
    }

    @Override
    public long getLong128Lo(int columnIndex) {
        return Unsafe.getUnsafe().getLong(this.addressOfColumn(columnIndex));
    }

    @Override
    public void getLong256(int columnIndex, CharSink<?> sink) {
        Numbers.appendLong256FromUnsafe(this.addressOfColumn(columnIndex), sink);
    }

    @Override
    public Long256 getLong256A(int columnIndex) {
        return this.getLong256Generic(this.keyLong256A, columnIndex);
    }

    @Override
    public Long256 getLong256B(int columnIndex) {
        return this.getLong256Generic(this.keyLong256B, columnIndex);
    }

    @Override
    public long getRowId() {
        return this.startAddress;
    }

    @Override
    public short getShort(int columnIndex) {
        return Unsafe.getUnsafe().getShort(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getStrA(int columnIndex) {
        return this.getStr0(columnIndex, this.csA[columnIndex]);
    }

    @Override
    public CharSequence getStrB(int columnIndex) {
        return this.getStr0(columnIndex, this.csB[columnIndex]);
    }

    @Override
    public int getStrLen(int columnIndex) {
        return Unsafe.getUnsafe().getInt(this.addressOfColumn(columnIndex));
    }

    @Override
    public CharSequence getSymA(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueOf(this.getInt(columnIndex));
    }

    @Override
    public CharSequence getSymB(int columnIndex) {
        return this.symbolTableResolver.getSymbolTable(this.symbolTableIndex.getQuick(columnIndex)).valueBOf(this.getInt(columnIndex));
    }

    @Override
    public MapValue getValue() {
        return this.value.of(this.startAddress, this.valueAddress, this.limit, false);
    }

    @Override
    public Utf8Sequence getVarcharA(int columnIndex) {
        return this.getVarchar0(columnIndex, this.usA[columnIndex]);
    }

    @Override
    public Utf8Sequence getVarcharB(int columnIndex) {
        return this.getVarchar0(columnIndex, this.usB[columnIndex]);
    }

    @Override
    public int getVarcharSize(int columnIndex) {
        long address = this.addressOfColumn(columnIndex);
        return VarcharTypeDriver.getPlainValueSize(address);
    }

    @Override
    public long keyHashCode() {
        int keySize = Unsafe.getUnsafe().getInt(this.startAddress);
        return Hash.hashMem64(this.startAddress + 4L, keySize);
    }

    public int keySize() {
        return this.keySize;
    }

    @Override
    public void of(long address) {
        this.startAddress = address;
        this.keyAddress = address + 4L;
        this.keySize = Unsafe.getUnsafe().getInt(address);
        this.valueAddress = address + 4L + (long)this.keySize;
        this.lastKeyIndex = -1;
        this.lastKeyOffset = -1;
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public void setSymbolTableResolver(RecordCursor resolver, IntList symbolTableIndex) {
        this.symbolTableResolver = resolver;
        this.symbolTableIndex = symbolTableIndex;
    }

    private long addressOfColumn(int index) {
        if (index < this.splitIndex) {
            return this.valueAddress + this.valueOffsets[index];
        }
        if (index == this.splitIndex) {
            return this.keyAddress;
        }
        return this.addressOfKeyColumn(index - this.splitIndex);
    }

    private long addressOfKeyColumn(int index) {
        long addr = this.keyAddress;
        int i = 0;
        if (this.lastKeyIndex > -1 && index >= this.lastKeyIndex) {
            addr += (long)this.lastKeyOffset;
            i = this.lastKeyIndex;
        }
        while (i < index) {
            int columnType = this.keyTypes.getColumnType(i);
            int size = ColumnType.sizeOf(columnType);
            if (size > 0) {
                addr += (long)size;
            } else if (ColumnType.isArray(columnType)) {
                addr += ArrayTypeDriver.getPlainValueSize(addr);
            } else {
                assert (columnType == 11 || columnType == 26 || columnType == 18);
                int len = Unsafe.getUnsafe().getInt(addr);
                addr += 4L;
                if (len != -1) {
                    addr = ColumnType.isString(columnType) ? (addr += (long)len << 1) : (addr += (long)(len & Integer.MAX_VALUE));
                }
            }
            ++i;
        }
        this.lastKeyOffset = (int)(addr - this.keyAddress);
        this.lastKeyIndex = i;
        return addr;
    }

    @NotNull
    private Long256 getLong256Generic(Long256Impl[] keyLong256, int columnIndex) {
        Long256Impl long256 = keyLong256[columnIndex];
        long256.fromAddress(this.addressOfColumn(columnIndex));
        return long256;
    }

    private CharSequence getStr0(int index, DirectString cs) {
        long address = this.addressOfColumn(index);
        int len = Unsafe.getUnsafe().getInt(address);
        return len == -1 ? null : cs.of(address + 4L, address + 4L + (long)len * 2L);
    }

    private Utf8Sequence getVarchar0(int index, DirectUtf8String us) {
        long address = this.addressOfColumn(index);
        return VarcharTypeDriver.getPlainValue(address, us);
    }
}

