/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordChain;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import org.jetbrains.annotations.NotNull;

public class RecordArray
extends RecordChain {
    private final MemoryARW auxMem;
    private long size = 0L;
    private long nextRecordIndex = 0L;

    public RecordArray(@NotNull ColumnTypes columnTypes, @NotNull RecordSink recordSink, long pageSize, int maxPages) {
        super(columnTypes, recordSink, pageSize, maxPages);
        this.auxMem = Vm.getCARWInstance(pageSize >> 4, maxPages, 50);
    }

    public long put(Record record) {
        long offset = this.beginRecord();
        this.recordSink.copy(record, this);
        return offset;
    }

    public long beginRecord() {
        this.recordOffset = this.varAppendOffset;
        this.auxMem.putLong(this.recordOffset);
        ++this.size;
        this.mem.jumpTo(this.recordOffset + this.varOffset);
        this.varAppendOffset = this.recordOffset + this.varOffset + this.fixOffset;
        return this.recordOffset;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRecordIndex < this.size) {
            long offset = this.auxMem.getLong(this.nextRecordIndex * 8L);
            this.recordA.of(offset);
            ++this.nextRecordIndex;
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.nextRecordIndex = 0L;
    }

    public void toBottom() {
        this.nextRecordIndex = this.size - 1L;
    }

    public boolean hasPrev() {
        if (this.nextRecordIndex >= 0L) {
            long offset = this.auxMem.getLong(this.nextRecordIndex * 8L);
            this.recordA.of(offset);
            --this.nextRecordIndex;
            return true;
        }
        return false;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        counter.add(this.size);
    }

    @Override
    public void clear() {
        super.clear();
        this.size = 0L;
        this.auxMem.close();
    }

    @Override
    protected long rowToDataOffset(long row) {
        return row;
    }

    @Override
    protected RecordChain.RecordChainRecord newChainRecord() {
        return new RecordArrayRecord(this.columnCount);
    }

    class RecordArrayRecord
    extends RecordChain.RecordChainRecord {
        public RecordArrayRecord(int columnCount) {
            super(columnCount);
        }

        @Override
        public long getRowId() {
            return this.baseOffset;
        }
    }
}

