/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.BitmapIndexUtils;
import io.questdb.cairo.BitmapIndexWriter;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.RebuildColumnBase;
import io.questdb.cairo.SymbolColumnIndexer;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMAR;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.Misc;
import io.questdb.std.str.LPSZ;

public class IndexBuilder
extends RebuildColumnBase {
    private static final Log LOG = LogFactory.getLog(IndexBuilder.class);
    private final MemoryMAR ddlMem;
    private final SymbolColumnIndexer indexer;

    public IndexBuilder(CairoConfiguration configuration) {
        super(configuration);
        this.ddlMem = Vm.getPMARInstance(configuration);
        this.indexer = new SymbolColumnIndexer(configuration);
        this.unsupportedColumnMessage = "Column is not indexed";
    }

    @Override
    public void clear() {
        super.clear();
        this.ddlMem.close();
        this.indexer.clear();
    }

    @Override
    public void close() {
        super.close();
        Misc.free(this.indexer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndexFiles(FilesFacade ff, CharSequence columnName, int indexValueBlockCapacity, int plen, long columnNameTxn) {
        try {
            LPSZ lpsz = BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn);
            try {
                LOG.info().$("writing ").$(this.path).$();
                this.ddlMem.smallFile(ff, lpsz, 12);
                BitmapIndexWriter.initKeyMemory(this.ddlMem, indexValueBlockCapacity);
            }
            catch (CairoException e) {
                LOG.error().$("could not create index [name=").$(this.path).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                if (!ff.removeQuiet(lpsz)) {
                    LOG.error().$("could not remove '").$(this.path).$("'. Please remove MANUALLY.").$("[errno=").$(ff.errno()).I$();
                }
                throw e;
            }
            finally {
                this.ddlMem.close();
            }
            if (!ff.touch(BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn))) {
                LOG.error().$("could not create index [name=").$(this.path).I$();
                throw CairoException.critical(ff.errno()).put("could not create index [name=").put(this.path).put(']');
            }
            LOG.info().$("writing ").$(this.path).$();
        }
        finally {
            this.path.trimTo(plen);
        }
    }

    private void removeFile(FilesFacade ff, LPSZ path) {
        LOG.info().$("deleting ").$(path).$();
        if (!ff.removeQuiet(path)) {
            int errno = ff.errno();
            if (!ff.exists(path)) {
                LOG.info().$("index file did not exist, file will be re-written [path=").$(path).I$();
            } else {
                throw CairoException.critical(errno).put("could not remove index file [file=").put(this.path).put(']');
            }
        }
    }

    private void removeIndexFiles(FilesFacade ff, CharSequence columnName, long columnNameTxn) {
        int plen = this.path.size();
        this.removeFile(ff, BitmapIndexUtils.keyFileName(this.path.trimTo(plen), columnName, columnNameTxn));
        this.removeFile(ff, BitmapIndexUtils.valueFileName(this.path.trimTo(plen), columnName, columnNameTxn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReindex(FilesFacade ff, ColumnVersionReader columnVersionReader, int columnWriterIndex, CharSequence columnName, long partitionNameTxn, long partitionSize, long partitionTimestamp, int partitionBy, int indexValueBlockCapacity) {
        block8: {
            int trimTo = this.path.size();
            TableUtils.setPathForNativePartition(this.path, partitionBy, partitionTimestamp, partitionNameTxn);
            try {
                int plen = this.path.size();
                if (ff.exists(this.path.$())) {
                    long columnNameTxn = columnVersionReader.getColumnNameTxn(partitionTimestamp, columnWriterIndex);
                    this.removeIndexFiles(ff, columnName, columnNameTxn);
                    TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn);
                    long columnTop = columnVersionReader.getColumnTop(partitionTimestamp, columnWriterIndex);
                    if (columnTop > -1L) {
                        if (partitionSize <= columnTop) break block8;
                        LOG.info().$("indexing [path=").$(this.path).I$();
                        this.createIndexFiles(ff, columnName, indexValueBlockCapacity, plen, columnNameTxn);
                        long columnDataFd = TableUtils.openRO(ff, TableUtils.dFile(this.path.trimTo(plen), columnName, columnNameTxn), LOG);
                        try {
                            this.indexer.configureWriter(this.path.trimTo(plen), columnName, columnNameTxn, columnTop);
                            this.indexer.index(ff, columnDataFd, columnTop, partitionSize);
                            break block8;
                        }
                        finally {
                            ff.close(columnDataFd);
                            this.indexer.clear();
                        }
                    }
                    LOG.info().$("column is empty in partition [path=").$(this.path).I$();
                    break block8;
                }
                LOG.info().$("partition does not exist [path=").$(this.path).I$();
            }
            finally {
                this.path.trimTo(trimTo);
            }
        }
    }

    @Override
    protected boolean isSupportedColumn(RecordMetadata metadata, int columnIndex) {
        return metadata.isColumnIndexed(columnIndex);
    }
}

