/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractPartitionFrameCursorFactory;
import io.questdb.cairo.FullBwdPartitionFrameCursor;
import io.questdb.cairo.FullFwdPartitionFrameCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Misc;

public class FullPartitionFrameCursorFactory
extends AbstractPartitionFrameCursorFactory {
    private final int baseOrder;
    private FullBwdPartitionFrameCursor bwdCursor;
    private FullFwdPartitionFrameCursor fwdCursor;

    public FullPartitionFrameCursorFactory(TableToken tableToken, long metadataVersion, RecordMetadata metadata, int order) {
        super(tableToken, metadataVersion, metadata);
        this.baseOrder = order;
    }

    @Override
    public void close() {
        super.close();
        this.fwdCursor = Misc.free(this.fwdCursor);
        this.bwdCursor = Misc.free(this.bwdCursor);
    }

    @Override
    public PartitionFrameCursor getCursor(SqlExecutionContext executionContext, int order) {
        TableReader reader = this.getReader(executionContext);
        try {
            if (order == 0 || (order == 2 || order < 0) && this.baseOrder != 1) {
                if (this.fwdCursor == null) {
                    this.fwdCursor = new FullFwdPartitionFrameCursor();
                }
                return this.fwdCursor.of(reader);
            }
            if (this.bwdCursor == null) {
                this.bwdCursor = new FullBwdPartitionFrameCursor();
            }
            return this.bwdCursor.of(reader);
        }
        catch (Throwable th) {
            Misc.free(reader);
            throw th;
        }
    }

    @Override
    public int getOrder() {
        return this.baseOrder;
    }

    @Override
    public boolean hasInterval() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        int order = sink.getOrder();
        if (order == 2 || order < 0) {
            order = this.baseOrder;
        }
        if (order == 1) {
            sink.type("Frame backward scan");
        } else {
            sink.type("Frame forward scan");
        }
        super.toPlan(sink);
    }
}

