/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.MessageBus;
import io.questdb.cairo.TableWriter;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.CountDownLatchSPI;
import io.questdb.mp.Job;
import io.questdb.mp.Sequence;
import io.questdb.tasks.ColumnTask;
import org.jetbrains.annotations.NotNull;

public class ColumnTaskJob
extends AbstractQueueConsumerJob<ColumnTask> {
    public ColumnTaskJob(MessageBus messageBus) {
        super(messageBus.getColumnTaskQueue(), messageBus.getColumnTaskSubSeq());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processColumnTask(ColumnTask task, long cursor, @NotNull Sequence subSeq) {
        int columnIndex = task.getColumnIndex();
        int columnType = task.getColumnType();
        long timestampColumnIndex = task.getTimestampColumnIndex();
        long lon0 = task.getLong0();
        long long1 = task.getLong1();
        long long2 = task.getLong2();
        long long3 = task.getLong3();
        long long4 = task.getLong4();
        TableWriter.ColumnTaskHandler taskHandler = task.getTaskHandler();
        CountDownLatchSPI countDownLatchSPI = task.getCountDownLatchSPI();
        subSeq.done(cursor);
        try {
            taskHandler.run(columnIndex, columnType, timestampColumnIndex, lon0, long1, long2, long3, long4);
        }
        finally {
            countDownLatchSPI.countDown();
        }
    }

    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        ColumnTask task = (ColumnTask)this.queue.get(cursor);
        ColumnTaskJob.processColumnTask(task, cursor, this.subSeq);
        return true;
    }
}

