/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.ConfigPropertyKey;
import io.questdb.ConfigPropertyValue;
import io.questdb.ConfigPropertyValueImpl;
import io.questdb.DefaultFactoryProvider;
import io.questdb.FactoryProvider;
import io.questdb.FactoryProviderFactory;
import io.questdb.FreeOnExit;
import io.questdb.MemoryConfiguration;
import io.questdb.MemoryConfigurationImpl;
import io.questdb.Metrics;
import io.questdb.PropHttpContextConfiguration;
import io.questdb.PropertyKey;
import io.questdb.PublicPassthroughConfiguration;
import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.ServerMain;
import io.questdb.TelemetryConfiguration;
import io.questdb.VolumeDefinitions;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.SqlExecutionCircuitBreakerConfiguration;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpFullFatServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.LineHttpProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.line.LineHourTimestampAdapter;
import io.questdb.cutlass.line.LineMicroTimestampAdapter;
import io.questdb.cutlass.line.LineMilliTimestampAdapter;
import io.questdb.cutlass.line.LineMinuteTimestampAdapter;
import io.questdb.cutlass.line.LineNanoTimestampAdapter;
import io.questdb.cutlass.line.LineSecondTimestampAdapter;
import io.questdb.cutlass.line.LineTcpTimestampAdapter;
import io.questdb.cutlass.line.LineTimestampAdapter;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfigurationHelper;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.PGConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.griffin.engine.table.parquet.ParquetCompression;
import io.questdb.griffin.engine.table.parquet.ParquetVersion;
import io.questdb.log.Log;
import io.questdb.metrics.Counter;
import io.questdb.metrics.LongGauge;
import io.questdb.metrics.MetricsConfiguration;
import io.questdb.metrics.MetricsRegistryImpl;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.network.EpollFacade;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.network.KqueueFacade;
import io.questdb.network.KqueueFacadeImpl;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.network.SelectFacade;
import io.questdb.network.SelectFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.ConcurrentCacheConfiguration;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.ObjObjHashMap;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.StationaryMillisClock;
import io.questdb.std.StationaryNanosClock;
import io.questdb.std.Unsafe;
import io.questdb.std.Utf8SequenceObjHashMap;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.TimeZoneRules;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8String;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropServerConfiguration
implements ServerConfiguration {
    public static final String ACL_ENABLED = "acl.enabled";
    public static final int COLUMN_ALIAS_GENERATED_MAX_SIZE_DEFAULT = 64;
    public static final int COLUMN_ALIAS_GENERATED_MAX_SIZE_MINIMUM = 4;
    public static final long COMMIT_INTERVAL_DEFAULT = 2000L;
    public static final String CONFIG_DIRECTORY = "conf";
    public static final String DB_DIRECTORY = "db";
    public static final int MIN_TCP_ILP_BUF_SIZE = 513;
    public static final String TMP_DIRECTORY = "tmp";
    private static final String ILP_PROTO_SUPPORT_VERSIONS = "[1,2]";
    private static final String ILP_PROTO_SUPPORT_VERSIONS_NAME = "line.proto.support.versions";
    private static final String ILP_PROTO_TRANSPORTS = "ilp.proto.transports";
    private static final String RELEASE_TYPE = "release.type";
    private static final String RELEASE_VERSION = "release.version";
    private static final LowerCaseCharSequenceIntHashMap WRITE_FO_OPTS = new LowerCaseCharSequenceIntHashMap();
    protected final byte httpHealthCheckAuthType;
    private final ObjObjHashMap<ConfigPropertyKey, ConfigPropertyValue> allPairs = new ObjObjHashMap();
    private final boolean allowTableRegistrySharedWrite;
    private final DateFormat backupDirTimestampFormat;
    private final int backupMkdirMode;
    private final String backupRoot;
    private final CharSequence backupTempDirName;
    private final int binaryEncodingMaxLength;
    private final BuildInformation buildInformation;
    private final boolean cairoAttachPartitionCopy;
    private final String cairoAttachPartitionSuffix;
    private final long cairoCommitLatency;
    private final CairoConfiguration cairoConfiguration = new PropCairoConfiguration();
    private final int cairoGroupByMergeShardQueueCapacity;
    private final boolean cairoGroupByPresizeEnabled;
    private final long cairoGroupByPresizeMaxCapacity;
    private final long cairoGroupByPresizeMaxHeapSize;
    private final int cairoGroupByShardingThreshold;
    private final int cairoMaxCrashFiles;
    private final int cairoPageFrameReduceColumnListCapacity;
    private final int cairoPageFrameReduceQueueCapacity;
    private final int cairoPageFrameReduceRowIdListCapacity;
    private final int cairoPageFrameReduceShardCount;
    private final int cairoSQLCopyIdSupplier;
    private final boolean cairoSqlColumnAliasExpressionEnabled;
    private final int cairoSqlCopyLogRetentionDays;
    private final int cairoSqlCopyQueueCapacity;
    private final String cairoSqlCopyRoot;
    private final String cairoSqlCopyWorkRoot;
    private final boolean cairoSqlLegacyOperatorPrecedence;
    private final long cairoTableRegistryAutoReloadFrequency;
    private final int cairoTableRegistryCompactionThreshold;
    private final int cairoTxnScoreboardFormat;
    private final long cairoWriteBackOffTimeoutOnMemPressureMs;
    private final boolean checkpointRecoveryEnabled;
    private final String checkpointRoot;
    private final PropSqlExecutionCircuitBreakerConfiguration circuitBreakerConfiguration = new PropSqlExecutionCircuitBreakerConfiguration();
    private final int circuitBreakerThrottle;
    private final int columnIndexerQueueCapacity;
    private final int columnPurgeQueueCapacity;
    private final long columnPurgeRetryDelay;
    private final long columnPurgeRetryDelayLimit;
    private final double columnPurgeRetryDelayMultiplier;
    private final int columnPurgeTaskPoolCapacity;
    private final int commitMode;
    private final TimestampFormatCompiler compiler = new TimestampFormatCompiler();
    private final String confRoot;
    private final boolean configReloadEnabled;
    private final int createAsSelectRetryCount;
    private final int dateAdapterPoolCapacity;
    private final String dbDirectory;
    private final String dbRoot;
    private final boolean debugWalApplyBlockFailureNoRetry;
    private final int defaultSeqPartTxnCount;
    private final boolean defaultSymbolCacheFlag;
    private final int defaultSymbolCapacity;
    private final int detachedMkdirMode;
    private final boolean devModeEnabled;
    private final Set<? extends ConfigPropertyKey> dynamicProperties;
    private final boolean enableTestFactories;
    private final boolean fileDescriptorCacheEnabled;
    private final int fileOperationRetryCount;
    private final FilesFacade filesFacade;
    private final FactoryProviderFactory fpf;
    private final PropHttpContextConfiguration httpContextConfiguration;
    private final ObjList<String> httpContextPathExec = new ObjList();
    private final ObjList<String> httpContextPathExport = new ObjList();
    private final ObjList<String> httpContextPathILP = new ObjList();
    private final ObjList<String> httpContextPathILPPing = new ObjList();
    private final ObjList<String> httpContextPathImport = new ObjList();
    private final ObjList<String> httpContextPathSettings = new ObjList();
    private final ObjList<String> httpContextPathTableStatus = new ObjList();
    private final ObjList<String> httpContextPathWarnings = new ObjList();
    private final String httpContextWebConsole;
    private final boolean httpFrozenClock;
    private final PropHttpConcurrentCacheConfiguration httpMinConcurrentCacheConfiguration = new PropHttpConcurrentCacheConfiguration();
    private final PropHttpContextConfiguration httpMinContextConfiguration;
    private final boolean httpMinServerEnabled;
    private final long httpNetAcceptLoopTimeout;
    private final boolean httpNetConnectionHint;
    private final String httpPassword;
    private final boolean httpPessimisticHealthCheckEnabled;
    private final long httpRecvMaxBufferSize;
    private final int httpSendBufferSize;
    private final boolean httpServerEnabled;
    private final boolean httpSettingsReadOnly;
    private final int httpSqlCacheBlockCount;
    private final boolean httpSqlCacheEnabled;
    private final int httpSqlCacheRowCount;
    private final String httpUsername;
    private final WaitProcessorConfiguration httpWaitProcessorConfiguration = new PropWaitProcessorConfiguration();
    private final int[] httpWorkerAffinity;
    private final int httpWorkerCount;
    private final boolean httpWorkerHaltOnError;
    private final long httpWorkerNapThreshold;
    private final long httpWorkerSleepThreshold;
    private final long httpWorkerSleepTimeout;
    private final long httpWorkerYieldThreshold;
    private final int idGenerateBatchStep;
    private final long idleCheckInterval;
    private final boolean ilpAutoCreateNewColumns;
    private final boolean ilpAutoCreateNewTables;
    private final String ilpProtoTransports;
    private final int inactiveReaderMaxOpenPartitions;
    private final long inactiveReaderTTL;
    private final long inactiveWalWriterTTL;
    private final long inactiveWriterTTL;
    private final int indexValueBlockSize;
    private final InputFormatConfiguration inputFormatConfiguration;
    private final String installRoot;
    private final long instanceHashHi;
    private final long instanceHashLo;
    private final boolean interruptOnClosedConnection;
    private final boolean ioURingEnabled;
    private final boolean isQueryTracingEnabled;
    private final boolean isReadOnlyInstance;
    private final int jsonCacheLimit;
    private final int jsonCacheSize;
    private final String keepAliveHeader;
    private final int latestByQueueCapacity;
    private final String legacyCheckpointRoot;
    private final boolean lineHttpEnabled;
    private final CharSequence lineHttpPingVersion;
    private final LineHttpProcessorConfiguration lineHttpProcessorConfiguration = new PropLineHttpProcessorConfiguration();
    private final String lineTcpAuthDB;
    private final boolean lineTcpEnabled;
    private final WorkerPoolConfiguration lineTcpIOWorkerPoolConfiguration = new PropLineTcpIOWorkerPoolConfiguration();
    private final LineTcpReceiverConfiguration lineTcpReceiverConfiguration = new PropLineTcpReceiverConfiguration();
    private final WorkerPoolConfiguration lineTcpWriterWorkerPoolConfiguration = new PropLineTcpWriterWorkerPoolConfiguration();
    private final int lineUdpCommitMode;
    private final int lineUdpCommitRate;
    private final boolean lineUdpEnabled;
    private final int lineUdpGroupIPv4Address;
    private final int lineUdpMsgBufferSize;
    private final int lineUdpMsgCount;
    private final boolean lineUdpOwnThread;
    private final int lineUdpOwnThreadAffinity;
    private final int lineUdpReceiveBufferSize;
    private final LineUdpReceiverConfiguration lineUdpReceiverConfiguration = new PropLineUdpReceiverConfiguration();
    private final LineTimestampAdapter lineUdpTimestampAdapter;
    private final boolean lineUdpUnicast;
    private final DateLocale locale;
    private final Log log;
    private final boolean logLevelVerbose;
    private final boolean logSqlQueryProgressExe;
    private final DateFormat logTimestampFormat;
    private final DateLocale logTimestampLocale;
    private final String logTimestampTimezone;
    private final TimeZoneRules logTimestampTimezoneRules;
    private final boolean matViewEnabled;
    private final long matViewInsertAsSelectBatchSize;
    private final int matViewMaxRefreshIntervals;
    private final int matViewMaxRefreshRetries;
    private final boolean matViewParallelExecutionEnabled;
    private final long matViewRefreshIntervalsUpdatePeriod;
    private final long matViewRefreshOomRetryTimeout;
    private final WorkerPoolConfiguration matViewRefreshPoolConfiguration = new PropMatViewRefreshPoolConfiguration();
    private final long matViewRefreshSleepTimeout;
    private final int[] matViewRefreshWorkerAffinity;
    private final int matViewRefreshWorkerCount;
    private final boolean matViewRefreshWorkerHaltOnError;
    private final long matViewRefreshWorkerNapThreshold;
    private final long matViewRefreshWorkerSleepThreshold;
    private final long matViewRefreshWorkerYieldThreshold;
    private final int matViewRowsPerQueryEstimate;
    private final int maxFileNameLength;
    private final long maxHttpQueryResponseRowLimit;
    private final double maxRequiredDelimiterStdDev;
    private final double maxRequiredLineLengthStdDev;
    private final long maxRerunWaitCapMs;
    private final int maxSqlRecompileAttempts;
    private final int maxSwapFileCount;
    private final int maxUncommittedRows;
    private final MemoryConfiguration memoryConfiguration;
    private final int metadataStringPoolCapacity;
    private final Metrics metrics;
    private final MetricsConfiguration metricsConfiguration = new PropMetricsConfiguration();
    private final boolean metricsEnabled;
    private final MicrosecondClock microsecondClock;
    private final int mkdirMode;
    private final PropWorkerPoolConfiguration networkSharedWorkerPoolConfiguration = new PropWorkerPoolConfiguration("shared-network");
    private final int o3CallbackQueueCapacity;
    private final int o3ColumnMemorySize;
    private final int o3CopyQueueCapacity;
    private final int o3LagCalculationWindowsSize;
    private final int o3LastPartitionMaxSplits;
    private final long o3MaxLagUs;
    private final long o3MinLagUs;
    private final int o3OpenColumnQueueCapacity;
    private final boolean o3PartitionOverwriteControlEnabled;
    private final int o3PartitionPurgeListCapacity;
    private final int o3PartitionQueueCapacity;
    private final long o3PartitionSplitMinSize;
    private final int o3PurgeDiscoveryQueueCapacity;
    private final boolean o3QuickSortEnabled;
    private final int parallelIndexThreshold;
    private final boolean parallelIndexingEnabled;
    private final int partitionEncoderParquetCompressionCodec;
    private final int partitionEncoderParquetCompressionLevel;
    private final int partitionEncoderParquetDataPageSize;
    private final boolean partitionEncoderParquetRawArrayEncoding;
    private final int partitionEncoderParquetRowGroupSize;
    private final boolean partitionEncoderParquetStatisticsEnabled;
    private final int partitionEncoderParquetVersion;
    private final boolean pgEnabled;
    private final PropPGWireConcurrentCacheConfiguration pgWireConcurrentCacheConfiguration = new PropPGWireConcurrentCacheConfiguration();
    private final PGConfiguration pgConfiguration = new PropPGConfiguration();
    private final String posthogApiKey;
    private final boolean posthogEnabled;
    private final int preferencesStringPoolCapacity;
    private final String publicDirectory;
    private final PublicPassthroughConfiguration publicPassthroughConfiguration = new PropPublicPassthroughConfiguration();
    private final int queryCacheEventQueueCapacity;
    private final PropWorkerPoolConfiguration querySharedWorkerPoolConfiguration = new PropWorkerPoolConfiguration("shared-query");
    private final boolean queryWithinLatestByOptimisationEnabled;
    private final int readerPoolMaxSegments;
    private final Utf8SequenceObjHashMap<Utf8Sequence> redirectMap;
    private final int repeatMigrationFromVersion;
    private final double rerunExponentialWaitMultiplier;
    private final int rerunInitialWaitQueueSize;
    private final int rerunMaxProcessingQueueSize;
    private final int rndFunctionMemoryMaxPages;
    private final int rndFunctionMemoryPageSize;
    private final int rollBufferLimit;
    private final int rollBufferSize;
    private final long sequencerCheckInterval;
    private final String snapshotInstanceId;
    private final long spinLockTimeout;
    private final int sqlAsOfJoinEvacuationThreshold;
    private final int sqlAsOfJoinLookahead;
    private final int sqlAsOfJoinShortCircuitCacheCapacity;
    private final int sqlBindVariablePoolSize;
    private final int sqlCharacterStoreCapacity;
    private final int sqlCharacterStoreSequencePoolCapacity;
    private final int sqlColumnPoolCapacity;
    private final int sqlCompilerPoolCapacity;
    private final int sqlCopyBufferSize;
    private final int sqlCopyModelPoolCapacity;
    private final int sqlCountDistinctCapacity;
    private final double sqlCountDistinctLoadFactor;
    private final int sqlCreateTableColumnModelPoolCapacity;
    private final long sqlCreateTableModelBatchSize;
    private final int sqlDistinctTimestampKeyCapacity;
    private final double sqlDistinctTimestampLoadFactor;
    private final int sqlExplainModelPoolCapacity;
    private final int sqlExpressionPoolCapacity;
    private final double sqlFastMapLoadFactor;
    private final long sqlGroupByAllocatorChunkSize;
    private final long sqlGroupByAllocatorMaxChunkSize;
    private final int sqlGroupByMapCapacity;
    private final int sqlGroupByPoolCapacity;
    private final int sqlHashJoinLightValueMaxPages;
    private final int sqlHashJoinLightValuePageSize;
    private final int sqlHashJoinValueMaxPages;
    private final int sqlHashJoinValuePageSize;
    private final long sqlInsertModelBatchSize;
    private final int sqlInsertModelPoolCapacity;
    private final int sqlJitBindVarsMemoryMaxPages;
    private final int sqlJitBindVarsMemoryPageSize;
    private final boolean sqlJitDebugEnabled;
    private final int sqlJitIRMemoryMaxPages;
    private final int sqlJitIRMemoryPageSize;
    private final int sqlJitMode;
    private final int sqlJitPageAddressCacheThreshold;
    private final int sqlJoinContextPoolCapacity;
    private final int sqlJoinMetadataMaxResizes;
    private final int sqlJoinMetadataPageSize;
    private final long sqlLatestByRowCount;
    private final int sqlLexerPoolCapacity;
    private final int sqlMapMaxPages;
    private final int sqlMapMaxResizes;
    private final int sqlMaxArrayElementCount;
    private final int sqlMaxNegativeLimit;
    private final int sqlMaxSymbolNotEqualsCount;
    private final int sqlModelPoolCapacity;
    private final int sqlOrderByRadixSortThreshold;
    private final boolean sqlOrderBySortEnabled;
    private final int sqlPageFrameMaxRows;
    private final int sqlPageFrameMinRows;
    private final boolean sqlParallelFilterEnabled;
    private final boolean sqlParallelFilterPreTouchEnabled;
    private final double sqlParallelFilterPreTouchThreshold;
    private final boolean sqlParallelGroupByEnabled;
    private final boolean sqlParallelReadParquetEnabled;
    private final boolean sqlParallelTopKEnabled;
    private final int sqlParallelWorkStealingThreshold;
    private final int sqlParquetFrameCacheCapacity;
    private final int sqlQueryRegistryPoolSize;
    private final int sqlRenameTableModelPoolCapacity;
    private final boolean sqlSampleByDefaultAlignment;
    private final int sqlSampleByIndexSearchPageSize;
    private final boolean sqlSampleByValidateFillType;
    private final int sqlSmallMapKeyCapacity;
    private final long sqlSmallMapPageSize;
    private final int sqlSortKeyMaxPages;
    private final long sqlSortKeyPageSize;
    private final int sqlSortLightValueMaxPages;
    private final long sqlSortLightValuePageSize;
    private final int sqlSortValueMaxPages;
    private final int sqlSortValuePageSize;
    private final int sqlStrFunctionBufferMaxSize;
    private final int sqlTxnScoreboardEntryCount;
    private final int sqlUnorderedMapMaxEntrySize;
    private final int sqlWindowColumnPoolCapacity;
    private final int sqlWindowInitialRangeBufferSize;
    private final int sqlWindowMaxRecursion;
    private final int sqlWindowRowIdMaxPages;
    private final int sqlWindowRowIdPageSize;
    private final int sqlWindowStoreMaxPages;
    private final int sqlWindowStorePageSize;
    private final int sqlWindowTreeKeyMaxPages;
    private final int sqlWindowTreeKeyPageSize;
    private final int sqlWithClauseModelPoolCapacity;
    private final long symbolTableAppendPageSize;
    private final int systemO3ColumnMemorySize;
    private final String systemTableNamePrefix;
    private final long systemWalWriterDataAppendPageSize;
    private final long systemWalWriterEventAppendPageSize;
    private final long systemWriterDataAppendPageSize;
    private final boolean tableTypeConversionEnabled;
    private final TelemetryConfiguration telemetryConfiguration = new PropTelemetryConfiguration();
    private final long telemetryDbSizeEstimateTimeout;
    private final boolean telemetryDisableCompletely;
    private final boolean telemetryEnabled;
    private final boolean telemetryHideTables;
    private final int telemetryQueueCapacity;
    private final CharSequence tempRenamePendingTablePrefix;
    private final int textAnalysisMaxLines;
    private final TextConfiguration textConfiguration = new PropTextConfiguration();
    private final int textLexerStringPoolCapacity;
    private final int timestampAdapterPoolCapacity;
    private final boolean useFastAsOfJoin;
    private final boolean useLegacyStringDefault;
    private final int utf8SinkSize;
    private final PropertyValidator validator;
    private final int vectorAggregateQueueCapacity;
    private final VolumeDefinitions volumeDefinitions = new VolumeDefinitions();
    private final boolean walApplyEnabled;
    private final int walApplyLookAheadTransactionCount;
    private final WorkerPoolConfiguration walApplyPoolConfiguration = new PropWalApplyPoolConfiguration();
    private final long walApplySleepTimeout;
    private final long walApplyTableTimeQuota;
    private final int[] walApplyWorkerAffinity;
    private final int walApplyWorkerCount;
    private final boolean walApplyWorkerHaltOnError;
    private final long walApplyWorkerNapThreshold;
    private final long walApplyWorkerSleepThreshold;
    private final long walApplyWorkerYieldThreshold;
    private final boolean walEnabledDefault;
    private final long walMaxLagSize;
    private final int walMaxLagTxnCount;
    private final int walMaxSegmentFileDescriptorsCache;
    private final boolean walParallelExecutionEnabled;
    private final long walPurgeInterval;
    private final int walPurgeWaitBeforeDelete;
    private final int walRecreateDistressedSequencerAttempts;
    private final long walSegmentRolloverRowCount;
    private final double walSquashUncommittedRowsMultiplier;
    private final boolean walSupported;
    private final int walTxnNotificationQueueCapacity;
    private final long walWriterDataAppendPageSize;
    private final long walWriterEventAppendPageSize;
    private final int walWriterPoolMaxSegments;
    private final long workStealTimeoutNanos;
    private final PropWorkerPoolConfiguration writeSharedWorkerPoolConfiguration = new PropWorkerPoolConfiguration("shared-write");
    private final long writerAsyncCommandBusyWaitTimeout;
    private final long writerAsyncCommandMaxWaitTimeout;
    private final int writerAsyncCommandQueueCapacity;
    private final long writerAsyncCommandQueueSlotSize;
    private final long writerDataAppendPageSize;
    private final long writerDataIndexKeyAppendPageSize;
    private final long writerDataIndexValueAppendPageSize;
    private final int writerFileOpenOpts;
    private final long writerMiscAppendPageSize;
    private final boolean writerMixedIOEnabled;
    private final int writerTickRowsCountMod;
    protected HttpServerConfiguration httpMinServerConfiguration = new PropHttpMinServerConfiguration();
    protected HttpFullFatServerConfiguration httpServerConfiguration = new PropHttpServerConfiguration();
    protected JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new PropJsonQueryProcessorConfiguration();
    protected StaticContentProcessorConfiguration staticContentProcessorConfiguration;
    protected long walSegmentRolloverSize;
    private int cairoSqlColumnAliasGeneratedMaxSize;
    private long cairoSqlCopyMaxIndexChunkSize;
    private FactoryProvider factoryProvider;
    private short floatDefaultColumnType;
    private int httpMinBindIPv4Address;
    private int httpMinBindPort;
    private long httpMinNetAcceptLoopTimeout;
    private boolean httpMinNetConnectionHint;
    private int httpMinNetConnectionLimit;
    private long httpMinNetConnectionQueueTimeout;
    private int httpMinNetConnectionRcvBuf;
    private int httpMinNetConnectionSndBuf;
    private long httpMinNetConnectionTimeout;
    private int httpMinRecvBufferSize;
    private int httpMinSendBufferSize;
    private int[] httpMinWorkerAffinity;
    private int httpMinWorkerCount;
    private boolean httpMinWorkerHaltOnError;
    private long httpMinWorkerNapThreshold;
    private int httpMinWorkerPoolPriority;
    private long httpMinWorkerSleepThreshold;
    private long httpMinWorkerSleepTimeout;
    private long httpMinWorkerYieldThreshold;
    private int httpNetBindIPv4Address;
    private int httpNetBindPort;
    private int httpNetConnectionLimit;
    private long httpNetConnectionQueueTimeout;
    private int httpNetConnectionRcvBuf;
    private int httpNetConnectionSndBuf;
    private long httpNetConnectionTimeout;
    private int httpRecvBufferSize;
    private short integerDefaultColumnType;
    private int jsonQueryConnectionCheckFrequency;
    private boolean lineLogMessageOnError;
    private long lineTcpCommitIntervalDefault;
    private double lineTcpCommitIntervalFraction;
    private int lineTcpConnectionPoolInitialCapacity;
    private int lineTcpDefaultPartitionBy;
    private boolean lineTcpDisconnectOnError;
    private int[] lineTcpIOWorkerAffinity;
    private int lineTcpIOWorkerCount;
    private long lineTcpIOWorkerNapThreshold;
    private boolean lineTcpIOWorkerPoolHaltOnError;
    private long lineTcpIOWorkerSleepThreshold;
    private long lineTcpIOWorkerYieldThreshold;
    private long lineTcpMaintenanceInterval;
    private int lineTcpMaxMeasurementSize;
    private long lineTcpMaxRecvBufferSize;
    private long lineTcpNetAcceptLoopTimeout;
    private int lineTcpNetBindIPv4Address;
    private int lineTcpNetBindPort;
    private long lineTcpNetConnectionHeartbeatInterval;
    private boolean lineTcpNetConnectionHint;
    private int lineTcpNetConnectionLimit;
    private long lineTcpNetConnectionQueueTimeout;
    private int lineTcpNetConnectionRcvBuf;
    private long lineTcpNetConnectionTimeout;
    private int lineTcpRecvBufferSize;
    private LineTcpTimestampAdapter lineTcpTimestampAdapter;
    private int lineTcpWriterQueueCapacity;
    private int[] lineTcpWriterWorkerAffinity;
    private int lineTcpWriterWorkerCount;
    private long lineTcpWriterWorkerNapThreshold;
    private boolean lineTcpWriterWorkerPoolHaltOnError;
    private long lineTcpWriterWorkerSleepThreshold;
    private long lineTcpWriterWorkerYieldThreshold;
    private int lineUdpBindIPV4Address;
    private int lineUdpDefaultPartitionBy;
    private int lineUdpPort;
    private MimeTypesCache mimeTypesCache;
    private long minIdleMsBeforeWriterRelease;
    private int netTestConnectionBufferSize;
    private int pgBinaryParamsCapacity;
    private int pgCharacterStoreCapacity;
    private int pgCharacterStorePoolCapacity;
    private int pgConnectionPoolInitialCapacity;
    private boolean pgDaemonPool;
    private DateLocale pgDefaultLocale;
    private int pgForceRecvFragmentationChunkSize;
    private int pgForceSendFragmentationChunkSize;
    private boolean pgHaltOnError;
    private int pgInsertCacheBlockCount;
    private boolean pgInsertCacheEnabled;
    private int pgInsertCacheRowCount;
    private int pgMaxBlobSizeOnQuery;
    private int pgNamedStatementCacheCapacity;
    private int pgNamedStatementLimit;
    private int pgNamesStatementPoolCapacity;
    private long pgNetAcceptLoopTimeout;
    private int pgNetBindIPv4Address;
    private int pgNetBindPort;
    private boolean pgNetConnectionHint;
    private int pgNetConnectionLimit;
    private long pgNetConnectionQueueTimeout;
    private int pgNetConnectionRcvBuf;
    private int pgNetConnectionSndBuf;
    private long pgNetIdleConnectionTimeout;
    private String pgPassword;
    private int pgPendingWritersCacheCapacity;
    private int pgPipelineCapacity;
    private String pgReadOnlyPassword;
    private boolean pgReadOnlySecurityContext;
    private boolean pgReadOnlyUserEnabled;
    private String pgReadOnlyUsername;
    private int pgRecvBufferSize;
    private int pgSelectCacheBlockCount;
    private boolean pgSelectCacheEnabled;
    private int pgSelectCacheRowCount;
    private int pgSendBufferSize;
    private int pgUpdateCacheBlockCount;
    private boolean pgUpdateCacheEnabled;
    private int pgUpdateCacheRowCount;
    private String pgUsername;
    private int[] pgWorkerAffinity;
    private int pgWorkerCount;
    private long pgWorkerNapThreshold;
    private long pgWorkerSleepThreshold;
    private long pgWorkerYieldThreshold;
    private long queryTimeout;
    private boolean stringToCharCastAllowed;
    private long symbolCacheWaitBeforeReload;

    public PropServerConfiguration(String installRoot, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this(installRoot, properties, null, env, log, buildInformation, FilesFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, (configuration, engine, freeOnExitList) -> DefaultFactoryProvider.INSTANCE, true);
    }

    public PropServerConfiguration(String installRoot, Properties properties, @Nullable Set<? extends ConfigPropertyKey> dynamicProperties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation, FilesFacade filesFacade, MicrosecondClock microsecondClock, FactoryProviderFactory fpf) throws ServerConfigurationException, JsonException {
        this(installRoot, properties, dynamicProperties, env, log, buildInformation, filesFacade, microsecondClock, fpf, true);
    }

    public PropServerConfiguration(String installRoot, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation, FilesFacade filesFacade, MicrosecondClock microsecondClock, FactoryProviderFactory fpf) throws ServerConfigurationException, JsonException {
        this(installRoot, properties, null, env, log, buildInformation, filesFacade, microsecondClock, fpf, true);
    }

    public PropServerConfiguration(String installRoot, Properties properties, @Nullable Set<? extends ConfigPropertyKey> dynamicProperties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation, FilesFacade filesFacade, MicrosecondClock microsecondClock, FactoryProviderFactory fpf, boolean loadAdditionalConfigurations) throws ServerConfigurationException, JsonException {
        String tmpRoot;
        this.log = log;
        this.metricsEnabled = this.getBoolean(properties, env, PropertyKey.METRICS_ENABLED, false);
        this.metrics = this.metricsEnabled ? new Metrics(true, new MetricsRegistryImpl()) : Metrics.DISABLED;
        this.logSqlQueryProgressExe = this.getBoolean(properties, env, PropertyKey.LOG_SQL_QUERY_PROGRESS_EXE, true);
        this.logLevelVerbose = this.getBoolean(properties, env, PropertyKey.LOG_LEVEL_VERBOSE, false);
        this.logTimestampTimezone = this.getString(properties, env, PropertyKey.LOG_TIMESTAMP_TIMEZONE, "Z");
        String logTimestampFormatStr = this.getString(properties, env, PropertyKey.LOG_TIMESTAMP_FORMAT, "yyyy-MM-ddTHH:mm:ss.SSSUUUz");
        String logTimestampLocaleStr = this.getString(properties, env, PropertyKey.LOG_TIMESTAMP_LOCALE, "en");
        this.logTimestampLocale = DateLocaleFactory.INSTANCE.getLocale(logTimestampLocaleStr);
        if (this.logTimestampLocale == null) {
            throw new ServerConfigurationException("Invalid log locale: '" + logTimestampLocaleStr + "'");
        }
        TimestampFormatCompiler formatCompiler = new TimestampFormatCompiler();
        this.logTimestampFormat = formatCompiler.compile(logTimestampFormatStr);
        try {
            this.logTimestampTimezoneRules = Timestamps.getTimezoneRules(this.logTimestampLocale, this.logTimestampTimezone);
        }
        catch (NumericException e) {
            throw new ServerConfigurationException("Invalid log timezone: '" + this.logTimestampTimezone + "'");
        }
        this.filesFacade = filesFacade;
        this.fpf = fpf;
        this.microsecondClock = microsecondClock;
        this.validator = this.newValidator();
        this.staticContentProcessorConfiguration = new PropStaticContentProcessorConfiguration();
        this.dynamicProperties = dynamicProperties;
        boolean configValidationStrict = this.getBoolean(properties, env, PropertyKey.CONFIG_VALIDATION_STRICT, false);
        this.validateProperties(properties, configValidationStrict);
        this.memoryConfiguration = new MemoryConfigurationImpl(this.getLongSize(properties, env, PropertyKey.RAM_USAGE_LIMIT_BYTES, 0L), this.getIntPercentage(properties, env, PropertyKey.RAM_USAGE_LIMIT_PERCENT, 90));
        this.isReadOnlyInstance = this.getBoolean(properties, env, PropertyKey.READ_ONLY_INSTANCE, false);
        this.isQueryTracingEnabled = this.getBoolean(properties, env, PropertyKey.QUERY_TRACING_ENABLED, false);
        this.cairoTableRegistryAutoReloadFrequency = this.getMillis(properties, env, PropertyKey.CAIRO_TABLE_REGISTRY_AUTO_RELOAD_FREQUENCY, 500L);
        this.cairoTableRegistryCompactionThreshold = this.getInt(properties, env, PropertyKey.CAIRO_TABLE_REGISTRY_COMPACTION_THRESHOLD, 30);
        this.cairoTxnScoreboardFormat = this.getInt(properties, env, PropertyKey.CAIRO_TXN_SCOREBOARD_FORMAT, 2);
        this.cairoWriteBackOffTimeoutOnMemPressureMs = this.getMillis(properties, env, PropertyKey.CAIRO_WRITE_BACK_OFF_TIMEOUT_ON_MEM_PRESSURE, 4000L);
        this.repeatMigrationFromVersion = this.getInt(properties, env, PropertyKey.CAIRO_REPEAT_MIGRATION_FROM_VERSION, 426);
        this.mkdirMode = this.getInt(properties, env, PropertyKey.CAIRO_MKDIR_MODE, 509);
        this.maxFileNameLength = this.getInt(properties, env, PropertyKey.CAIRO_MAX_FILE_NAME_LENGTH, 127);
        this.walEnabledDefault = this.getBoolean(properties, env, PropertyKey.CAIRO_WAL_ENABLED_DEFAULT, true);
        this.walPurgeInterval = this.getMillis(properties, env, PropertyKey.CAIRO_WAL_PURGE_INTERVAL, 30000L);
        this.matViewRefreshIntervalsUpdatePeriod = this.getMillis(properties, env, PropertyKey.CAIRO_MAT_VIEW_REFRESH_INTERVALS_UPDATE_PERIOD, this.walPurgeInterval / 2L);
        this.walPurgeWaitBeforeDelete = this.getInt(properties, env, PropertyKey.DEBUG_WAL_PURGE_WAIT_BEFORE_DELETE, 0);
        this.walTxnNotificationQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_WAL_TXN_NOTIFICATION_QUEUE_CAPACITY, 4096);
        this.walRecreateDistressedSequencerAttempts = this.getInt(properties, env, PropertyKey.CAIRO_WAL_RECREATE_DISTRESSED_SEQUENCER_ATTEMPTS, 3);
        this.walSupported = this.getBoolean(properties, env, PropertyKey.CAIRO_WAL_SUPPORTED, true);
        this.walApplyEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_WAL_APPLY_ENABLED, true);
        this.walSegmentRolloverRowCount = this.getLong(properties, env, PropertyKey.CAIRO_WAL_SEGMENT_ROLLOVER_ROW_COUNT, 200000L);
        this.walSegmentRolloverSize = this.getLongSize(properties, env, PropertyKey.CAIRO_WAL_SEGMENT_ROLLOVER_SIZE, 0x3200000L);
        if (this.walSegmentRolloverSize != 0L && this.walSegmentRolloverSize < 1024L) {
            throw CairoException.critical(0).put("cairo.wal.segment.rollover.size must be 0 (disabled) or >= 1024 (1KiB)");
        }
        this.walWriterDataAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WAL_WRITER_DATA_APPEND_PAGE_SIZE, 0x100000L));
        this.walWriterEventAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WAL_WRITER_EVENT_APPEND_PAGE_SIZE, 131072L));
        this.systemWalWriterDataAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_SYSTEM_WAL_WRITER_DATA_APPEND_PAGE_SIZE, 262144L));
        this.systemWalWriterEventAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_SYSTEM_WAL_WRITER_EVENT_APPEND_PAGE_SIZE, 16384L));
        this.walSquashUncommittedRowsMultiplier = this.getDouble(properties, env, PropertyKey.CAIRO_WAL_SQUASH_UNCOMMITTED_ROWS_MULTIPLIER, "20.0");
        this.walMaxLagTxnCount = this.getInt(properties, env, PropertyKey.CAIRO_WAL_MAX_LAG_TXN_COUNT, -1);
        this.debugWalApplyBlockFailureNoRetry = this.getBoolean(properties, env, PropertyKey.DEBUG_WAL_APPLY_BLOCK_FAILURE_NO_RETRY, false);
        this.walMaxLagSize = this.getLongSize(properties, env, PropertyKey.CAIRO_WAL_MAX_LAG_SIZE, 0x4B00000L);
        this.walMaxSegmentFileDescriptorsCache = this.getInt(properties, env, PropertyKey.CAIRO_WAL_MAX_SEGMENT_FILE_DESCRIPTORS_CACHE, 30);
        this.walApplyTableTimeQuota = this.getMillis(properties, env, PropertyKey.CAIRO_WAL_APPLY_TABLE_TIME_QUOTA, 1000L);
        this.walApplyLookAheadTransactionCount = this.getInt(properties, env, PropertyKey.CAIRO_WAL_APPLY_LOOK_AHEAD_TXN_COUNT, 200);
        this.tableTypeConversionEnabled = this.getBoolean(properties, env, PropertyKey.TABLE_TYPE_CONVERSION_ENABLED, true);
        this.tempRenamePendingTablePrefix = this.getString(properties, env, PropertyKey.CAIRO_WAL_TEMP_PENDING_RENAME_TABLE_PREFIX, "temp_5822f658-31f6-11ee-be56-0242ac120002");
        this.sequencerCheckInterval = this.getMillis(properties, env, PropertyKey.CAIRO_WAL_SEQUENCER_CHECK_INTERVAL, 10000L);
        if (this.tempRenamePendingTablePrefix.length() > this.maxFileNameLength - 4) {
            throw CairoException.critical(0).put("Temp pending table prefix is too long [").put(PropertyKey.CAIRO_MAX_FILE_NAME_LENGTH.toString()).put("=").put(this.maxFileNameLength).put(", ").put(PropertyKey.CAIRO_WAL_TEMP_PENDING_RENAME_TABLE_PREFIX.toString()).put("=").put(this.tempRenamePendingTablePrefix).put(']');
        }
        if (!TableUtils.isValidTableName(this.tempRenamePendingTablePrefix, this.maxFileNameLength)) {
            throw CairoException.critical(0).put("Invalid temp pending table prefix [").put(PropertyKey.CAIRO_WAL_TEMP_PENDING_RENAME_TABLE_PREFIX.toString()).put("=").put(this.tempRenamePendingTablePrefix).put(']');
        }
        this.installRoot = installRoot;
        this.dbDirectory = this.getString(properties, env, PropertyKey.CAIRO_ROOT, DB_DIRECTORY);
        boolean absDbDir = new File(this.dbDirectory).isAbsolute();
        if (absDbDir) {
            this.dbRoot = this.dbDirectory;
            this.confRoot = PropServerConfiguration.rootSubdir(this.dbRoot, CONFIG_DIRECTORY);
            this.checkpointRoot = PropServerConfiguration.rootSubdir(this.dbRoot, ".checkpoint");
            this.legacyCheckpointRoot = PropServerConfiguration.rootSubdir(this.dbRoot, "snapshot");
            tmpRoot = PropServerConfiguration.rootSubdir(this.dbRoot, TMP_DIRECTORY);
        } else {
            this.dbRoot = new File(installRoot, this.dbDirectory).getAbsolutePath();
            this.confRoot = new File(installRoot, CONFIG_DIRECTORY).getAbsolutePath();
            this.checkpointRoot = new File(installRoot, ".checkpoint").getAbsolutePath();
            this.legacyCheckpointRoot = new File(installRoot, "snapshot").getAbsolutePath();
            tmpRoot = new File(installRoot, TMP_DIRECTORY).getAbsolutePath();
        }
        String configuredCairoSqlCopyRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_ROOT, "import");
        if (!Chars.empty(configuredCairoSqlCopyRoot)) {
            this.cairoSqlCopyRoot = new File(configuredCairoSqlCopyRoot).isAbsolute() ? configuredCairoSqlCopyRoot : (absDbDir ? PropServerConfiguration.rootSubdir(this.dbRoot, configuredCairoSqlCopyRoot) : new File(installRoot, configuredCairoSqlCopyRoot).getAbsolutePath());
            String cairoSqlCopyWorkRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_WORK_ROOT, tmpRoot);
            this.cairoSqlCopyWorkRoot = this.getCanonicalPath(cairoSqlCopyWorkRoot);
            if (this.pathEquals(installRoot, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.dbRoot, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.confRoot, this.cairoSqlCopyWorkRoot) || this.pathEquals(this.checkpointRoot, this.cairoSqlCopyWorkRoot)) {
                throw new ServerConfigurationException("Configuration value for " + PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath() + " can't point to root, data, conf or snapshot dirs. ");
            }
        } else {
            this.cairoSqlCopyRoot = null;
            this.cairoSqlCopyWorkRoot = null;
        }
        this.cairoAttachPartitionSuffix = this.getString(properties, env, PropertyKey.CAIRO_ATTACH_PARTITION_SUFFIX, ".attachable");
        this.cairoAttachPartitionCopy = this.getBoolean(properties, env, PropertyKey.CAIRO_ATTACH_PARTITION_COPY, false);
        this.cairoCommitLatency = this.getMicros(properties, env, PropertyKey.CAIRO_COMMIT_LATENCY, 30000000L);
        this.snapshotInstanceId = this.getString(properties, env, PropertyKey.CAIRO_LEGACY_SNAPSHOT_INSTANCE_ID, "");
        this.checkpointRecoveryEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_LEGACY_SNAPSHOT_RECOVERY_ENABLED, this.getBoolean(properties, env, PropertyKey.CAIRO_CHECKPOINT_RECOVERY_ENABLED, true));
        this.devModeEnabled = this.getBoolean(properties, env, PropertyKey.DEV_MODE_ENABLED, false);
        int cpuAvailable = Runtime.getRuntime().availableProcessors();
        int cpuSpare = 0;
        if (cpuAvailable > 16) {
            cpuSpare = 1;
        } else if (cpuAvailable > 32) {
            cpuSpare = 2;
        }
        FilesFacade ff = this.cairoConfiguration.getFilesFacade();
        try (Path path = new Path();){
            String[] opts;
            Rnd rnd;
            this.volumeDefinitions.of(this.getString(properties, env, PropertyKey.CAIRO_VOLUMES, null), path, installRoot);
            ff.mkdirs(path.of(this.dbRoot).slash(), this.mkdirMode);
            path.of(this.dbRoot).concat("_tab_index.d");
            long tableIndexFd = TableUtils.openFileRWOrFail(ff, path.$(), 0);
            long fileSize = ff.length(tableIndexFd);
            if (fileSize < 8L && !ff.allocate(tableIndexFd, Files.PAGE_SIZE)) {
                ff.close(tableIndexFd);
                throw CairoException.critical(ff.errno()).put("Could not allocate [file=").put(path).put(", actual=").put(fileSize).put(", desired=").put(Files.PAGE_SIZE).put(']');
            }
            long tableIndexMem = TableUtils.mapRWOrClose(ff, tableIndexFd, Files.PAGE_SIZE, 0);
            if (Os.compareAndSwap(tableIndexMem + 8L, 0L, (rnd = new Rnd(this.cairoConfiguration.getMicrosecondClock().getTicks(), this.cairoConfiguration.getMillisecondClock().getTicks())).nextLong()) == 0L) {
                Unsafe.getUnsafe().putLong(tableIndexMem + 16L, rnd.nextLong());
            }
            this.instanceHashLo = Unsafe.getUnsafe().getLong(tableIndexMem + 8L);
            this.instanceHashHi = Unsafe.getUnsafe().getLong(tableIndexMem + 16L);
            ff.munmap(tableIndexMem, Files.PAGE_SIZE, 0);
            ff.close(tableIndexFd);
            this.httpMinServerEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_ENABLED, true);
            if (this.httpMinServerEnabled) {
                this.httpMinWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_WORKER_HALT_ON_ERROR, false);
                this.httpMinWorkerCount = this.getInt(properties, env, PropertyKey.HTTP_MIN_WORKER_COUNT, 1);
                int httpMinWorkerPoolPriority = this.getInt(properties, env, PropertyKey.HTTP_MIN_WORKER_POOL_PRIORITY, 8);
                this.httpMinWorkerPoolPriority = Math.min(10, Math.max(1, httpMinWorkerPoolPriority));
                this.httpMinWorkerAffinity = this.getAffinity(properties, env, PropertyKey.HTTP_MIN_WORKER_AFFINITY, this.httpMinWorkerCount);
                this.httpMinWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.HTTP_MIN_WORKER_YIELD_THRESHOLD, 10L);
                this.httpMinWorkerNapThreshold = this.getLong(properties, env, PropertyKey.HTTP_MIN_WORKER_NAP_THRESHOLD, 100L);
                this.httpMinWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.HTTP_MIN_WORKER_SLEEP_THRESHOLD, 100L);
                this.httpMinWorkerSleepTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_WORKER_SLEEP_TIMEOUT, 50L);
                String httpMinBindTo = this.getString(properties, env, PropertyKey.HTTP_MIN_BIND_TO, "0.0.0.0:9003");
                this.parseBindTo(properties, env, PropertyKey.HTTP_MIN_NET_BIND_TO, httpMinBindTo, (a, p) -> {
                    this.httpMinBindIPv4Address = a;
                    this.httpMinBindPort = p;
                });
                this.httpMinNetAcceptLoopTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_NET_ACCEPT_LOOP_TIMEOUT, 500L);
                this.httpMinNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_LIMIT, 64);
                this.httpMinNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_NET_IDLE_CONNECTION_TIMEOUT, 300000L);
                this.httpMinNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_TIMEOUT, this.httpMinNetConnectionTimeout);
                this.httpMinNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_NET_QUEUED_CONNECTION_TIMEOUT, 5000L);
                this.httpMinNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_QUEUE_TIMEOUT, this.httpMinNetConnectionQueueTimeout);
                this.httpMinNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_SND_BUF_SIZE, -1);
                this.httpMinNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_SNDBUF, this.httpMinNetConnectionSndBuf);
                this.httpMinSendBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_SEND_BUFFER_SIZE, 1024);
                this.httpMinNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_RCV_BUF_SIZE, -1);
                this.httpMinNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_RCVBUF, this.httpMinNetConnectionRcvBuf);
                this.httpMinRecvBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_RECEIVE_BUFFER_SIZE, 1024);
                this.httpMinRecvBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_RECV_BUFFER_SIZE, this.httpMinRecvBufferSize);
                this.httpMinNetConnectionHint = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_NET_CONNECTION_HINT, false);
            }
            int requestHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_REQUEST_HEADER_BUFFER_SIZE, 64448);
            this.httpServerEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_ENABLED, true);
            int forceSendFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_FORCE_SEND_FRAGMENTATION_CHUNK_SIZE, Integer.MAX_VALUE);
            int forceRecvFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_FORCE_RECV_FRAGMENTATION_CHUNK_SIZE, Integer.MAX_VALUE);
            this.httpWorkerCount = this.getInt(properties, env, PropertyKey.HTTP_WORKER_COUNT, 0);
            this.httpWorkerAffinity = this.getAffinity(properties, env, PropertyKey.HTTP_WORKER_AFFINITY, this.httpWorkerCount);
            this.httpWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.HTTP_WORKER_HALT_ON_ERROR, false);
            this.httpWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.HTTP_WORKER_YIELD_THRESHOLD, 10L);
            this.httpWorkerNapThreshold = this.getLong(properties, env, PropertyKey.HTTP_WORKER_NAP_THRESHOLD, 7000L);
            this.httpWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.HTTP_WORKER_SLEEP_THRESHOLD, 10000L);
            this.httpWorkerSleepTimeout = this.getMillis(properties, env, PropertyKey.HTTP_WORKER_SLEEP_TIMEOUT, 10L);
            this.httpSettingsReadOnly = this.getBoolean(properties, env, PropertyKey.HTTP_SETTINGS_READONLY, false);
            this.httpContextWebConsole = PropServerConfiguration.stripTrailingSlash(this.getString(properties, env, PropertyKey.HTTP_CONTEXT_WEB_CONSOLE, "/"));
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_ILP, this.httpContextPathILP, "/write", "/api/v2/write");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_ILP_PING, this.httpContextPathILPPing, "/ping");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_IMPORT, this.httpContextPathImport, this.httpContextWebConsole + "/imp");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_EXPORT, this.httpContextPathExport, this.httpContextWebConsole + "/exp");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_SETTINGS, this.httpContextPathSettings, this.httpContextWebConsole + "/settings");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_TABLE_STATUS, this.httpContextPathTableStatus, this.httpContextWebConsole + "/chk");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_EXECUTE, this.httpContextPathExec, this.httpContextWebConsole + "/exec");
            this.getUrls(properties, env, PropertyKey.HTTP_CONTEXT_WARNINGS, this.httpContextPathWarnings, this.httpContextWebConsole + "/warnings");
            this.httpContextPathImport.add(this.httpContextWebConsole + "/imp");
            this.httpContextPathExport.add(this.httpContextWebConsole + "/exp");
            this.httpContextPathSettings.add(this.httpContextWebConsole + "/settings");
            this.httpContextPathTableStatus.add(this.httpContextWebConsole + "/chk");
            this.httpContextPathExec.add(this.httpContextWebConsole + "/exec");
            this.httpContextPathWarnings.add(this.httpContextWebConsole + "/warnings");
            this.redirectMap = new Utf8SequenceObjHashMap();
            int redirectCount = this.getInt(properties, env, PropertyKey.HTTP_REDIRECT_COUNT, 0);
            if (redirectCount > 0) {
                for (int i = 0; i < redirectCount; ++i) {
                    RedirectPropertyKey key = new RedirectPropertyKey(i + 1);
                    String redirectConfig = this.getString(properties, env, key, null);
                    if (redirectConfig != null) {
                        String[] parts = redirectConfig.split("->");
                        if (parts.length == 2) {
                            String from = parts[0].trim();
                            String to = parts[1].trim();
                            if (from.isEmpty() || to.isEmpty()) continue;
                            this.redirectMap.put(new Utf8String(from), (Utf8Sequence)new Utf8String(to));
                            continue;
                        }
                        throw new ServerConfigurationException("could not parse redirect value [key=" + key.getPropertyPath() + ", value=" + redirectConfig + "]");
                    }
                    throw new ServerConfigurationException("undefined redirect value [" + key.getPropertyPath() + "]");
                }
            }
            Utf8String redirectTarget = new Utf8String(this.httpContextWebConsole + "/index.html");
            this.redirectMap.put(new Utf8String(this.httpContextWebConsole), (Utf8Sequence)redirectTarget);
            this.redirectMap.put(new Utf8String(this.httpContextWebConsole + "/"), (Utf8Sequence)redirectTarget);
            Object httpVersion = this.getString(properties, env, PropertyKey.HTTP_VERSION, "HTTP/1.1");
            if (!((String)httpVersion).endsWith(" ")) {
                httpVersion = (String)httpVersion + " ";
            }
            this.httpFrozenClock = this.getBoolean(properties, env, PropertyKey.HTTP_FROZEN_CLOCK, false);
            int httpForceSendFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_HTTP_FORCE_SEND_FRAGMENTATION_CHUNK_SIZE, forceSendFragmentationChunkSize);
            int httpForceRecvFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_HTTP_FORCE_RECV_FRAGMENTATION_CHUNK_SIZE, forceRecvFragmentationChunkSize);
            int connectionStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_CONNECTION_STRING_POOL_CAPACITY, 128);
            int connectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.HTTP_CONNECTION_POOL_INITIAL_CAPACITY, 4);
            int multipartHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MULTIPART_HEADER_BUFFER_SIZE, 512);
            long multipartIdleSpinCount = this.getLong(properties, env, PropertyKey.HTTP_MULTIPART_IDLE_SPIN_COUNT, 10000L);
            boolean httpAllowDeflateBeforeSend = this.getBoolean(properties, env, PropertyKey.HTTP_ALLOW_DEFLATE_BEFORE_SEND, false);
            boolean httpServerKeepAlive = this.getBoolean(properties, env, PropertyKey.HTTP_SERVER_KEEP_ALIVE, true);
            boolean httpServerCookiesEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_SERVER_KEEP_ALIVE, true);
            boolean httpReadOnlySecurityContext = this.getBoolean(properties, env, PropertyKey.HTTP_SECURITY_READONLY, false);
            this.httpNetAcceptLoopTimeout = this.getMillis(properties, env, PropertyKey.HTTP_NET_ACCEPT_LOOP_TIMEOUT, 500L);
            this.httpNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_NET_ACTIVE_CONNECTION_LIMIT, 256);
            this.httpNetConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_NET_CONNECTION_LIMIT, this.httpNetConnectionLimit);
            int httpJsonQueryConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_JSON_QUERY_CONNECTION_LIMIT, -1);
            int httpIlpConnectionLimit = this.getInt(properties, env, PropertyKey.HTTP_ILP_CONNECTION_LIMIT, -1);
            this.validateHttpConnectionLimits(httpJsonQueryConnectionLimit, httpIlpConnectionLimit, this.httpNetConnectionLimit);
            this.httpContextConfiguration = new PropHttpContextConfiguration(connectionPoolInitialCapacity, connectionStringPoolCapacity, this, httpAllowDeflateBeforeSend, httpForceRecvFragmentationChunkSize, httpForceSendFragmentationChunkSize, this.httpFrozenClock, httpReadOnlySecurityContext, httpServerCookiesEnabled, httpServerKeepAlive, (String)httpVersion, this.isReadOnlyInstance, multipartHeaderBufferSize, multipartIdleSpinCount, requestHeaderBufferSize, httpJsonQueryConnectionLimit, httpIlpConnectionLimit);
            int minHttpConnectionStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_MIN_CONNECTION_STRING_POOL_CAPACITY, 2);
            int minHttpConnectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.HTTP_MIN_CONNECTION_POOL_INITIAL_CAPACITY, 2);
            int minHttpMultipartHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_MULTIPART_HEADER_BUFFER_SIZE, 512);
            long minHttpMultipartIdleSpinCount = this.getLong(properties, env, PropertyKey.HTTP_MIN_MULTIPART_IDLE_SPIN_COUNT, 0L);
            boolean minHttpAllowDeflateBeforeSend = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_ALLOW_DEFLATE_BEFORE_SEND, false);
            boolean minHttpMinServerKeepAlive = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_SERVER_KEEP_ALIVE, true);
            boolean minHttpServerCookiesEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_MIN_SERVER_KEEP_ALIVE, true);
            int httpMinRequestHeaderBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_MIN_REQUEST_HEADER_BUFFER_SIZE, 4096);
            this.httpMinContextConfiguration = new PropHttpContextConfiguration(minHttpConnectionStringPoolCapacity, minHttpConnectionPoolInitialCapacity, this, minHttpAllowDeflateBeforeSend, httpForceRecvFragmentationChunkSize, httpForceSendFragmentationChunkSize, this.httpFrozenClock, true, minHttpServerCookiesEnabled, minHttpMinServerKeepAlive, (String)httpVersion, this.isReadOnlyInstance, minHttpMultipartHeaderBufferSize, minHttpMultipartIdleSpinCount, httpMinRequestHeaderBufferSize);
            int keepAliveTimeout = this.getInt(properties, env, PropertyKey.HTTP_KEEP_ALIVE_TIMEOUT, 5);
            int keepAliveMax = this.getInt(properties, env, PropertyKey.HTTP_KEEP_ALIVE_MAX, 10000);
            this.keepAliveHeader = keepAliveTimeout > 0 && keepAliveMax > 0 ? "Keep-Alive: timeout=" + keepAliveTimeout + ", max=" + keepAliveMax + "\r\n" : null;
            String publicDirectory = this.getString(properties, env, PropertyKey.HTTP_STATIC_PUBLIC_DIRECTORY, "public");
            this.publicDirectory = new File(publicDirectory).isAbsolute() ? publicDirectory : new File(installRoot, publicDirectory).getAbsolutePath();
            this.defaultSeqPartTxnCount = this.getInt(properties, env, PropertyKey.CAIRO_DEFAULT_SEQ_PART_TXN_COUNT, 0);
            this.httpNetConnectionHint = this.getBoolean(properties, env, PropertyKey.HTTP_NET_CONNECTION_HINT, false);
            this.httpNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.HTTP_NET_IDLE_CONNECTION_TIMEOUT, 300000L);
            this.httpNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.HTTP_NET_CONNECTION_TIMEOUT, this.httpNetConnectionTimeout);
            this.httpNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.HTTP_NET_QUEUED_CONNECTION_TIMEOUT, 5000L);
            this.httpNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.HTTP_NET_CONNECTION_QUEUE_TIMEOUT, this.httpNetConnectionQueueTimeout);
            this.httpNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_SND_BUF_SIZE, -1);
            this.httpNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_CONNECTION_SNDBUF, this.httpNetConnectionSndBuf);
            this.httpSendBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_SEND_BUFFER_SIZE, 0x200000);
            this.httpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_RCV_BUF_SIZE, -1);
            this.httpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.HTTP_NET_CONNECTION_RCVBUF, this.httpNetConnectionRcvBuf);
            this.httpRecvBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_RECEIVE_BUFFER_SIZE, 0x200000);
            this.httpRecvBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_RECV_BUFFER_SIZE, this.httpRecvBufferSize);
            this.httpRecvMaxBufferSize = this.getLongSize(properties, env, PropertyKey.LINE_HTTP_MAX_RECV_BUFFER_SIZE, 0x40000000L);
            this.dateAdapterPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_DATE_ADAPTER_POOL_CAPACITY, 16);
            this.jsonCacheLimit = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_JSON_CACHE_LIMIT, 16384);
            this.jsonCacheSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_JSON_CACHE_SIZE, 8192);
            this.maxRequiredDelimiterStdDev = this.getDouble(properties, env, PropertyKey.HTTP_TEXT_MAX_REQUIRED_DELIMITER_STDDEV, "0.1222");
            this.maxRequiredLineLengthStdDev = this.getDouble(properties, env, PropertyKey.HTTP_TEXT_MAX_REQUIRED_LINE_LENGTH_STDDEV, "0.8");
            this.metadataStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_METADATA_STRING_POOL_CAPACITY, 128);
            this.rollBufferLimit = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_ROLL_BUFFER_LIMIT, 0x400000);
            this.rollBufferSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_ROLL_BUFFER_SIZE, 1024);
            this.textAnalysisMaxLines = this.getInt(properties, env, PropertyKey.HTTP_TEXT_ANALYSIS_MAX_LINES, 1000);
            this.textLexerStringPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_LEXER_STRING_POOL_CAPACITY, 64);
            this.timestampAdapterPoolCapacity = this.getInt(properties, env, PropertyKey.HTTP_TEXT_TIMESTAMP_ADAPTER_POOL_CAPACITY, 64);
            this.utf8SinkSize = this.getIntSize(properties, env, PropertyKey.HTTP_TEXT_UTF8_SINK_SIZE, 4096);
            this.httpPessimisticHealthCheckEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_PESSIMISTIC_HEALTH_CHECK, false);
            boolean httpHealthCheckAuthRequired = this.getBoolean(properties, env, PropertyKey.HTTP_HEALTH_CHECK_AUTHENTICATION_REQUIRED, true);
            this.httpHealthCheckAuthType = httpHealthCheckAuthRequired ? (byte)1 : 0;
            this.maxHttpQueryResponseRowLimit = this.getLong(properties, env, PropertyKey.HTTP_SECURITY_MAX_RESPONSE_ROWS, Long.MAX_VALUE);
            this.interruptOnClosedConnection = this.getBoolean(properties, env, PropertyKey.HTTP_SECURITY_INTERRUPT_ON_CLOSED_CONNECTION, true);
            this.httpUsername = this.getString(properties, env, PropertyKey.HTTP_USER, "");
            this.httpPassword = this.getString(properties, env, PropertyKey.HTTP_PASSWORD, "");
            if (!Chars.empty(this.httpUsername) && Chars.empty(this.httpPassword)) {
                throw new ServerConfigurationException("HTTP username is set but password is missing. Use the '" + PropertyKey.HTTP_PASSWORD.getPropertyPath() + "' configuration property to set a password. [user=" + this.httpUsername + "]");
            }
            if (Chars.empty(this.httpUsername) && !Chars.empty(this.httpPassword)) {
                throw new ServerConfigurationException("HTTP password is set but username is missing. Use the '" + PropertyKey.HTTP_USER.getPropertyPath() + "' configuration property to set a username.");
            }
            if (loadAdditionalConfigurations && this.httpServerEnabled) {
                this.jsonQueryConnectionCheckFrequency = this.getInt(properties, env, PropertyKey.HTTP_JSON_QUERY_CONNECTION_CHECK_FREQUENCY, 1000000);
                String httpBindTo = this.getString(properties, env, PropertyKey.HTTP_BIND_TO, "0.0.0.0:9000");
                this.parseBindTo(properties, env, PropertyKey.HTTP_NET_BIND_TO, httpBindTo, (a, p) -> {
                    this.httpNetBindIPv4Address = a;
                    this.httpNetBindPort = p;
                });
                path.of(new File(new File(installRoot, CONFIG_DIRECTORY), "mime.types").getAbsolutePath());
                this.mimeTypesCache = new MimeTypesCache(FilesFacadeImpl.INSTANCE, path.$());
            }
            this.maxRerunWaitCapMs = this.getMillis(properties, env, PropertyKey.HTTP_BUSY_RETRY_MAXIMUM_WAIT_BEFORE_RETRY, 1000L);
            this.rerunExponentialWaitMultiplier = this.getDouble(properties, env, PropertyKey.HTTP_BUSY_RETRY_EXPONENTIAL_WAIT_MULTIPLIER, "2.0");
            this.rerunInitialWaitQueueSize = this.getIntSize(properties, env, PropertyKey.HTTP_BUSY_RETRY_INITIAL_WAIT_QUEUE_SIZE, 64);
            this.rerunMaxProcessingQueueSize = this.getIntSize(properties, env, PropertyKey.HTTP_BUSY_RETRY_MAX_PROCESSING_QUEUE_SIZE, 4096);
            this.circuitBreakerThrottle = this.getInt(properties, env, PropertyKey.CIRCUIT_BREAKER_THROTTLE, 2000000);
            this.queryTimeout = (long)(this.getDouble(properties, env, PropertyKey.QUERY_TIMEOUT_SEC, "60") * 1000.0);
            this.queryTimeout = this.getMillis(properties, env, PropertyKey.QUERY_TIMEOUT, this.queryTimeout);
            this.queryWithinLatestByOptimisationEnabled = this.getBoolean(properties, env, PropertyKey.QUERY_WITHIN_LATEST_BY_OPTIMISATION_ENABLED, false);
            this.netTestConnectionBufferSize = this.getInt(properties, env, PropertyKey.CIRCUIT_BREAKER_BUFFER_SIZE, 64);
            this.netTestConnectionBufferSize = this.getInt(properties, env, PropertyKey.NET_TEST_CONNECTION_BUFFER_SIZE, this.netTestConnectionBufferSize);
            this.pgEnabled = this.getBoolean(properties, env, PropertyKey.PG_ENABLED, true);
            if (this.pgEnabled) {
                this.pgForceSendFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_PG_FORCE_SEND_FRAGMENTATION_CHUNK_SIZE, forceSendFragmentationChunkSize);
                this.pgForceRecvFragmentationChunkSize = this.getInt(properties, env, PropertyKey.DEBUG_PG_FORCE_RECV_FRAGMENTATION_CHUNK_SIZE, forceRecvFragmentationChunkSize);
                this.pgNetConnectionLimit = this.getInt(properties, env, PropertyKey.PG_NET_ACTIVE_CONNECTION_LIMIT, 64);
                this.pgNetConnectionLimit = this.getInt(properties, env, PropertyKey.PG_NET_CONNECTION_LIMIT, this.pgNetConnectionLimit);
                this.pgNetConnectionHint = this.getBoolean(properties, env, PropertyKey.PG_NET_CONNECTION_HINT, false);
                this.parseBindTo(properties, env, PropertyKey.PG_NET_BIND_TO, "0.0.0.0:8812", (a, p) -> {
                    this.pgNetBindIPv4Address = a;
                    this.pgNetBindPort = p;
                });
                this.pgNetAcceptLoopTimeout = this.getMillis(properties, env, PropertyKey.PG_NET_ACCEPT_LOOP_TIMEOUT, 500L);
                this.pgNetIdleConnectionTimeout = this.getMillis(properties, env, PropertyKey.PG_NET_IDLE_TIMEOUT, 300000L);
                this.pgNetIdleConnectionTimeout = this.getMillis(properties, env, PropertyKey.PG_NET_CONNECTION_TIMEOUT, this.pgNetIdleConnectionTimeout);
                this.pgNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.PG_NET_CONNECTION_QUEUE_TIMEOUT, 300000L);
                this.pgCharacterStoreCapacity = this.getInt(properties, env, PropertyKey.PG_CHARACTER_STORE_CAPACITY, 4096);
                this.pgBinaryParamsCapacity = this.getInt(properties, env, PropertyKey.PG_BINARY_PARAM_COUNT_CAPACITY, 2);
                this.pgCharacterStorePoolCapacity = this.getInt(properties, env, PropertyKey.PG_CHARACTER_STORE_POOL_CAPACITY, 64);
                this.pgConnectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.PG_CONNECTION_POOL_CAPACITY, 4);
                this.pgPassword = this.getString(properties, env, PropertyKey.PG_PASSWORD, "quest");
                this.pgUsername = this.getString(properties, env, PropertyKey.PG_USER, "admin");
                this.pgReadOnlyPassword = this.getString(properties, env, PropertyKey.PG_RO_PASSWORD, "quest");
                this.pgReadOnlyUsername = this.getString(properties, env, PropertyKey.PG_RO_USER, "user");
                this.pgReadOnlyUserEnabled = this.getBoolean(properties, env, PropertyKey.PG_RO_USER_ENABLED, false);
                this.pgReadOnlySecurityContext = this.getBoolean(properties, env, PropertyKey.PG_SECURITY_READONLY, false);
                this.pgMaxBlobSizeOnQuery = this.getIntSize(properties, env, PropertyKey.PG_MAX_BLOB_SIZE_ON_QUERY, 524288);
                this.pgNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_RECV_BUF_SIZE, -1);
                this.pgNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_CONNECTION_RCVBUF, this.pgNetConnectionRcvBuf);
                this.pgRecvBufferSize = this.getIntSize(properties, env, PropertyKey.PG_RECV_BUFFER_SIZE, 0x100000);
                this.pgNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_SEND_BUF_SIZE, -1);
                this.pgNetConnectionSndBuf = this.getIntSize(properties, env, PropertyKey.PG_NET_CONNECTION_SNDBUF, this.pgNetConnectionSndBuf);
                this.pgSendBufferSize = this.getIntSize(properties, env, PropertyKey.PG_SEND_BUFFER_SIZE, 0x100000);
                String dateLocale = this.getString(properties, env, PropertyKey.PG_DATE_LOCALE, "en");
                this.pgDefaultLocale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
                if (this.pgDefaultLocale == null) {
                    throw ServerConfigurationException.forInvalidKey(PropertyKey.PG_DATE_LOCALE.getPropertyPath(), dateLocale);
                }
                this.pgWorkerCount = this.getInt(properties, env, PropertyKey.PG_WORKER_COUNT, 0);
                this.pgWorkerAffinity = this.getAffinity(properties, env, PropertyKey.PG_WORKER_AFFINITY, this.pgWorkerCount);
                this.pgHaltOnError = this.getBoolean(properties, env, PropertyKey.PG_HALT_ON_ERROR, false);
                this.pgWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.PG_WORKER_YIELD_THRESHOLD, 10L);
                this.pgWorkerNapThreshold = this.getLong(properties, env, PropertyKey.PG_WORKER_NAP_THRESHOLD, 7000L);
                this.pgWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.PG_WORKER_SLEEP_THRESHOLD, 10000L);
                this.pgDaemonPool = this.getBoolean(properties, env, PropertyKey.PG_DAEMON_POOL, true);
                this.pgInsertCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_INSERT_CACHE_ENABLED, true);
                this.pgInsertCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_INSERT_CACHE_BLOCK_COUNT, 4);
                this.pgInsertCacheRowCount = this.getInt(properties, env, PropertyKey.PG_INSERT_CACHE_ROW_COUNT, 4);
                this.pgUpdateCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_UPDATE_CACHE_ENABLED, true);
                this.pgUpdateCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_UPDATE_CACHE_BLOCK_COUNT, 4);
                this.pgUpdateCacheRowCount = this.getInt(properties, env, PropertyKey.PG_UPDATE_CACHE_ROW_COUNT, 4);
                this.pgNamedStatementCacheCapacity = this.getInt(properties, env, PropertyKey.PG_NAMED_STATEMENT_CACHE_CAPACITY, 32);
                this.pgNamesStatementPoolCapacity = this.getInt(properties, env, PropertyKey.PG_NAMED_STATEMENT_POOL_CAPACITY, 32);
                this.pgPendingWritersCacheCapacity = this.getInt(properties, env, PropertyKey.PG_PENDING_WRITERS_CACHE_CAPACITY, 16);
                this.pgNamedStatementLimit = this.getInt(properties, env, PropertyKey.PG_NAMED_STATEMENT_LIMIT, 10000);
                this.pgPipelineCapacity = this.getInt(properties, env, PropertyKey.PG_PIPELINE_CAPACITY, 64);
            }
            this.walApplyWorkerCount = this.getInt(properties, env, PropertyKey.WAL_APPLY_WORKER_COUNT, 0);
            this.walApplyWorkerAffinity = this.getAffinity(properties, env, PropertyKey.WAL_APPLY_WORKER_AFFINITY, this.walApplyWorkerCount);
            this.walApplyWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.WAL_APPLY_WORKER_HALT_ON_ERROR, false);
            this.walApplyWorkerNapThreshold = this.getLong(properties, env, PropertyKey.WAL_APPLY_WORKER_NAP_THRESHOLD, 7000L);
            this.walApplyWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.WAL_APPLY_WORKER_SLEEP_THRESHOLD, 10000L);
            this.walApplySleepTimeout = this.getMillis(properties, env, PropertyKey.WAL_APPLY_WORKER_SLEEP_TIMEOUT, 10L);
            this.walApplyWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.WAL_APPLY_WORKER_YIELD_THRESHOLD, 1000L);
            this.matViewEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_MAT_VIEW_ENABLED, true);
            this.matViewMaxRefreshRetries = this.getInt(properties, env, PropertyKey.CAIRO_MAT_VIEW_MAX_REFRESH_RETRIES, 10);
            this.matViewRefreshOomRetryTimeout = this.getMillis(properties, env, PropertyKey.CAIRO_MAT_VIEW_REFRESH_OOM_RETRY_TIMEOUT, 200L);
            this.matViewRefreshWorkerCount = this.getInt(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_COUNT, 0);
            this.matViewRefreshWorkerAffinity = this.getAffinity(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_AFFINITY, this.matViewRefreshWorkerCount);
            this.matViewRefreshWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_HALT_ON_ERROR, false);
            this.matViewRefreshWorkerNapThreshold = this.getLong(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_NAP_THRESHOLD, 7000L);
            this.matViewRefreshWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_SLEEP_THRESHOLD, 10000L);
            this.matViewRefreshSleepTimeout = this.getMillis(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_SLEEP_TIMEOUT, 10L);
            this.matViewRefreshWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.MAT_VIEW_REFRESH_WORKER_YIELD_THRESHOLD, 1000L);
            this.commitMode = this.getCommitMode(properties, env, PropertyKey.CAIRO_COMMIT_MODE);
            this.createAsSelectRetryCount = this.getInt(properties, env, PropertyKey.CAIRO_CREATE_AS_SELECT_RETRY_COUNT, 5);
            this.defaultSymbolCacheFlag = this.getBoolean(properties, env, PropertyKey.CAIRO_DEFAULT_SYMBOL_CACHE_FLAG, true);
            this.defaultSymbolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_DEFAULT_SYMBOL_CAPACITY, 256);
            this.fileOperationRetryCount = this.getInt(properties, env, PropertyKey.CAIRO_FILE_OPERATION_RETRY_COUNT, 30);
            this.idleCheckInterval = this.getMillis(properties, env, PropertyKey.CAIRO_IDLE_CHECK_INTERVAL, 300000L);
            this.idGenerateBatchStep = this.getInt(properties, env, PropertyKey.CAIRO_ID_GENERATE_STEP, 512);
            this.inactiveReaderMaxOpenPartitions = this.getInt(properties, env, PropertyKey.CAIRO_INACTIVE_READER_MAX_OPEN_PARTITIONS, 10000);
            this.inactiveReaderTTL = this.getMillis(properties, env, PropertyKey.CAIRO_INACTIVE_READER_TTL, 120000L);
            this.inactiveWriterTTL = this.getMillis(properties, env, PropertyKey.CAIRO_INACTIVE_WRITER_TTL, 600000L);
            this.inactiveWalWriterTTL = this.getMillis(properties, env, PropertyKey.CAIRO_WAL_INACTIVE_WRITER_TTL, 120000L);
            this.indexValueBlockSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_INDEX_VALUE_BLOCK_SIZE, 256));
            this.maxSwapFileCount = this.getInt(properties, env, PropertyKey.CAIRO_MAX_SWAP_FILE_COUNT, 30);
            this.parallelIndexThreshold = this.getInt(properties, env, PropertyKey.CAIRO_PARALLEL_INDEX_THRESHOLD, 100000);
            this.readerPoolMaxSegments = this.getInt(properties, env, PropertyKey.CAIRO_READER_POOL_MAX_SEGMENTS, 10);
            this.walWriterPoolMaxSegments = this.getInt(properties, env, PropertyKey.CAIRO_WAL_WRITER_POOL_MAX_SEGMENTS, 10);
            this.spinLockTimeout = this.getMillis(properties, env, PropertyKey.CAIRO_SPIN_LOCK_TIMEOUT, 1000L);
            this.sqlCharacterStoreCapacity = this.getInt(properties, env, PropertyKey.CAIRO_CHARACTER_STORE_CAPACITY, 1024);
            this.sqlCharacterStoreSequencePoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_CHARACTER_STORE_SEQUENCE_POOL_CAPACITY, 64);
            this.sqlColumnPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_COLUMN_POOL_CAPACITY, 4096);
            this.sqlExpressionPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_EXPRESSION_POOL_CAPACITY, 8192);
            this.sqlFastMapLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_FAST_MAP_LOAD_FACTOR, "0.7");
            this.sqlJoinContextPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JOIN_CONTEXT_POOL_CAPACITY, 64);
            this.sqlLexerPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_LEXER_POOL_CAPACITY, 2048);
            this.sqlSmallMapKeyCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_SMALL_MAP_KEY_CAPACITY, 32);
            this.sqlSmallMapPageSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_SMALL_MAP_PAGE_SIZE, 32768L);
            this.sqlUnorderedMapMaxEntrySize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_UNORDERED_MAP_MAX_ENTRY_SIZE, 32);
            this.sqlMapMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_MAP_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlMapMaxResizes = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_MAP_MAX_RESIZES, Integer.MAX_VALUE);
            this.sqlExplainModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_EXPLAIN_MODEL_POOL_CAPACITY, 32);
            this.sqlModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_MODEL_POOL_CAPACITY, 1024);
            this.sqlMaxNegativeLimit = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_NEGATIVE_LIMIT, 10000);
            this.sqlSortKeyPageSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_SORT_KEY_PAGE_SIZE, 131072L);
            this.sqlSortKeyMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_KEY_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlSortLightValuePageSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_SORT_LIGHT_VALUE_PAGE_SIZE, 131072L);
            this.sqlSortLightValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_LIGHT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlHashJoinValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_VALUE_PAGE_SIZE, 0x1000000);
            this.sqlHashJoinValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlLatestByRowCount = this.getInt(properties, env, PropertyKey.CAIRO_SQL_LATEST_BY_ROW_COUNT, 1000);
            this.sqlHashJoinLightValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_LIGHT_VALUE_PAGE_SIZE, 131072);
            this.sqlHashJoinLightValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_HASH_JOIN_LIGHT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlAsOfJoinLookahead = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ASOF_JOIN_LOOKAHEAD, 100);
            this.sqlAsOfJoinShortCircuitCacheCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ASOF_JOIN_SHORT_CIRCUIT_CACHE_CAPACITY, 10000000);
            this.sqlAsOfJoinEvacuationThreshold = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ASOF_JOIN_EVACUATION_THRESHOLD, 10000000);
            this.useFastAsOfJoin = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_ASOF_JOIN_FAST, true);
            this.sqlSortValuePageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_VALUE_PAGE_SIZE, 0x1000000);
            this.sqlSortValueMaxPages = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SORT_VALUE_MAX_PAGES, Integer.MAX_VALUE);
            this.workStealTimeoutNanos = this.getNanos(properties, env, PropertyKey.CAIRO_WORK_STEAL_TIMEOUT_NANOS, 10000L);
            this.parallelIndexingEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_PARALLEL_INDEXING_ENABLED, true);
            this.sqlJoinMetadataPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JOIN_METADATA_PAGE_SIZE, 16384);
            this.sqlJoinMetadataMaxResizes = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JOIN_METADATA_MAX_RESIZES, Integer.MAX_VALUE);
            int sqlWindowColumnPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_COLUMN_POOL_CAPACITY, 64);
            this.sqlWindowColumnPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WINDOW_COLUMN_POOL_CAPACITY, sqlWindowColumnPoolCapacity);
            this.sqlCreateTableModelBatchSize = this.getLong(properties, env, PropertyKey.CAIRO_SQL_CREATE_TABLE_MODEL_BATCH_SIZE, 1000000L);
            this.sqlCreateTableColumnModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_CREATE_TABLE_COLUMN_MODEL_POOL_CAPACITY, 16);
            this.sqlRenameTableModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_RENAME_TABLE_MODEL_POOL_CAPACITY, 16);
            this.sqlWithClauseModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WITH_CLAUSE_MODEL_POOL_CAPACITY, 128);
            this.sqlInsertModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_INSERT_MODEL_POOL_CAPACITY, 64);
            this.sqlInsertModelBatchSize = this.getLong(properties, env, PropertyKey.CAIRO_SQL_INSERT_MODEL_BATCH_SIZE, 1000000L);
            this.matViewInsertAsSelectBatchSize = this.getLong(properties, env, PropertyKey.CAIRO_MAT_VIEW_INSERT_AS_SELECT_BATCH_SIZE, this.sqlInsertModelBatchSize);
            this.matViewRowsPerQueryEstimate = this.getInt(properties, env, PropertyKey.CAIRO_MAT_VIEW_ROWS_PER_QUERY_ESTIMATE, 1000000);
            this.matViewMaxRefreshIntervals = this.getInt(properties, env, PropertyKey.CAIRO_MAT_VIEW_MAX_REFRESH_INTERVALS, 100);
            this.sqlCopyBufferSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_COPY_BUFFER_SIZE, 0x200000);
            this.columnPurgeQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_QUEUE_CAPACITY, 128);
            this.columnPurgeTaskPoolCapacity = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_TASK_POOL_CAPACITY, 256);
            this.columnPurgeRetryDelayLimit = this.getMicros(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY_LIMIT, 60000000L);
            this.columnPurgeRetryDelay = this.getMicros(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY, 10000L);
            this.columnPurgeRetryDelayMultiplier = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_COLUMN_PURGE_RETRY_DELAY_MULTIPLIER, "10.0");
            this.systemTableNamePrefix = this.getString(properties, env, PropertyKey.CAIRO_SQL_SYSTEM_TABLE_PREFIX, "sys.");
            this.sqlMaxArrayElementCount = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_ARRAY_ELEMENT_COUNT, 10000000);
            this.preferencesStringPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_PREFERENCES_STRING_POOL_CAPACITY, 64);
            this.writerDataIndexKeyAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_INDEX_KEY_APPEND_PAGE_SIZE, 524288L));
            this.writerDataIndexValueAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_INDEX_VALUE_APPEND_PAGE_SIZE, 0x1000000L));
            this.writerDataAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_DATA_APPEND_PAGE_SIZE, 0x1000000L));
            this.systemWriterDataAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_SYSTEM_WRITER_DATA_APPEND_PAGE_SIZE, 262144L));
            this.writerMiscAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_MISC_APPEND_PAGE_SIZE, Files.PAGE_SIZE));
            this.symbolTableAppendPageSize = Files.ceilPageSize(this.getLongSize(properties, env, PropertyKey.CAIRO_SYMBOL_TABLE_APPEND_PAGE_SIZE, 262144L));
            this.sqlSampleByIndexSearchPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_SAMPLEBY_PAGE_SIZE, 0);
            this.sqlSampleByDefaultAlignment = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_SAMPLEBY_DEFAULT_ALIGNMENT_CALENDAR, true);
            this.sqlGroupByMapCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_MAP_CAPACITY, 1024);
            this.sqlGroupByAllocatorChunkSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_ALLOCATOR_DEFAULT_CHUNK_SIZE, 131072L);
            this.sqlGroupByAllocatorMaxChunkSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_ALLOCATOR_MAX_CHUNK_SIZE, 0x100000000L);
            this.sqlGroupByPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_GROUPBY_POOL_CAPACITY, 1024);
            this.sqlMaxSymbolNotEqualsCount = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_SYMBOL_NOT_EQUALS_COUNT, 100);
            this.sqlBindVariablePoolSize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_BIND_VARIABLE_POOL_SIZE, 8);
            this.sqlQueryRegistryPoolSize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_QUERY_REGISTRY_POOL_SIZE, 32);
            this.sqlCountDistinctCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COUNT_DISTINCT_CAPACITY, 3);
            this.sqlCountDistinctLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_COUNT_DISTINCT_LOAD_FACTOR, "0.75");
            String sqlCopyFormatsFile = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_FORMATS_FILE, "/text_loader.json");
            String dateLocale = this.getString(properties, env, PropertyKey.CAIRO_DATE_LOCALE, "en");
            this.locale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
            if (this.locale == null) {
                throw ServerConfigurationException.forInvalidKey(PropertyKey.CAIRO_DATE_LOCALE.getPropertyPath(), dateLocale);
            }
            this.sqlDistinctTimestampKeyCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_DISTINCT_TIMESTAMP_KEY_CAPACITY, 512);
            this.sqlDistinctTimestampLoadFactor = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_DISTINCT_TIMESTAMP_LOAD_FACTOR, "0.5");
            this.sqlPageFrameMinRows = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PAGE_FRAME_MIN_ROWS, 100000);
            this.sqlPageFrameMaxRows = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PAGE_FRAME_MAX_ROWS, 1000000);
            this.sqlJitMode = this.getSqlJitMode(properties, env);
            this.sqlJitIRMemoryPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_IR_MEMORY_PAGE_SIZE, 8192);
            this.sqlJitIRMemoryMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JIT_IR_MEMORY_MAX_PAGES, 8);
            this.sqlJitBindVarsMemoryPageSize = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_BIND_VARS_MEMORY_PAGE_SIZE, 4096);
            this.sqlJitBindVarsMemoryMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_JIT_BIND_VARS_MEMORY_MAX_PAGES, 8);
            this.sqlJitPageAddressCacheThreshold = this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_JIT_PAGE_ADDRESS_CACHE_THRESHOLD, 0x100000);
            this.sqlJitDebugEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_JIT_DEBUG_ENABLED, false);
            this.maxSqlRecompileAttempts = this.getInt(properties, env, PropertyKey.CAIRO_SQL_MAX_RECOMPILE_ATTEMPTS, 10);
            String value = this.getString(properties, env, PropertyKey.CAIRO_WRITER_FO_OPTS, "o_none");
            int lopts = 0;
            for (String opt : opts = value.split("\\|")) {
                int index = WRITE_FO_OPTS.keyIndex(opt.trim());
                if (index >= 0) continue;
                lopts |= WRITE_FO_OPTS.valueAt(index);
            }
            this.writerFileOpenOpts = lopts;
            this.writerMixedIOEnabled = this.getBoolean(properties, env, PropertyKey.DEBUG_CAIRO_ALLOW_MIXED_IO, ff.allowMixedIO(this.dbRoot));
            this.fileDescriptorCacheEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_FILE_DESCRIPTOR_CACHE_ENABLED, true);
            this.inputFormatConfiguration = new InputFormatConfiguration(new DateFormatFactory(), DateLocaleFactory.INSTANCE, new TimestampFormatFactory(), this.locale);
            try (JsonLexer lexer = new JsonLexer(1024, 1024);){
                this.inputFormatConfiguration.parseConfiguration(PropServerConfiguration.class, lexer, this.confRoot, sqlCopyFormatsFile);
            }
            String cairoSQLCopyIdSupplier = this.getString(properties, env, PropertyKey.CAIRO_SQL_COPY_ID_SUPPLIER, "random");
            this.cairoSQLCopyIdSupplier = Chars.equalsLowerCaseAscii(cairoSQLCopyIdSupplier, "sequential") ? 1 : 0;
            this.cairoSqlCopyMaxIndexChunkSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_COPY_MAX_INDEX_CHUNK_SIZE, 0x6400000L);
            this.cairoSqlCopyMaxIndexChunkSize -= this.cairoSqlCopyMaxIndexChunkSize % 16L;
            if (this.cairoSqlCopyMaxIndexChunkSize < 16L) {
                throw new ServerConfigurationException("invalid configuration value [key=" + PropertyKey.CAIRO_SQL_COPY_MAX_INDEX_CHUNK_SIZE.getPropertyPath() + ", description=max import chunk size can't be smaller than 16]");
            }
            this.cairoSqlCopyQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_QUEUE_CAPACITY, 32));
            this.cairoSqlCopyLogRetentionDays = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_LOG_RETENTION_DAYS, 3);
            this.o3MinLagUs = this.getMicros(properties, env, PropertyKey.CAIRO_O3_MIN_LAG, 1000L) * 1000L;
            this.backupRoot = this.getString(properties, env, PropertyKey.CAIRO_SQL_BACKUP_ROOT, null);
            this.backupDirTimestampFormat = this.getTimestampFormat(properties, env);
            this.backupTempDirName = this.getString(properties, env, PropertyKey.CAIRO_SQL_BACKUP_DIR_TMP_NAME, TMP_DIRECTORY);
            this.backupMkdirMode = this.getInt(properties, env, PropertyKey.CAIRO_SQL_BACKUP_MKDIR_MODE, 509);
            this.detachedMkdirMode = this.getInt(properties, env, PropertyKey.CAIRO_DETACHED_MKDIR_MODE, 509);
            this.columnIndexerQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_COLUMN_INDEXER_QUEUE_CAPACITY, 64);
            this.vectorAggregateQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_VECTOR_AGGREGATE_QUEUE_CAPACITY, 128);
            this.o3CallbackQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_CALLBACK_QUEUE_CAPACITY, 128);
            this.o3PartitionQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_PARTITION_QUEUE_CAPACITY, 128);
            this.o3OpenColumnQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_OPEN_COLUMN_QUEUE_CAPACITY, 128);
            this.o3CopyQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.CAIRO_O3_COPY_QUEUE_CAPACITY, 128);
            this.o3LagCalculationWindowsSize = this.getIntSize(properties, env, PropertyKey.CAIRO_O3_LAG_CALCULATION_WINDOW_SIZE, 4);
            this.o3PurgeDiscoveryQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_O3_PURGE_DISCOVERY_QUEUE_CAPACITY, 128));
            int debugO3MemSize = this.getInt(properties, env, PropertyKey.DEBUG_CAIRO_O3_COLUMN_MEMORY_SIZE, 0);
            this.o3ColumnMemorySize = debugO3MemSize != 0 ? debugO3MemSize : (int)Files.ceilPageSize(this.getIntSize(properties, env, PropertyKey.CAIRO_O3_COLUMN_MEMORY_SIZE, 0x800000));
            this.systemO3ColumnMemorySize = (int)Files.ceilPageSize(this.getIntSize(properties, env, PropertyKey.CAIRO_SYSTEM_O3_COLUMN_MEMORY_SIZE, 262144));
            this.maxUncommittedRows = this.getInt(properties, env, PropertyKey.CAIRO_MAX_UNCOMMITTED_ROWS, 500000);
            long o3MaxLagMs = this.getMillis(properties, env, PropertyKey.CAIRO_COMMIT_LAG, 600000L);
            this.o3MaxLagUs = this.getMillis(properties, env, PropertyKey.CAIRO_O3_MAX_LAG, o3MaxLagMs) * 1000L;
            this.o3QuickSortEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_O3_QUICKSORT_ENABLED, false);
            this.rndFunctionMemoryPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_RND_MEMORY_PAGE_SIZE, 8192));
            this.rndFunctionMemoryMaxPages = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_RND_MEMORY_MAX_PAGES, 128));
            this.sqlStrFunctionBufferMaxSize = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_STR_FUNCTION_BUFFER_MAX_SIZE, 0x100000));
            this.sqlWindowMaxRecursion = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WINDOW_MAX_RECURSION, 128);
            int sqlWindowStorePageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_STORE_PAGE_SIZE, 0x100000));
            this.sqlWindowStorePageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_WINDOW_STORE_PAGE_SIZE, sqlWindowStorePageSize));
            int sqlWindowStoreMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_STORE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlWindowStoreMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WINDOW_STORE_MAX_PAGES, sqlWindowStoreMaxPages);
            int sqlWindowRowIdPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_PAGE_SIZE, 524288));
            this.sqlWindowRowIdPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_WINDOW_ROWID_PAGE_SIZE, sqlWindowRowIdPageSize));
            int sqlWindowRowIdMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlWindowRowIdMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WINDOW_ROWID_MAX_PAGES, sqlWindowRowIdMaxPages);
            int sqlWindowTreeKeyPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_TREE_PAGE_SIZE, 524288));
            this.sqlWindowTreeKeyPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, PropertyKey.CAIRO_SQL_WINDOW_TREE_PAGE_SIZE, sqlWindowTreeKeyPageSize));
            int sqlWindowTreeKeyMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_TREE_MAX_PAGES, Integer.MAX_VALUE);
            this.sqlWindowTreeKeyMaxPages = this.getInt(properties, env, PropertyKey.CAIRO_SQL_WINDOW_TREE_MAX_PAGES, sqlWindowTreeKeyMaxPages);
            this.cairoSqlLegacyOperatorPrecedence = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_LEGACY_OPERATOR_PRECEDENCE, false);
            this.sqlWindowInitialRangeBufferSize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ANALYTIC_INITIAL_RANGE_BUFFER_SIZE, 32);
            this.sqlTxnScoreboardEntryCount = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_O3_TXN_SCOREBOARD_ENTRY_COUNT, 16384));
            this.latestByQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_LATEST_ON_QUEUE_CAPACITY, 32));
            this.telemetryEnabled = this.getBoolean(properties, env, PropertyKey.TELEMETRY_ENABLED, true);
            this.telemetryDisableCompletely = this.getBoolean(properties, env, PropertyKey.TELEMETRY_DISABLE_COMPLETELY, false);
            this.telemetryQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.TELEMETRY_QUEUE_CAPACITY, 512));
            this.telemetryHideTables = this.getBoolean(properties, env, PropertyKey.TELEMETRY_HIDE_TABLES, true);
            this.telemetryDbSizeEstimateTimeout = this.getMillis(properties, env, PropertyKey.TELEMETRY_DB_SIZE_ESTIMATE_TIMEOUT, 1000L);
            this.o3PartitionPurgeListCapacity = this.getInt(properties, env, PropertyKey.CAIRO_O3_PARTITION_PURGE_LIST_INITIAL_CAPACITY, 1);
            this.ioURingEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_IO_URING_ENABLED, true);
            this.cairoMaxCrashFiles = this.getInt(properties, env, PropertyKey.CAIRO_MAX_CRASH_FILES, 100);
            this.o3LastPartitionMaxSplits = Math.max(1, this.getInt(properties, env, PropertyKey.CAIRO_O3_LAST_PARTITION_MAX_SPLITS, 20));
            this.o3PartitionSplitMinSize = this.getLongSize(properties, env, PropertyKey.CAIRO_O3_PARTITION_SPLIT_MIN_SIZE, 0x3200000L);
            this.o3PartitionOverwriteControlEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_O3_PARTITION_OVERWRITE_CONTROL_ENABLED, false);
            this.parseBindTo(properties, env, PropertyKey.LINE_UDP_BIND_TO, "0.0.0.0:9009", (a, p) -> {
                this.lineUdpBindIPV4Address = a;
                this.lineUdpPort = p;
            });
            this.lineUdpGroupIPv4Address = this.getIPv4Address(properties, env, PropertyKey.LINE_UDP_JOIN, "232.1.2.3");
            this.lineUdpCommitRate = this.getInt(properties, env, PropertyKey.LINE_UDP_COMMIT_RATE, 1000000);
            this.lineUdpMsgBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_UDP_MSG_BUFFER_SIZE, 2048);
            this.lineUdpMsgCount = this.getInt(properties, env, PropertyKey.LINE_UDP_MSG_COUNT, 10000);
            this.lineUdpReceiveBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_UDP_RECEIVE_BUFFER_SIZE, 0x800000);
            this.lineUdpEnabled = this.getBoolean(properties, env, PropertyKey.LINE_UDP_ENABLED, false);
            this.lineUdpOwnThreadAffinity = this.getInt(properties, env, PropertyKey.LINE_UDP_OWN_THREAD_AFFINITY, -1);
            this.lineUdpOwnThread = this.getBoolean(properties, env, PropertyKey.LINE_UDP_OWN_THREAD, false);
            this.lineUdpUnicast = this.getBoolean(properties, env, PropertyKey.LINE_UDP_UNICAST, false);
            this.lineUdpCommitMode = this.getCommitMode(properties, env, PropertyKey.LINE_UDP_COMMIT_MODE);
            this.lineUdpTimestampAdapter = this.getLineTimestampAdaptor(properties, env, PropertyKey.LINE_UDP_TIMESTAMP);
            String defaultUdpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_DEFAULT_PARTITION_BY, "DAY");
            this.lineUdpDefaultPartitionBy = PartitionBy.fromString(defaultUdpPartitionByProperty);
            if (this.lineUdpDefaultPartitionBy == -1) {
                log.info().$("invalid partition by ").$(this.lineUdpDefaultPartitionBy).$("), will use DAY for UDP").$();
                this.lineUdpDefaultPartitionBy = 0;
            }
            this.lineTcpEnabled = this.getBoolean(properties, env, PropertyKey.LINE_TCP_ENABLED, true);
            this.lineHttpEnabled = this.getBoolean(properties, env, PropertyKey.LINE_HTTP_ENABLED, true);
            this.lineHttpPingVersion = this.getString(properties, env, PropertyKey.LINE_HTTP_PING_VERSION, "v2.7.4");
            if (this.lineTcpEnabled || this.lineHttpEnabled) {
                this.lineTcpNetConnectionLimit = this.getInt(properties, env, PropertyKey.LINE_TCP_NET_ACTIVE_CONNECTION_LIMIT, 256);
                this.lineTcpNetConnectionLimit = this.getInt(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_LIMIT, this.lineTcpNetConnectionLimit);
                this.lineTcpNetConnectionHint = this.getBoolean(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_HINT, false);
                this.parseBindTo(properties, env, PropertyKey.LINE_TCP_NET_BIND_TO, "0.0.0.0:9009", (a, p) -> {
                    this.lineTcpNetBindIPv4Address = a;
                    this.lineTcpNetBindPort = p;
                });
                this.lineTcpNetAcceptLoopTimeout = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_ACCEPT_LOOP_TIMEOUT, 500L);
                this.lineTcpNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_IDLE_TIMEOUT, 0L);
                this.lineTcpNetConnectionTimeout = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_TIMEOUT, this.lineTcpNetConnectionTimeout);
                this.lineTcpNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_QUEUED_TIMEOUT, 5000L);
                this.lineTcpNetConnectionQueueTimeout = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_QUEUE_TIMEOUT, this.lineTcpNetConnectionQueueTimeout);
                this.lineTcpConnectionPoolInitialCapacity = this.getInt(properties, env, PropertyKey.LINE_TCP_CONNECTION_POOL_CAPACITY, 8);
                this.lineTcpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.LINE_TCP_NET_RECV_BUF_SIZE, -1);
                this.lineTcpNetConnectionRcvBuf = this.getIntSize(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_RCVBUF, this.lineTcpNetConnectionRcvBuf);
                this.lineTcpRecvBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_TCP_MSG_BUFFER_SIZE, 131072);
                this.lineTcpRecvBufferSize = this.getIntSize(properties, env, PropertyKey.LINE_TCP_RECV_BUFFER_SIZE, this.lineTcpRecvBufferSize);
                this.lineTcpMaxMeasurementSize = this.getIntSize(properties, env, PropertyKey.LINE_TCP_MAX_MEASUREMENT_SIZE, 32768);
                if (this.lineTcpMaxMeasurementSize > this.lineTcpRecvBufferSize) {
                    this.lineTcpRecvBufferSize = this.lineTcpMaxMeasurementSize;
                }
                this.lineTcpMaxRecvBufferSize = this.getLongSize(properties, env, PropertyKey.LINE_TCP_MAX_RECV_BUFFER_SIZE, 0x40000000L);
                if ((long)this.lineTcpRecvBufferSize > this.lineTcpMaxRecvBufferSize) {
                    this.lineTcpMaxRecvBufferSize = this.lineTcpRecvBufferSize;
                }
                if (this.lineTcpRecvBufferSize < 513) {
                    throw new ServerConfigurationException("TCP ILP buffer size is too small, should be at least 513, [" + PropertyKey.LINE_TCP_RECV_BUFFER_SIZE.getPropertyPath() + "=" + this.lineTcpRecvBufferSize + "]");
                }
                this.lineTcpWriterQueueCapacity = this.getQueueCapacity(properties, env, PropertyKey.LINE_TCP_WRITER_QUEUE_CAPACITY, 128);
                this.lineTcpWriterWorkerCount = this.getInt(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_COUNT, 0);
                this.lineTcpWriterWorkerAffinity = this.getAffinity(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_AFFINITY, this.lineTcpWriterWorkerCount);
                this.lineTcpWriterWorkerPoolHaltOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_WRITER_HALT_ON_ERROR, false);
                this.lineTcpWriterWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_YIELD_THRESHOLD, 10L);
                this.lineTcpWriterWorkerNapThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_NAP_THRESHOLD, 7000L);
                this.lineTcpWriterWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_WRITER_WORKER_SLEEP_THRESHOLD, 10000L);
                this.symbolCacheWaitBeforeReload = this.getMicros(properties, env, PropertyKey.LINE_TCP_SYMBOL_CACHE_WAIT_BEFORE_RELOAD, 500000L);
                this.lineTcpIOWorkerCount = this.getInt(properties, env, PropertyKey.LINE_TCP_IO_WORKER_COUNT, 0);
                this.lineTcpIOWorkerAffinity = this.getAffinity(properties, env, PropertyKey.LINE_TCP_IO_WORKER_AFFINITY, this.lineTcpIOWorkerCount);
                this.lineTcpIOWorkerPoolHaltOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_IO_HALT_ON_ERROR, false);
                this.lineTcpIOWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_IO_WORKER_YIELD_THRESHOLD, 10L);
                this.lineTcpIOWorkerNapThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_IO_WORKER_NAP_THRESHOLD, 7000L);
                this.lineTcpIOWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.LINE_TCP_IO_WORKER_SLEEP_THRESHOLD, 10000L);
                this.lineTcpMaintenanceInterval = this.getMillis(properties, env, PropertyKey.LINE_TCP_MAINTENANCE_JOB_INTERVAL, 1000L);
                this.lineTcpCommitIntervalFraction = this.getDouble(properties, env, PropertyKey.LINE_TCP_COMMIT_INTERVAL_FRACTION, "0.5");
                this.lineTcpCommitIntervalDefault = this.getMillis(properties, env, PropertyKey.LINE_TCP_COMMIT_INTERVAL_DEFAULT, 2000L);
                if (this.lineTcpCommitIntervalDefault < 1L) {
                    log.info().$("invalid default commit interval ").$(this.lineTcpCommitIntervalDefault).$("), will use ").$(2000L).$();
                    this.lineTcpCommitIntervalDefault = 2000L;
                }
                this.lineTcpAuthDB = this.getString(properties, env, PropertyKey.LINE_TCP_AUTH_DB_PATH, null);
                this.lineLogMessageOnError = this.getBoolean(properties, env, PropertyKey.LINE_LOG_MESSAGE_ON_ERROR, true);
                String defaultTcpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_TCP_DEFAULT_PARTITION_BY, "DAY");
                defaultTcpPartitionByProperty = this.getString(properties, env, PropertyKey.LINE_DEFAULT_PARTITION_BY, defaultTcpPartitionByProperty);
                this.lineTcpDefaultPartitionBy = PartitionBy.fromString(defaultTcpPartitionByProperty);
                if (this.lineTcpDefaultPartitionBy == -1) {
                    log.info().$("invalid partition by ").$safe(defaultTcpPartitionByProperty).$("), will use DAY for TCP").$();
                    this.lineTcpDefaultPartitionBy = 0;
                }
                this.minIdleMsBeforeWriterRelease = this.getMillis(properties, env, PropertyKey.LINE_TCP_MIN_IDLE_MS_BEFORE_WRITER_RELEASE, 500L);
                this.lineTcpDisconnectOnError = this.getBoolean(properties, env, PropertyKey.LINE_TCP_DISCONNECT_ON_ERROR, true);
                long heartbeatInterval = LineTcpReceiverConfigurationHelper.calcCommitInterval(this.o3MinLagUs, this.lineTcpCommitIntervalFraction, this.lineTcpCommitIntervalDefault);
                this.lineTcpNetConnectionHeartbeatInterval = this.getMillis(properties, env, PropertyKey.LINE_TCP_NET_CONNECTION_HEARTBEAT_INTERVAL, heartbeatInterval);
            } else {
                this.lineTcpAuthDB = null;
            }
            this.useLegacyStringDefault = this.getBoolean(properties, env, PropertyKey.CAIRO_LEGACY_STRING_COLUMN_TYPE_DEFAULT, false);
            if (this.lineTcpEnabled || this.lineHttpEnabled && this.httpServerEnabled) {
                LineTimestampAdapter timestampAdapter = this.getLineTimestampAdaptor(properties, env, PropertyKey.LINE_TCP_TIMESTAMP);
                this.lineTcpTimestampAdapter = new LineTcpTimestampAdapter(timestampAdapter);
                this.stringToCharCastAllowed = this.getBoolean(properties, env, PropertyKey.LINE_TCP_UNDOCUMENTED_STRING_TO_CHAR_CAST_ALLOWED, false);
                String floatDefaultColumnTypeName = this.getString(properties, env, PropertyKey.LINE_FLOAT_DEFAULT_COLUMN_TYPE, ColumnType.nameOf(10));
                this.floatDefaultColumnType = ColumnType.tagOf(floatDefaultColumnTypeName);
                if (this.floatDefaultColumnType != 10 && this.floatDefaultColumnType != 9) {
                    log.info().$("invalid default column type for float ").$safe(floatDefaultColumnTypeName).$(", will use DOUBLE").$();
                    this.floatDefaultColumnType = (short)10;
                }
                String integerDefaultColumnTypeName = this.getString(properties, env, PropertyKey.LINE_INTEGER_DEFAULT_COLUMN_TYPE, ColumnType.nameOf(6));
                this.integerDefaultColumnType = ColumnType.tagOf(integerDefaultColumnTypeName);
                if (this.integerDefaultColumnType != 6 && this.integerDefaultColumnType != 5 && this.integerDefaultColumnType != 3 && this.integerDefaultColumnType != 2) {
                    log.info().$("invalid default column type for integer ").$safe(integerDefaultColumnTypeName).$(", will use LONG").$();
                    this.integerDefaultColumnType = (short)6;
                }
            }
            this.ilpAutoCreateNewColumns = this.getBoolean(properties, env, PropertyKey.LINE_AUTO_CREATE_NEW_COLUMNS, true);
            this.ilpAutoCreateNewTables = this.getBoolean(properties, env, PropertyKey.LINE_AUTO_CREATE_NEW_TABLES, true);
            int sharedWorkerCountSett = this.getInt(properties, env, PropertyKey.SHARED_WORKER_COUNT, Math.max(2, cpuAvailable - cpuSpare));
            boolean sharedWorkerHaltOnError = this.getBoolean(properties, env, PropertyKey.SHARED_WORKER_HALT_ON_ERROR, false);
            long sharedWorkerYieldThreshold = this.getLong(properties, env, PropertyKey.SHARED_WORKER_YIELD_THRESHOLD, 10L);
            long sharedWorkerNapThreshold = this.getLong(properties, env, PropertyKey.SHARED_WORKER_NAP_THRESHOLD, 7000L);
            long sharedWorkerSleepThreshold = this.getLong(properties, env, PropertyKey.SHARED_WORKER_SLEEP_THRESHOLD, 10000L);
            long sharedWorkerSleepTimeout = this.getMillis(properties, env, PropertyKey.SHARED_WORKER_SLEEP_TIMEOUT, 10L);
            int networkPoolWorkerCount = this.configureSharedThreadPool(properties, env, this.networkSharedWorkerPoolConfiguration, PropertyKey.SHARED_NETWORK_WORKER_COUNT, PropertyKey.SHARED_NETWORK_WORKER_AFFINITY, sharedWorkerCountSett, 6, sharedWorkerHaltOnError, sharedWorkerYieldThreshold, sharedWorkerNapThreshold, sharedWorkerSleepThreshold, sharedWorkerSleepTimeout);
            int queryWorkers = this.configureSharedThreadPool(properties, env, this.querySharedWorkerPoolConfiguration, PropertyKey.SHARED_QUERY_WORKER_COUNT, PropertyKey.SHARED_QUERY_WORKER_AFFINITY, sharedWorkerCountSett, 5, sharedWorkerHaltOnError, sharedWorkerYieldThreshold, sharedWorkerNapThreshold, sharedWorkerSleepThreshold, sharedWorkerSleepTimeout);
            int writeWorkers = this.configureSharedThreadPool(properties, env, this.writeSharedWorkerPoolConfiguration, PropertyKey.SHARED_WRITE_WORKER_COUNT, PropertyKey.SHARED_WRITE_WORKER_AFFINITY, sharedWorkerCountSett, 4, sharedWorkerHaltOnError, sharedWorkerYieldThreshold, sharedWorkerNapThreshold, sharedWorkerSleepThreshold, sharedWorkerSleepTimeout);
            if (this.pgEnabled) {
                this.pgSelectCacheEnabled = this.getBoolean(properties, env, PropertyKey.PG_SELECT_CACHE_ENABLED, true);
                int effectivePGWorkerCount = this.pgWorkerCount > 0 ? this.pgWorkerCount : networkPoolWorkerCount;
                this.pgSelectCacheBlockCount = this.getInt(properties, env, PropertyKey.PG_SELECT_CACHE_BLOCK_COUNT, 32);
                this.pgSelectCacheRowCount = this.getInt(properties, env, PropertyKey.PG_SELECT_CACHE_ROW_COUNT, Math.max(effectivePGWorkerCount, 4));
            }
            int effectiveHttpWorkerCount = this.httpWorkerCount > 0 ? this.httpWorkerCount : networkPoolWorkerCount;
            this.httpSqlCacheEnabled = this.getBoolean(properties, env, PropertyKey.HTTP_QUERY_CACHE_ENABLED, true);
            this.httpSqlCacheBlockCount = this.getInt(properties, env, PropertyKey.HTTP_QUERY_CACHE_BLOCK_COUNT, 32);
            this.httpSqlCacheRowCount = this.getInt(properties, env, PropertyKey.HTTP_QUERY_CACHE_ROW_COUNT, Math.max(effectiveHttpWorkerCount, 4));
            this.queryCacheEventQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_QUERY_CACHE_EVENT_QUEUE_CAPACITY, 4));
            this.sqlCompilerPoolCapacity = 2 * (this.httpWorkerCount + this.pgWorkerCount + writeWorkers + networkPoolWorkerCount);
            int defaultReduceQueueCapacity = queryWorkers > 0 ? Math.min(2 * queryWorkers, 64) : 0;
            this.cairoPageFrameReduceQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_REDUCE_QUEUE_CAPACITY, defaultReduceQueueCapacity));
            this.cairoGroupByMergeShardQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_MERGE_QUEUE_CAPACITY, defaultReduceQueueCapacity));
            this.cairoGroupByShardingThreshold = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_SHARDING_THRESHOLD, 100000);
            this.cairoGroupByPresizeEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_PRESIZE_ENABLED, true);
            this.cairoGroupByPresizeMaxCapacity = this.getLong(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_PRESIZE_MAX_CAPACITY, 100000000L);
            this.cairoGroupByPresizeMaxHeapSize = this.getLongSize(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_PRESIZE_MAX_HEAP_SIZE, 0x40000000L);
            this.cairoPageFrameReduceRowIdListCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_ROWID_LIST_CAPACITY, 256));
            this.cairoPageFrameReduceColumnListCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_COLUMN_LIST_CAPACITY, 16));
            int defaultReduceShardCount = queryWorkers > 0 ? Math.min(queryWorkers, 4) : 0;
            this.cairoPageFrameReduceShardCount = this.getInt(properties, env, PropertyKey.CAIRO_PAGE_FRAME_SHARD_COUNT, defaultReduceShardCount);
            this.sqlParallelFilterPreTouchEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_FILTER_PRETOUCH_ENABLED, true);
            this.sqlParallelFilterPreTouchThreshold = this.getDouble(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_FILTER_PRETOUCH_THRESHOLD, "0.05");
            this.sqlCopyModelPoolCapacity = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COPY_MODEL_POOL_CAPACITY, 32);
            boolean defaultParallelSqlEnabled = queryWorkers > 0;
            this.sqlParallelFilterEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_FILTER_ENABLED, defaultParallelSqlEnabled);
            this.sqlParallelTopKEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_TOP_K_ENABLED, defaultParallelSqlEnabled);
            this.sqlParallelGroupByEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_GROUPBY_ENABLED, defaultParallelSqlEnabled);
            this.sqlParallelReadParquetEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_READ_PARQUET_ENABLED, defaultParallelSqlEnabled);
            if (!(this.sqlParallelFilterEnabled || this.sqlParallelGroupByEnabled || this.sqlParallelReadParquetEnabled)) {
                this.querySharedWorkerPoolConfiguration.sharedWorkerCount = 0;
            }
            this.walParallelExecutionEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_WAL_APPLY_PARALLEL_SQL_ENABLED, true);
            this.matViewParallelExecutionEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_MAT_VIEW_PARALLEL_SQL_ENABLED, true);
            this.sqlParallelWorkStealingThreshold = this.getInt(properties, env, PropertyKey.CAIRO_SQL_PARALLEL_WORK_STEALING_THRESHOLD, 16);
            this.sqlParquetFrameCacheCapacity = Math.max(this.getInt(properties, env, PropertyKey.CAIRO_SQL_PARQUET_FRAME_CACHE_CAPACITY, 3), 3);
            this.sqlOrderBySortEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_ORDER_BY_SORT_ENABLED, true);
            this.sqlOrderByRadixSortThreshold = this.getInt(properties, env, PropertyKey.CAIRO_SQL_ORDER_BY_RADIX_SORT_THRESHOLD, 600);
            this.writerAsyncCommandBusyWaitTimeout = this.getMillis(properties, env, PropertyKey.CAIRO_WRITER_ALTER_BUSY_WAIT_TIMEOUT, 500L);
            this.writerAsyncCommandMaxWaitTimeout = this.getMillis(properties, env, PropertyKey.CAIRO_WRITER_ALTER_MAX_WAIT_TIMEOUT, 30000L);
            this.writerTickRowsCountMod = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_WRITER_TICK_ROWS_COUNT, 1024)) - 1;
            this.writerAsyncCommandQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, PropertyKey.CAIRO_WRITER_COMMAND_QUEUE_CAPACITY, 32));
            this.writerAsyncCommandQueueSlotSize = Numbers.ceilPow2(this.getLongSize(properties, env, PropertyKey.CAIRO_WRITER_COMMAND_QUEUE_SLOT_SIZE, 2048L));
            this.buildInformation = buildInformation;
            this.binaryEncodingMaxLength = this.getInt(properties, env, PropertyKey.BINARYDATA_ENCODING_MAXLENGTH, 32768);
        }
        this.ilpProtoTransports = this.initIlpTransport();
        this.allowTableRegistrySharedWrite = this.getBoolean(properties, env, PropertyKey.DEBUG_ALLOW_TABLE_REGISTRY_SHARED_WRITE, false);
        this.enableTestFactories = this.getBoolean(properties, env, PropertyKey.DEBUG_ENABLE_TEST_FACTORIES, false);
        this.posthogEnabled = this.getBoolean(properties, env, PropertyKey.POSTHOG_ENABLED, false);
        this.posthogApiKey = this.getString(properties, env, PropertyKey.POSTHOG_API_KEY, null);
        this.configReloadEnabled = this.getBoolean(properties, env, PropertyKey.CONFIG_RELOAD_ENABLED, true);
        this.partitionEncoderParquetVersion = this.getInt(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_VERSION, ParquetVersion.PARQUET_VERSION_V1);
        this.partitionEncoderParquetStatisticsEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_STATISTICS_ENABLED, true);
        this.partitionEncoderParquetRawArrayEncoding = this.getBoolean(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_RAW_ARRAY_ENCODING_ENABLED, false);
        this.partitionEncoderParquetCompressionCodec = this.getInt(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_COMPRESSION_CODEC, ParquetCompression.COMPRESSION_UNCOMPRESSED);
        this.partitionEncoderParquetCompressionLevel = this.getInt(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_COMPRESSION_LEVEL, 0);
        this.partitionEncoderParquetRowGroupSize = this.getInt(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_ROW_GROUP_SIZE, 100000);
        this.partitionEncoderParquetDataPageSize = this.getInt(properties, env, PropertyKey.CAIRO_PARTITION_ENCODER_PARQUET_DATA_PAGE_SIZE, 0x100000);
        this.sqlSampleByValidateFillType = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_SAMPLEBY_VALIDATE_FILL_TYPE, true);
        this.cairoSqlColumnAliasExpressionEnabled = this.getBoolean(properties, env, PropertyKey.CAIRO_SQL_COLUMN_ALIAS_EXPRESSION_ENABLED, true);
        this.cairoSqlColumnAliasGeneratedMaxSize = this.getInt(properties, env, PropertyKey.CAIRO_SQL_COLUMN_ALIAS_GENERATED_MAX_SIZE, 64);
        if (this.cairoSqlColumnAliasGeneratedMaxSize < 4) {
            log.info().$("expected a column alias truncate length superior or equal to ").$(4).$(" but got ").$(this.cairoSqlColumnAliasGeneratedMaxSize).$(". Using ").$(64).$(" instead").$();
            this.cairoSqlColumnAliasGeneratedMaxSize = 64;
        }
    }

    public static String rootSubdir(CharSequence dbRoot, CharSequence subdir) {
        if (dbRoot != null) {
            int len;
            int end = len = dbRoot.length();
            boolean needsSlash = true;
            for (int i = len - 1; i > -1; --i) {
                if (dbRoot.charAt(i) != Files.SEPARATOR || i == len - 1) continue;
                end = i + 1;
                needsSlash = false;
                break;
            }
            StringSink sink = Misc.getThreadLocalSink();
            sink.put(dbRoot, 0, end);
            if (needsSlash) {
                sink.put(Files.SEPARATOR);
            }
            return sink.put(subdir).toString();
        }
        return null;
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfiguration;
    }

    @Override
    public FactoryProvider getFactoryProvider() {
        if (this.factoryProvider == null) {
            throw new IllegalStateException("configuration.init() has not been invoked");
        }
        return this.factoryProvider;
    }

    @Override
    public HttpServerConfiguration getHttpMinServerConfiguration() {
        return this.httpMinServerConfiguration;
    }

    @Override
    public HttpFullFatServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfiguration;
    }

    @Override
    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration() {
        return this.lineTcpReceiverConfiguration;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.lineUdpReceiverConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getMatViewRefreshPoolConfiguration() {
        return this.matViewRefreshPoolConfiguration;
    }

    @Override
    public MemoryConfiguration getMemoryConfiguration() {
        return this.memoryConfiguration;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public MetricsConfiguration getMetricsConfiguration() {
        return this.metricsConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getNetworkWorkerPoolConfiguration() {
        return this.networkSharedWorkerPoolConfiguration;
    }

    @Override
    public PGConfiguration getPGWireConfiguration() {
        return this.pgConfiguration;
    }

    @Override
    public PublicPassthroughConfiguration getPublicPassthroughConfiguration() {
        return this.publicPassthroughConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getQueryWorkerPoolConfiguration() {
        return this.querySharedWorkerPoolConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWalApplyPoolConfiguration() {
        return this.walApplyPoolConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWriteWorkerPoolConfiguration() {
        return this.writeSharedWorkerPoolConfiguration;
    }

    @Override
    public void init(CairoEngine engine, FreeOnExit freeOnExit) {
        this.factoryProvider = this.fpf.getInstance(this, engine, freeOnExit);
    }

    public void init(ServerConfiguration config, CairoEngine engine, FreeOnExit freeOnExit) {
        this.factoryProvider = this.fpf.getInstance(config, engine, freeOnExit);
    }

    public boolean isConfigReloadEnabled() {
        return this.configReloadEnabled;
    }

    public void reinit(FactoryProvider factoryProvider) {
        this.factoryProvider = factoryProvider;
    }

    @NotNull
    private static String stripTrailingSlash(@NotNull String httpContextWebConsole) {
        int n = 0;
        for (int j = httpContextWebConsole.length() - 1; j > -1 && httpContextWebConsole.charAt(j) == '/'; --j) {
            ++n;
        }
        if (n > 0) {
            httpContextWebConsole = httpContextWebConsole.substring(0, httpContextWebConsole.length() - n);
        }
        return httpContextWebConsole;
    }

    private int configureSharedThreadPool(Properties properties, Map<String, String> env, PropWorkerPoolConfiguration poolConfiguration, PropertyKey workerCountProp, PropertyKey affinityProp, int sharedWorkerCount, int priority, boolean sharedWorkerHaltOnError, long sharedWorkerYieldThreshold, long sharedWorkerNapThreshold, long sharedWorkerSleepThreshold, long sharedWorkerSleepTimeout) throws ServerConfigurationException {
        poolConfiguration.sharedWorkerCount = this.getInt(properties, env, workerCountProp, sharedWorkerCount);
        poolConfiguration.sharedWorkerAffinity = this.getAffinity(properties, env, affinityProp, poolConfiguration.sharedWorkerCount);
        poolConfiguration.sharedWorkerHaltOnError = sharedWorkerHaltOnError;
        poolConfiguration.sharedWorkerYieldThreshold = sharedWorkerYieldThreshold;
        poolConfiguration.sharedWorkerNapThreshold = sharedWorkerNapThreshold;
        poolConfiguration.sharedWorkerSleepThreshold = sharedWorkerSleepThreshold;
        poolConfiguration.sharedWorkerSleepTimeout = sharedWorkerSleepTimeout;
        poolConfiguration.metrics = this.metrics;
        poolConfiguration.workerPoolPriority = priority;
        return poolConfiguration.sharedWorkerCount;
    }

    private int[] getAffinity(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, int workerCount) throws ServerConfigurationException {
        int[] result = new int[workerCount];
        String value = this.getString(properties, env, key, null);
        if (value == null) {
            Arrays.fill(result, -1);
        } else {
            String[] affinity = value.split(",");
            if (affinity.length != workerCount) {
                throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "wrong number of affinity values");
            }
            for (int i = 0; i < workerCount; ++i) {
                try {
                    result[i] = Numbers.parseInt(affinity[i]);
                    continue;
                }
                catch (NumericException e) {
                    throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "Invalid affinity value: " + affinity[i]);
                }
            }
        }
        return result;
    }

    private int getCommitMode(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key) {
        String commitMode = this.getString(properties, env, key, "nosync");
        assert (commitMode != null);
        if (Chars.equalsLowerCaseAscii(commitMode, "nosync")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "async")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "sync")) {
            return 1;
        }
        return 2;
    }

    private LineTimestampAdapter getLineTimestampAdaptor(Properties properties, Map<String, String> env, ConfigPropertyKey propNm) {
        String lineUdpTimestampSwitch;
        switch (lineUdpTimestampSwitch = this.getString(properties, env, propNm, "n")) {
            case "u": {
                return LineMicroTimestampAdapter.INSTANCE;
            }
            case "ms": {
                return LineMilliTimestampAdapter.INSTANCE;
            }
            case "s": {
                return LineSecondTimestampAdapter.INSTANCE;
            }
            case "m": {
                return LineMinuteTimestampAdapter.INSTANCE;
            }
            case "h": {
                return LineHourTimestampAdapter.INSTANCE;
            }
        }
        return LineNanoTimestampAdapter.INSTANCE;
    }

    private int getSqlJitMode(Properties properties, @Nullable Map<String, String> env) {
        String jitMode = this.getString(properties, env, PropertyKey.CAIRO_SQL_JIT_MODE, "on");
        assert (jitMode != null);
        if (Chars.equalsLowerCaseAscii(jitMode, "on")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(jitMode, "off")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(jitMode, "scalar")) {
            return 1;
        }
        return 0;
    }

    private DateFormat getTimestampFormat(Properties properties, @Nullable Map<String, String> env) {
        return this.compiler.compile(this.getString(properties, env, PropertyKey.CAIRO_SQL_BACKUP_DIR_DATETIME_FORMAT, "yyyy-MM-dd"));
    }

    private String initIlpTransport() {
        StringSink sink = Misc.getThreadLocalSink();
        sink.put('[');
        boolean addComma = false;
        if (this.lineTcpEnabled) {
            addComma = true;
            sink.put("\"tcp\"");
        }
        if (this.lineHttpEnabled && this.httpServerEnabled) {
            if (addComma) {
                sink.put(", ");
            }
            sink.put("\"http\"");
            addComma = true;
        }
        if (this.lineUdpEnabled) {
            if (addComma) {
                sink.put(", ");
            }
            sink.put("\"udp\"");
        }
        sink.put(']');
        return sink.toString();
    }

    private boolean pathEquals(String p1, String p2) {
        try {
            if (p1 == null || p2 == null) {
                return false;
            }
            return new File(p1).getCanonicalPath().replace(File.separatorChar, '/').equals(new File(p2).getCanonicalPath().replace(File.separatorChar, '/'));
        }
        catch (IOException e) {
            this.log.info().$("Can't validate configuration property [key=").$(PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath()).$(", value=").$(p2).$("]");
            return false;
        }
    }

    private void validateHttpConnectionLimits(int httpJsonQueryConnectionLimit, int httpIlpConnectionLimit, int httpNetConnectionLimit) throws ServerConfigurationException {
        if (httpJsonQueryConnectionLimit > httpNetConnectionLimit) {
            throw new ServerConfigurationException("Json query connection limit cannot be greater than the overall HTTP connection limit [" + PropertyKey.HTTP_JSON_QUERY_CONNECTION_LIMIT.getPropertyPath() + "=" + httpJsonQueryConnectionLimit + ", " + PropertyKey.HTTP_NET_CONNECTION_LIMIT.getPropertyPath() + "=" + httpNetConnectionLimit + "]");
        }
        if (httpIlpConnectionLimit > httpNetConnectionLimit) {
            throw new ServerConfigurationException("HTTP over ILP connection limit cannot be greater than the overall HTTP connection limit [" + PropertyKey.HTTP_ILP_CONNECTION_LIMIT.getPropertyPath() + "=" + httpIlpConnectionLimit + ", " + PropertyKey.HTTP_NET_CONNECTION_LIMIT.getPropertyPath() + "=" + httpNetConnectionLimit + "]");
        }
        if (httpJsonQueryConnectionLimit > -1 && httpIlpConnectionLimit > -1 && httpJsonQueryConnectionLimit + httpIlpConnectionLimit > httpNetConnectionLimit) {
            throw new ServerConfigurationException("The sum of the json query and HTTP over ILP connection limits cannot be greater than the overall HTTP connection limit [" + PropertyKey.HTTP_JSON_QUERY_CONNECTION_LIMIT.getPropertyPath() + "=" + httpJsonQueryConnectionLimit + ", " + PropertyKey.HTTP_ILP_CONNECTION_LIMIT.getPropertyPath() + "=" + httpIlpConnectionLimit + ", " + PropertyKey.HTTP_NET_CONNECTION_LIMIT.getPropertyPath() + "=" + httpNetConnectionLimit + "]");
        }
    }

    private void validateProperties(Properties properties, boolean configValidationStrict) throws ServerConfigurationException {
        ValidationResult validation = this.validator.validate(properties);
        if (validation != null) {
            if (validation.isError && configValidationStrict) {
                throw new ServerConfigurationException(validation.message);
            }
            this.log.advisory().$(validation.message).$();
        }
    }

    protected boolean getBoolean(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getString(properties, env, key, Boolean.toString(defaultValue)));
    }

    String getCanonicalPath(String path) throws ServerConfigurationException {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ServerConfigurationException("Cannot calculate canonical path for configuration property [key=" + PropertyKey.CAIRO_SQL_COPY_WORK_ROOT.getPropertyPath() + ",value=" + path + "]");
        }
    }

    protected double getDouble(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, String defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, defaultValue);
        try {
            return Numbers.parseDouble(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getIPv4Address(Properties properties, Map<String, String> env, ConfigPropertyKey key, String defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, defaultValue);
        try {
            return Net.parseIPv4(value);
        }
        catch (NetworkError e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getInt(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, int defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Integer.toString(defaultValue));
        try {
            return Numbers.parseInt(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getIntPercentage(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, int defaultValue) throws ServerConfigurationException {
        int percentage = this.getInt(properties, env, key, defaultValue);
        if (percentage < 0 || percentage > 100) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), Integer.toString(percentage));
        }
        return percentage;
    }

    protected int getIntSize(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, int defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Integer.toString(defaultValue));
        try {
            return Numbers.parseIntSize(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected long getLong(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Long.toString(defaultValue));
        try {
            return Numbers.parseLong(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected long getLongSize(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Long.toString(defaultValue));
        try {
            return Numbers.parseLongSize(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected long getMicros(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Long.toString(defaultValue));
        try {
            return Numbers.parseMicros(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected long getMillis(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Long.toString(defaultValue));
        try {
            return Numbers.parseMillis(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected long getNanos(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, long defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, Long.toString(defaultValue));
        try {
            return Numbers.parseNanos(value);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), value);
        }
    }

    protected int getQueueCapacity(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, int defaultValue) throws ServerConfigurationException {
        int value = this.getInt(properties, env, key, defaultValue);
        if (!Numbers.isPow2(value)) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "Value must be power of 2, e.g. 1,2,4,8,16,32,64...");
        }
        return value;
    }

    protected String getString(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, String defaultValue) {
        int valueSource;
        String result;
        String envCandidate = key.getEnvVarName();
        String string = result = env != null ? env.get(envCandidate) : null;
        if (result != null) {
            this.log.info().$("env config [key=").$(envCandidate).I$();
            valueSource = 2;
        } else {
            result = properties.getProperty(key.getPropertyPath());
            if (result == null) {
                result = defaultValue;
                valueSource = 0;
            } else {
                valueSource = 1;
            }
        }
        String string2 = result = result != null ? result.trim() : null;
        if (!key.isDebug()) {
            boolean dynamic = this.dynamicProperties != null && this.dynamicProperties.contains(key);
            this.allPairs.put(key, new ConfigPropertyValueImpl(result, valueSource, dynamic));
        }
        return result;
    }

    protected void getUrls(Properties properties, @Nullable Map<String, String> env, ConfigPropertyKey key, ObjList<String> target, String ... defaultValue) throws ServerConfigurationException {
        int valueSource;
        String unparsedResult;
        String envCandidate = key.getEnvVarName();
        String string = unparsedResult = env != null ? env.get(envCandidate) : null;
        if (unparsedResult != null) {
            this.log.info().$("env config [key=").$(envCandidate).I$();
            valueSource = 2;
        } else {
            unparsedResult = properties.getProperty(key.getPropertyPath());
            valueSource = unparsedResult == null ? 0 : 1;
        }
        String[] parts = valueSource == 0 ? defaultValue : unparsedResult.split(",");
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            String url = parts[i].trim();
            if (url.isEmpty()) {
                throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), "empty URL in the list");
            }
            target.add(PropServerConfiguration.stripTrailingSlash(url));
        }
        String string2 = unparsedResult = unparsedResult != null ? unparsedResult.trim() : null;
        if (!key.isDebug()) {
            boolean dynamic = this.dynamicProperties != null && this.dynamicProperties.contains(key);
            this.allPairs.put(key, new ConfigPropertyValueImpl(unparsedResult, valueSource, dynamic));
        }
    }

    protected PropertyValidator newValidator() {
        return new PropertyValidator();
    }

    protected void parseBindTo(Properties properties, Map<String, String> env, ConfigPropertyKey key, String defaultValue, BindToParser parser) throws ServerConfigurationException {
        int port;
        int ipv4;
        String bindTo = this.getString(properties, env, key, defaultValue);
        int colonIndex = bindTo.indexOf(58);
        if (colonIndex == -1) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), bindTo);
        }
        String ipv4Str = bindTo.substring(0, colonIndex);
        try {
            ipv4 = Net.parseIPv4(ipv4Str);
        }
        catch (NetworkError e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), ipv4Str);
        }
        String portStr = bindTo.substring(colonIndex + 1);
        try {
            port = Numbers.parseInt(portStr);
        }
        catch (NumericException e) {
            throw ServerConfigurationException.forInvalidKey(key.getPropertyPath(), portStr);
        }
        parser.onReady(ipv4, port);
    }

    static {
        WRITE_FO_OPTS.put("o_direct", 16384);
        WRITE_FO_OPTS.put("o_sync", 128);
        WRITE_FO_OPTS.put("o_async", 64);
        WRITE_FO_OPTS.put("o_none", 0);
    }

    class PropCairoConfiguration
    implements CairoConfiguration {
        private final LongSupplier randomIDSupplier = () -> this.getRandom().nextPositiveLong();
        private final LongSupplier sequentialIDSupplier = new LongSupplier(){
            final AtomicLong value = new AtomicLong();

            @Override
            public long getAsLong() {
                return this.value.incrementAndGet();
            }
        };

        PropCairoConfiguration() {
        }

        @Override
        public boolean attachPartitionCopy() {
            return PropServerConfiguration.this.cairoAttachPartitionCopy;
        }

        @Override
        public boolean enableTestFactories() {
            return PropServerConfiguration.this.enableTestFactories;
        }

        @Override
        public boolean exportConfiguration(CharSink<?> sink) {
            String releaseType = PropServerConfiguration.this.getReleaseType();
            JsonPropertyValueFormatter.str(PropServerConfiguration.RELEASE_TYPE, releaseType, sink);
            JsonPropertyValueFormatter.str(PropServerConfiguration.RELEASE_VERSION, this.getBuildInformation().getSwVersion(), sink);
            if (Chars.equalsNc((CharSequence)releaseType, "OSS")) {
                JsonPropertyValueFormatter.bool(PropertyKey.HTTP_SETTINGS_READONLY.getPropertyPath(), PropServerConfiguration.this.httpSettingsReadOnly, sink);
            }
            if (!Chars.empty(PropServerConfiguration.this.httpUsername)) {
                JsonPropertyValueFormatter.bool(PropServerConfiguration.ACL_ENABLED, true, sink);
            }
            JsonPropertyValueFormatter.arrayStr(PropServerConfiguration.ILP_PROTO_SUPPORT_VERSIONS_NAME, PropServerConfiguration.ILP_PROTO_SUPPORT_VERSIONS, sink);
            JsonPropertyValueFormatter.arrayStr(PropServerConfiguration.ILP_PROTO_TRANSPORTS, PropServerConfiguration.this.ilpProtoTransports, sink);
            return true;
        }

        @Override
        @Nullable
        public ObjObjHashMap<ConfigPropertyKey, ConfigPropertyValue> getAllPairs() {
            return PropServerConfiguration.this.allPairs;
        }

        @Override
        public boolean getAllowTableRegistrySharedWrite() {
            return PropServerConfiguration.this.allowTableRegistrySharedWrite;
        }

        @Override
        @NotNull
        public String getAttachPartitionSuffix() {
            return PropServerConfiguration.this.cairoAttachPartitionSuffix;
        }

        @Override
        public DateFormat getBackupDirTimestampFormat() {
            return PropServerConfiguration.this.backupDirTimestampFormat;
        }

        @Override
        public int getBackupMkDirMode() {
            return PropServerConfiguration.this.backupMkdirMode;
        }

        @Override
        public CharSequence getBackupRoot() {
            return PropServerConfiguration.this.backupRoot;
        }

        @Override
        @NotNull
        public CharSequence getBackupTempDirName() {
            return PropServerConfiguration.this.backupTempDirName;
        }

        @Override
        public int getBinaryEncodingMaxLength() {
            return PropServerConfiguration.this.binaryEncodingMaxLength;
        }

        @Override
        public int getBindVariablePoolSize() {
            return PropServerConfiguration.this.sqlBindVariablePoolSize;
        }

        @Override
        @NotNull
        public BuildInformation getBuildInformation() {
            return PropServerConfiguration.this.buildInformation;
        }

        @Override
        public boolean getCairoSqlLegacyOperatorPrecedence() {
            return PropServerConfiguration.this.cairoSqlLegacyOperatorPrecedence;
        }

        @Override
        @NotNull
        public CharSequence getCheckpointRoot() {
            return PropServerConfiguration.this.checkpointRoot;
        }

        @Override
        @NotNull
        public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
            return PropServerConfiguration.this.circuitBreakerConfiguration;
        }

        @Override
        public int getColumnAliasGeneratedMaxSize() {
            return PropServerConfiguration.this.cairoSqlColumnAliasGeneratedMaxSize;
        }

        @Override
        public int getColumnIndexerQueueCapacity() {
            return PropServerConfiguration.this.columnIndexerQueueCapacity;
        }

        @Override
        public int getColumnPurgeQueueCapacity() {
            return PropServerConfiguration.this.columnPurgeQueueCapacity;
        }

        @Override
        public long getColumnPurgeRetryDelay() {
            return PropServerConfiguration.this.columnPurgeRetryDelay;
        }

        @Override
        public long getColumnPurgeRetryDelayLimit() {
            return PropServerConfiguration.this.columnPurgeRetryDelayLimit;
        }

        @Override
        public double getColumnPurgeRetryDelayMultiplier() {
            return PropServerConfiguration.this.columnPurgeRetryDelayMultiplier;
        }

        @Override
        public int getColumnPurgeTaskPoolCapacity() {
            return PropServerConfiguration.this.columnPurgeTaskPoolCapacity;
        }

        @Override
        public long getCommitLatency() {
            return PropServerConfiguration.this.cairoCommitLatency;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.commitMode;
        }

        @Override
        @NotNull
        public CharSequence getConfRoot() {
            return PropServerConfiguration.this.confRoot;
        }

        @Override
        @NotNull
        public LongSupplier getCopyIDSupplier() {
            if (PropServerConfiguration.this.cairoSQLCopyIdSupplier == 0) {
                return this.randomIDSupplier;
            }
            return this.sequentialIDSupplier;
        }

        @Override
        public int getCopyPoolCapacity() {
            return PropServerConfiguration.this.sqlCopyModelPoolCapacity;
        }

        @Override
        public int getCountDistinctCapacity() {
            return PropServerConfiguration.this.sqlCountDistinctCapacity;
        }

        @Override
        public double getCountDistinctLoadFactor() {
            return PropServerConfiguration.this.sqlCountDistinctLoadFactor;
        }

        @Override
        public int getCreateAsSelectRetryCount() {
            return PropServerConfiguration.this.createAsSelectRetryCount;
        }

        @Override
        public int getCreateTableColumnModelPoolCapacity() {
            return PropServerConfiguration.this.sqlCreateTableColumnModelPoolCapacity;
        }

        @Override
        public long getCreateTableModelBatchSize() {
            return PropServerConfiguration.this.sqlCreateTableModelBatchSize;
        }

        @Override
        public long getDataAppendPageSize() {
            return PropServerConfiguration.this.writerDataAppendPageSize;
        }

        @Override
        public long getDataIndexKeyAppendPageSize() {
            return PropServerConfiguration.this.writerDataIndexKeyAppendPageSize;
        }

        @Override
        public long getDataIndexValueAppendPageSize() {
            return PropServerConfiguration.this.writerDataIndexValueAppendPageSize;
        }

        @Override
        public long getDatabaseIdHi() {
            return PropServerConfiguration.this.instanceHashHi;
        }

        @Override
        public long getDatabaseIdLo() {
            return PropServerConfiguration.this.instanceHashLo;
        }

        @Override
        @NotNull
        public CharSequence getDbDirectory() {
            return PropServerConfiguration.this.dbDirectory;
        }

        @Override
        @NotNull
        public String getDbRoot() {
            return PropServerConfiguration.this.dbRoot;
        }

        @Override
        public boolean getDebugWalApplyBlockFailureNoRetry() {
            return PropServerConfiguration.this.debugWalApplyBlockFailureNoRetry;
        }

        @Override
        @NotNull
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }

        @Override
        public int getDefaultSeqPartTxnCount() {
            return PropServerConfiguration.this.defaultSeqPartTxnCount;
        }

        @Override
        public boolean getDefaultSymbolCacheFlag() {
            return PropServerConfiguration.this.defaultSymbolCacheFlag;
        }

        @Override
        public int getDefaultSymbolCapacity() {
            return PropServerConfiguration.this.defaultSymbolCapacity;
        }

        @Override
        public int getDetachedMkDirMode() {
            return PropServerConfiguration.this.detachedMkdirMode;
        }

        @Override
        public int getExplainPoolCapacity() {
            return PropServerConfiguration.this.sqlExplainModelPoolCapacity;
        }

        @Override
        @NotNull
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public boolean getFileDescriptorCacheEnabled() {
            return PropServerConfiguration.this.fileDescriptorCacheEnabled;
        }

        @Override
        public int getFileOperationRetryCount() {
            return PropServerConfiguration.this.fileOperationRetryCount;
        }

        @Override
        @NotNull
        public FilesFacade getFilesFacade() {
            return PropServerConfiguration.this.filesFacade;
        }

        @Override
        public long getGroupByAllocatorDefaultChunkSize() {
            return PropServerConfiguration.this.sqlGroupByAllocatorChunkSize;
        }

        @Override
        public long getGroupByAllocatorMaxChunkSize() {
            return PropServerConfiguration.this.sqlGroupByAllocatorMaxChunkSize;
        }

        @Override
        public int getGroupByMapCapacity() {
            return PropServerConfiguration.this.sqlGroupByMapCapacity;
        }

        @Override
        public int getGroupByMergeShardQueueCapacity() {
            return PropServerConfiguration.this.cairoGroupByMergeShardQueueCapacity;
        }

        @Override
        public int getGroupByPoolCapacity() {
            return PropServerConfiguration.this.sqlGroupByPoolCapacity;
        }

        @Override
        public long getGroupByPresizeMaxCapacity() {
            return PropServerConfiguration.this.cairoGroupByPresizeMaxCapacity;
        }

        @Override
        public long getGroupByPresizeMaxHeapSize() {
            return PropServerConfiguration.this.cairoGroupByPresizeMaxHeapSize;
        }

        @Override
        public int getGroupByShardingThreshold() {
            return PropServerConfiguration.this.cairoGroupByShardingThreshold;
        }

        @Override
        public int getIdGenerateBatchStep() {
            return PropServerConfiguration.this.idGenerateBatchStep;
        }

        @Override
        public long getIdleCheckInterval() {
            return PropServerConfiguration.this.idleCheckInterval;
        }

        @Override
        public int getInactiveReaderMaxOpenPartitions() {
            return PropServerConfiguration.this.inactiveReaderMaxOpenPartitions;
        }

        @Override
        public long getInactiveReaderTTL() {
            return PropServerConfiguration.this.inactiveReaderTTL;
        }

        @Override
        public long getInactiveWalWriterTTL() {
            return PropServerConfiguration.this.inactiveWalWriterTTL;
        }

        @Override
        public long getInactiveWriterTTL() {
            return PropServerConfiguration.this.inactiveWriterTTL;
        }

        @Override
        public int getIndexValueBlockSize() {
            return PropServerConfiguration.this.indexValueBlockSize;
        }

        @Override
        public long getInsertModelBatchSize() {
            return PropServerConfiguration.this.sqlInsertModelBatchSize;
        }

        @Override
        public int getInsertModelPoolCapacity() {
            return PropServerConfiguration.this.sqlInsertModelPoolCapacity;
        }

        @Override
        @NotNull
        public String getInstallRoot() {
            return PropServerConfiguration.this.installRoot;
        }

        @Override
        public int getLatestByQueueCapacity() {
            return PropServerConfiguration.this.latestByQueueCapacity;
        }

        @Override
        @NotNull
        public CharSequence getLegacyCheckpointRoot() {
            return PropServerConfiguration.this.legacyCheckpointRoot;
        }

        @Override
        public boolean getLogLevelVerbose() {
            return PropServerConfiguration.this.logLevelVerbose;
        }

        @Override
        public boolean getLogSqlQueryProgressExe() {
            return PropServerConfiguration.this.logSqlQueryProgressExe;
        }

        @Override
        public DateFormat getLogTimestampFormat() {
            return PropServerConfiguration.this.logTimestampFormat;
        }

        @Override
        @Nullable
        public String getLogTimestampTimezone() {
            return PropServerConfiguration.this.logTimestampTimezone;
        }

        @Override
        public DateLocale getLogTimestampTimezoneLocale() {
            return PropServerConfiguration.this.logTimestampLocale;
        }

        @Override
        public TimeZoneRules getLogTimestampTimezoneRules() {
            return PropServerConfiguration.this.logTimestampTimezoneRules;
        }

        @Override
        public long getMatViewInsertAsSelectBatchSize() {
            return PropServerConfiguration.this.matViewInsertAsSelectBatchSize;
        }

        @Override
        public int getMatViewMaxRefreshIntervals() {
            return PropServerConfiguration.this.matViewMaxRefreshIntervals;
        }

        @Override
        public int getMatViewMaxRefreshRetries() {
            return PropServerConfiguration.this.matViewMaxRefreshRetries;
        }

        @Override
        public long getMatViewRefreshIntervalsUpdatePeriod() {
            return PropServerConfiguration.this.matViewRefreshIntervalsUpdatePeriod;
        }

        @Override
        public long getMatViewRefreshOomRetryTimeout() {
            return PropServerConfiguration.this.matViewRefreshOomRetryTimeout;
        }

        @Override
        public int getMatViewRowsPerQueryEstimate() {
            return PropServerConfiguration.this.matViewRowsPerQueryEstimate;
        }

        @Override
        public int getMaxCrashFiles() {
            return PropServerConfiguration.this.cairoMaxCrashFiles;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMaxSqlRecompileAttempts() {
            return PropServerConfiguration.this.maxSqlRecompileAttempts;
        }

        @Override
        public int getMaxSwapFileCount() {
            return PropServerConfiguration.this.maxSwapFileCount;
        }

        @Override
        public int getMaxSymbolNotEqualsCount() {
            return PropServerConfiguration.this.sqlMaxSymbolNotEqualsCount;
        }

        @Override
        public int getMaxUncommittedRows() {
            return PropServerConfiguration.this.maxUncommittedRows;
        }

        @Override
        public int getMetadataPoolCapacity() {
            return PropServerConfiguration.this.sqlModelPoolCapacity;
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        @NotNull
        public MicrosecondClock getMicrosecondClock() {
            return PropServerConfiguration.this.microsecondClock;
        }

        @Override
        public long getMiscAppendPageSize() {
            return PropServerConfiguration.this.writerMiscAppendPageSize;
        }

        @Override
        public int getMkDirMode() {
            return PropServerConfiguration.this.mkdirMode;
        }

        @Override
        public int getO3CallbackQueueCapacity() {
            return PropServerConfiguration.this.o3CallbackQueueCapacity;
        }

        @Override
        public int getO3ColumnMemorySize() {
            return PropServerConfiguration.this.o3ColumnMemorySize;
        }

        @Override
        public int getO3CopyQueueCapacity() {
            return PropServerConfiguration.this.o3CopyQueueCapacity;
        }

        @Override
        public int getO3LagCalculationWindowsSize() {
            return PropServerConfiguration.this.o3LagCalculationWindowsSize;
        }

        @Override
        public int getO3LastPartitionMaxSplits() {
            return PropServerConfiguration.this.o3LastPartitionMaxSplits;
        }

        @Override
        public long getO3MaxLag() {
            return PropServerConfiguration.this.o3MaxLagUs;
        }

        @Override
        public int getO3MemMaxPages() {
            return Integer.MAX_VALUE;
        }

        @Override
        public long getO3MinLag() {
            return PropServerConfiguration.this.o3MinLagUs;
        }

        @Override
        public int getO3OpenColumnQueueCapacity() {
            return PropServerConfiguration.this.o3OpenColumnQueueCapacity;
        }

        @Override
        public int getO3PartitionQueueCapacity() {
            return PropServerConfiguration.this.o3PartitionQueueCapacity;
        }

        @Override
        public int getO3PurgeDiscoveryQueueCapacity() {
            return PropServerConfiguration.this.o3PurgeDiscoveryQueueCapacity;
        }

        @Override
        public int getPageFrameReduceColumnListCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceColumnListCapacity;
        }

        @Override
        public int getPageFrameReduceQueueCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceQueueCapacity;
        }

        @Override
        public int getPageFrameReduceRowIdListCapacity() {
            return PropServerConfiguration.this.cairoPageFrameReduceRowIdListCapacity;
        }

        @Override
        public int getPageFrameReduceShardCount() {
            return PropServerConfiguration.this.cairoPageFrameReduceShardCount;
        }

        @Override
        public int getParallelIndexThreshold() {
            return PropServerConfiguration.this.parallelIndexThreshold;
        }

        @Override
        public int getPartitionEncoderParquetCompressionCodec() {
            return PropServerConfiguration.this.partitionEncoderParquetCompressionCodec;
        }

        @Override
        public int getPartitionEncoderParquetCompressionLevel() {
            return PropServerConfiguration.this.partitionEncoderParquetCompressionLevel;
        }

        @Override
        public int getPartitionEncoderParquetDataPageSize() {
            return PropServerConfiguration.this.partitionEncoderParquetDataPageSize;
        }

        @Override
        public int getPartitionEncoderParquetRowGroupSize() {
            return PropServerConfiguration.this.partitionEncoderParquetRowGroupSize;
        }

        @Override
        public int getPartitionEncoderParquetVersion() {
            return PropServerConfiguration.this.partitionEncoderParquetVersion;
        }

        @Override
        public long getPartitionO3SplitMinSize() {
            return PropServerConfiguration.this.o3PartitionSplitMinSize;
        }

        @Override
        public int getPartitionPurgeListCapacity() {
            return PropServerConfiguration.this.o3PartitionPurgeListCapacity;
        }

        @Override
        public int getPreferencesStringPoolCapacity() {
            return PropServerConfiguration.this.preferencesStringPoolCapacity;
        }

        @Override
        public int getQueryCacheEventQueueCapacity() {
            return PropServerConfiguration.this.queryCacheEventQueueCapacity;
        }

        @Override
        public int getQueryRegistryPoolSize() {
            return PropServerConfiguration.this.sqlQueryRegistryPoolSize;
        }

        @Override
        public int getReaderPoolMaxSegments() {
            return PropServerConfiguration.this.readerPoolMaxSegments;
        }

        @Override
        public int getRenameTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlRenameTableModelPoolCapacity;
        }

        @Override
        public int getRepeatMigrationsFromVersion() {
            return PropServerConfiguration.this.repeatMigrationFromVersion;
        }

        @Override
        public int getRndFunctionMemoryMaxPages() {
            return PropServerConfiguration.this.rndFunctionMemoryMaxPages;
        }

        @Override
        public int getRndFunctionMemoryPageSize() {
            return PropServerConfiguration.this.rndFunctionMemoryPageSize;
        }

        @Override
        public boolean getSampleByDefaultAlignmentCalendar() {
            return PropServerConfiguration.this.sqlSampleByDefaultAlignment;
        }

        @Override
        public int getSampleByIndexSearchPageSize() {
            return PropServerConfiguration.this.sqlSampleByIndexSearchPageSize;
        }

        @Override
        public int getScoreboardFormat() {
            return PropServerConfiguration.this.cairoTxnScoreboardFormat;
        }

        @Override
        public long getSequencerCheckInterval() {
            return PropServerConfiguration.this.sequencerCheckInterval;
        }

        @Override
        @NotNull
        public CharSequence getSnapshotInstanceId() {
            return PropServerConfiguration.this.snapshotInstanceId;
        }

        @Override
        public long getSpinLockTimeout() {
            return PropServerConfiguration.this.spinLockTimeout;
        }

        @Override
        public int getSqlAsOfJoinLookAhead() {
            return PropServerConfiguration.this.sqlAsOfJoinLookahead;
        }

        @Override
        public int getSqlAsOfJoinMapEvacuationThreshold() {
            return PropServerConfiguration.this.sqlAsOfJoinEvacuationThreshold;
        }

        @Override
        public int getSqlAsOfJoinShortCircuitCacheCapacity() {
            return PropServerConfiguration.this.sqlAsOfJoinShortCircuitCacheCapacity;
        }

        @Override
        public int getSqlCharacterStoreCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreCapacity;
        }

        @Override
        public int getSqlCharacterStoreSequencePoolCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreSequencePoolCapacity;
        }

        @Override
        public int getSqlColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnPoolCapacity;
        }

        @Override
        public int getSqlCompilerPoolCapacity() {
            return PropServerConfiguration.this.sqlCompilerPoolCapacity;
        }

        @Override
        public int getSqlCopyBufferSize() {
            return PropServerConfiguration.this.sqlCopyBufferSize;
        }

        @Override
        public CharSequence getSqlCopyInputRoot() {
            return PropServerConfiguration.this.cairoSqlCopyRoot;
        }

        @Override
        public CharSequence getSqlCopyInputWorkRoot() {
            return PropServerConfiguration.this.cairoSqlCopyWorkRoot;
        }

        @Override
        public int getSqlCopyLogRetentionDays() {
            return PropServerConfiguration.this.cairoSqlCopyLogRetentionDays;
        }

        @Override
        public long getSqlCopyMaxIndexChunkSize() {
            return PropServerConfiguration.this.cairoSqlCopyMaxIndexChunkSize;
        }

        @Override
        public int getSqlCopyQueueCapacity() {
            return PropServerConfiguration.this.cairoSqlCopyQueueCapacity;
        }

        @Override
        public int getSqlDistinctTimestampKeyCapacity() {
            return PropServerConfiguration.this.sqlDistinctTimestampKeyCapacity;
        }

        @Override
        public double getSqlDistinctTimestampLoadFactor() {
            return PropServerConfiguration.this.sqlDistinctTimestampLoadFactor;
        }

        @Override
        public int getSqlExpressionPoolCapacity() {
            return PropServerConfiguration.this.sqlExpressionPoolCapacity;
        }

        @Override
        public double getSqlFastMapLoadFactor() {
            return PropServerConfiguration.this.sqlFastMapLoadFactor;
        }

        @Override
        public int getSqlHashJoinLightValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinLightValueMaxPages;
        }

        @Override
        public int getSqlHashJoinLightValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinLightValuePageSize;
        }

        @Override
        public int getSqlHashJoinValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinValueMaxPages;
        }

        @Override
        public int getSqlHashJoinValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinValuePageSize;
        }

        @Override
        public int getSqlJitBindVarsMemoryMaxPages() {
            return PropServerConfiguration.this.sqlJitBindVarsMemoryMaxPages;
        }

        @Override
        public int getSqlJitBindVarsMemoryPageSize() {
            return PropServerConfiguration.this.sqlJitBindVarsMemoryPageSize;
        }

        @Override
        public int getSqlJitIRMemoryMaxPages() {
            return PropServerConfiguration.this.sqlJitIRMemoryMaxPages;
        }

        @Override
        public int getSqlJitIRMemoryPageSize() {
            return PropServerConfiguration.this.sqlJitIRMemoryPageSize;
        }

        @Override
        public int getSqlJitMode() {
            return PropServerConfiguration.this.sqlJitMode;
        }

        @Override
        public int getSqlJitPageAddressCacheThreshold() {
            return PropServerConfiguration.this.sqlJitPageAddressCacheThreshold;
        }

        @Override
        public int getSqlJoinContextPoolCapacity() {
            return PropServerConfiguration.this.sqlJoinContextPoolCapacity;
        }

        @Override
        public int getSqlJoinMetadataMaxResizes() {
            return PropServerConfiguration.this.sqlJoinMetadataMaxResizes;
        }

        @Override
        public int getSqlJoinMetadataPageSize() {
            return PropServerConfiguration.this.sqlJoinMetadataPageSize;
        }

        @Override
        public long getSqlLatestByRowCount() {
            return PropServerConfiguration.this.sqlLatestByRowCount;
        }

        @Override
        public int getSqlLexerPoolCapacity() {
            return PropServerConfiguration.this.sqlLexerPoolCapacity;
        }

        @Override
        public int getSqlMapMaxPages() {
            return PropServerConfiguration.this.sqlMapMaxPages;
        }

        @Override
        public int getSqlMapMaxResizes() {
            return PropServerConfiguration.this.sqlMapMaxResizes;
        }

        @Override
        public int getSqlMaxNegativeLimit() {
            return PropServerConfiguration.this.sqlMaxNegativeLimit;
        }

        @Override
        public int getSqlModelPoolCapacity() {
            return PropServerConfiguration.this.sqlModelPoolCapacity;
        }

        @Override
        public int getSqlOrderByRadixSortThreshold() {
            return PropServerConfiguration.this.sqlOrderByRadixSortThreshold;
        }

        @Override
        public int getSqlPageFrameMaxRows() {
            return PropServerConfiguration.this.sqlPageFrameMaxRows;
        }

        @Override
        public int getSqlPageFrameMinRows() {
            return PropServerConfiguration.this.sqlPageFrameMinRows;
        }

        @Override
        public double getSqlParallelFilterPreTouchThreshold() {
            return PropServerConfiguration.this.sqlParallelFilterPreTouchThreshold;
        }

        @Override
        public int getSqlParallelWorkStealingThreshold() {
            return PropServerConfiguration.this.sqlParallelWorkStealingThreshold;
        }

        @Override
        public int getSqlParquetFrameCacheCapacity() {
            return PropServerConfiguration.this.sqlParquetFrameCacheCapacity;
        }

        @Override
        public int getSqlSmallMapKeyCapacity() {
            return PropServerConfiguration.this.sqlSmallMapKeyCapacity;
        }

        @Override
        public long getSqlSmallMapPageSize() {
            return PropServerConfiguration.this.sqlSmallMapPageSize;
        }

        @Override
        public int getSqlSortKeyMaxPages() {
            return PropServerConfiguration.this.sqlSortKeyMaxPages;
        }

        @Override
        public long getSqlSortKeyPageSize() {
            return PropServerConfiguration.this.sqlSortKeyPageSize;
        }

        @Override
        public int getSqlSortLightValueMaxPages() {
            return PropServerConfiguration.this.sqlSortLightValueMaxPages;
        }

        @Override
        public long getSqlSortLightValuePageSize() {
            return PropServerConfiguration.this.sqlSortLightValuePageSize;
        }

        @Override
        public int getSqlSortValueMaxPages() {
            return PropServerConfiguration.this.sqlSortValueMaxPages;
        }

        @Override
        public int getSqlSortValuePageSize() {
            return PropServerConfiguration.this.sqlSortValuePageSize;
        }

        @Override
        public int getSqlUnorderedMapMaxEntrySize() {
            return PropServerConfiguration.this.sqlUnorderedMapMaxEntrySize;
        }

        @Override
        public int getSqlWindowInitialRangeBufferSize() {
            return PropServerConfiguration.this.sqlWindowInitialRangeBufferSize;
        }

        @Override
        public int getSqlWindowMaxRecursion() {
            return PropServerConfiguration.this.sqlWindowMaxRecursion;
        }

        @Override
        public int getSqlWindowRowIdMaxPages() {
            return PropServerConfiguration.this.sqlWindowRowIdMaxPages;
        }

        @Override
        public int getSqlWindowRowIdPageSize() {
            return PropServerConfiguration.this.sqlWindowRowIdPageSize;
        }

        @Override
        public int getSqlWindowStoreMaxPages() {
            return PropServerConfiguration.this.sqlWindowStoreMaxPages;
        }

        @Override
        public int getSqlWindowStorePageSize() {
            return PropServerConfiguration.this.sqlWindowStorePageSize;
        }

        @Override
        public int getSqlWindowTreeKeyMaxPages() {
            return PropServerConfiguration.this.sqlWindowTreeKeyMaxPages;
        }

        @Override
        public int getSqlWindowTreeKeyPageSize() {
            return PropServerConfiguration.this.sqlWindowTreeKeyPageSize;
        }

        @Override
        public int getStrFunctionMaxBufferLength() {
            return PropServerConfiguration.this.sqlStrFunctionBufferMaxSize;
        }

        @Override
        public long getSymbolTableAppendPageSize() {
            return PropServerConfiguration.this.symbolTableAppendPageSize;
        }

        @Override
        public long getSystemDataAppendPageSize() {
            return PropServerConfiguration.this.systemWriterDataAppendPageSize;
        }

        @Override
        public int getSystemO3ColumnMemorySize() {
            return PropServerConfiguration.this.systemO3ColumnMemorySize;
        }

        @Override
        @NotNull
        public CharSequence getSystemTableNamePrefix() {
            return PropServerConfiguration.this.systemTableNamePrefix;
        }

        @Override
        public long getSystemWalDataAppendPageSize() {
            return PropServerConfiguration.this.systemWalWriterDataAppendPageSize;
        }

        @Override
        public long getSystemWalEventAppendPageSize() {
            return PropServerConfiguration.this.systemWalWriterEventAppendPageSize;
        }

        @Override
        public long getTableRegistryAutoReloadFrequency() {
            return PropServerConfiguration.this.cairoTableRegistryAutoReloadFrequency;
        }

        @Override
        public int getTableRegistryCompactionThreshold() {
            return PropServerConfiguration.this.cairoTableRegistryCompactionThreshold;
        }

        @Override
        @NotNull
        public TelemetryConfiguration getTelemetryConfiguration() {
            return PropServerConfiguration.this.telemetryConfiguration;
        }

        @Override
        public CharSequence getTempRenamePendingTablePrefix() {
            return PropServerConfiguration.this.tempRenamePendingTablePrefix;
        }

        @Override
        @NotNull
        public TextConfiguration getTextConfiguration() {
            return PropServerConfiguration.this.textConfiguration;
        }

        @Override
        public int getTxnScoreboardEntryCount() {
            return PropServerConfiguration.this.sqlTxnScoreboardEntryCount;
        }

        @Override
        public int getVectorAggregateQueueCapacity() {
            return PropServerConfiguration.this.vectorAggregateQueueCapacity;
        }

        @Override
        @NotNull
        public VolumeDefinitions getVolumeDefinitions() {
            return PropServerConfiguration.this.volumeDefinitions;
        }

        @Override
        public int getWalApplyLookAheadTransactionCount() {
            return PropServerConfiguration.this.walApplyLookAheadTransactionCount;
        }

        @Override
        public long getWalApplyTableTimeQuota() {
            return PropServerConfiguration.this.walApplyTableTimeQuota;
        }

        @Override
        public long getWalDataAppendPageSize() {
            return PropServerConfiguration.this.walWriterDataAppendPageSize;
        }

        @Override
        public boolean getWalEnabledDefault() {
            return PropServerConfiguration.this.walEnabledDefault;
        }

        @Override
        public long getWalEventAppendPageSize() {
            return PropServerConfiguration.this.walWriterEventAppendPageSize;
        }

        @Override
        public double getWalLagRowsMultiplier() {
            return PropServerConfiguration.this.walSquashUncommittedRowsMultiplier;
        }

        @Override
        public long getWalMaxLagSize() {
            return PropServerConfiguration.this.walMaxLagSize;
        }

        @Override
        public int getWalMaxLagTxnCount() {
            return PropServerConfiguration.this.walMaxLagTxnCount;
        }

        @Override
        public int getWalMaxSegmentFileDescriptorsCache() {
            return PropServerConfiguration.this.walMaxSegmentFileDescriptorsCache;
        }

        @Override
        public long getWalPurgeInterval() {
            return PropServerConfiguration.this.walPurgeInterval;
        }

        @Override
        public int getWalPurgeWaitBeforeDelete() {
            return PropServerConfiguration.this.walPurgeWaitBeforeDelete;
        }

        @Override
        public int getWalRecreateDistressedSequencerAttempts() {
            return PropServerConfiguration.this.walRecreateDistressedSequencerAttempts;
        }

        @Override
        public long getWalSegmentRolloverRowCount() {
            return PropServerConfiguration.this.walSegmentRolloverRowCount;
        }

        @Override
        public long getWalSegmentRolloverSize() {
            return PropServerConfiguration.this.walSegmentRolloverSize;
        }

        @Override
        public int getWalTxnNotificationQueueCapacity() {
            return PropServerConfiguration.this.walTxnNotificationQueueCapacity;
        }

        @Override
        public int getWalWriterPoolMaxSegments() {
            return PropServerConfiguration.this.walWriterPoolMaxSegments;
        }

        @Override
        public int getWindowColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlWindowColumnPoolCapacity;
        }

        @Override
        public int getWithClauseModelPoolCapacity() {
            return PropServerConfiguration.this.sqlWithClauseModelPoolCapacity;
        }

        @Override
        public long getWorkStealTimeoutNanos() {
            return PropServerConfiguration.this.workStealTimeoutNanos;
        }

        @Override
        public long getWriteBackOffTimeoutOnMemPressureMs() {
            return PropServerConfiguration.this.cairoWriteBackOffTimeoutOnMemPressureMs;
        }

        @Override
        public long getWriterAsyncCommandBusyWaitTimeout() {
            return PropServerConfiguration.this.writerAsyncCommandBusyWaitTimeout;
        }

        @Override
        public long getWriterAsyncCommandMaxTimeout() {
            return PropServerConfiguration.this.writerAsyncCommandMaxWaitTimeout;
        }

        @Override
        public int getWriterCommandQueueCapacity() {
            return PropServerConfiguration.this.writerAsyncCommandQueueCapacity;
        }

        @Override
        public long getWriterCommandQueueSlotSize() {
            return PropServerConfiguration.this.writerAsyncCommandQueueSlotSize;
        }

        @Override
        public int getWriterFileOpenOpts() {
            return PropServerConfiguration.this.writerFileOpenOpts;
        }

        @Override
        public int getWriterTickRowsCountMod() {
            return PropServerConfiguration.this.writerTickRowsCountMod;
        }

        @Override
        public boolean isCheckpointRecoveryEnabled() {
            return PropServerConfiguration.this.checkpointRecoveryEnabled;
        }

        @Override
        public boolean isColumnAliasExpressionEnabled() {
            return PropServerConfiguration.this.cairoSqlColumnAliasExpressionEnabled;
        }

        @Override
        public boolean isDevModeEnabled() {
            return PropServerConfiguration.this.devModeEnabled;
        }

        @Override
        public boolean isGroupByPresizeEnabled() {
            return PropServerConfiguration.this.cairoGroupByPresizeEnabled;
        }

        @Override
        public boolean isIOURingEnabled() {
            return PropServerConfiguration.this.ioURingEnabled;
        }

        @Override
        public boolean isMatViewEnabled() {
            return PropServerConfiguration.this.matViewEnabled;
        }

        @Override
        public boolean isMatViewParallelSqlEnabled() {
            return PropServerConfiguration.this.matViewParallelExecutionEnabled;
        }

        @Override
        public boolean isMultiKeyDedupEnabled() {
            return false;
        }

        @Override
        public boolean isO3QuickSortEnabled() {
            return PropServerConfiguration.this.o3QuickSortEnabled;
        }

        @Override
        public boolean isParallelIndexingEnabled() {
            return PropServerConfiguration.this.parallelIndexingEnabled;
        }

        @Override
        public boolean isPartitionEncoderParquetRawArrayEncoding() {
            return PropServerConfiguration.this.partitionEncoderParquetRawArrayEncoding;
        }

        @Override
        public boolean isPartitionEncoderParquetStatisticsEnabled() {
            return PropServerConfiguration.this.partitionEncoderParquetStatisticsEnabled;
        }

        @Override
        public boolean isPartitionO3OverwriteControlEnabled() {
            return PropServerConfiguration.this.o3PartitionOverwriteControlEnabled;
        }

        @Override
        public boolean isQueryTracingEnabled() {
            return PropServerConfiguration.this.isQueryTracingEnabled;
        }

        @Override
        public boolean isReadOnlyInstance() {
            return PropServerConfiguration.this.isReadOnlyInstance;
        }

        @Override
        public boolean isSqlJitDebugEnabled() {
            return PropServerConfiguration.this.sqlJitDebugEnabled;
        }

        @Override
        public boolean isSqlOrderBySortEnabled() {
            return PropServerConfiguration.this.sqlOrderBySortEnabled;
        }

        @Override
        public boolean isSqlParallelFilterEnabled() {
            return PropServerConfiguration.this.sqlParallelFilterEnabled;
        }

        @Override
        public boolean isSqlParallelFilterPreTouchEnabled() {
            return PropServerConfiguration.this.sqlParallelFilterPreTouchEnabled;
        }

        @Override
        public boolean isSqlParallelGroupByEnabled() {
            return PropServerConfiguration.this.sqlParallelGroupByEnabled;
        }

        @Override
        public boolean isSqlParallelReadParquetEnabled() {
            return PropServerConfiguration.this.sqlParallelReadParquetEnabled;
        }

        @Override
        public boolean isSqlParallelTopKEnabled() {
            return PropServerConfiguration.this.sqlParallelTopKEnabled;
        }

        @Override
        public boolean isTableTypeConversionEnabled() {
            return PropServerConfiguration.this.tableTypeConversionEnabled;
        }

        @Override
        public boolean isValidateSampleByFillType() {
            return PropServerConfiguration.this.sqlSampleByValidateFillType;
        }

        @Override
        public boolean isWalApplyEnabled() {
            return PropServerConfiguration.this.walApplyEnabled;
        }

        @Override
        public boolean isWalApplyParallelSqlEnabled() {
            return PropServerConfiguration.this.walParallelExecutionEnabled;
        }

        @Override
        public boolean isWalSupported() {
            return PropServerConfiguration.this.walSupported;
        }

        @Override
        public boolean isWriterMixedIOEnabled() {
            return PropServerConfiguration.this.writerMixedIOEnabled;
        }

        @Override
        public boolean mangleTableDirNames() {
            return false;
        }

        @Override
        public int maxArrayElementCount() {
            return PropServerConfiguration.this.sqlMaxArrayElementCount;
        }

        @Override
        public boolean useFastAsOfJoin() {
            return PropServerConfiguration.this.useFastAsOfJoin;
        }

        @Override
        public boolean useWithinLatestByOptimisation() {
            return PropServerConfiguration.this.queryWithinLatestByOptimisationEnabled;
        }
    }

    private class PropSqlExecutionCircuitBreakerConfiguration
    implements SqlExecutionCircuitBreakerConfiguration {
        private PropSqlExecutionCircuitBreakerConfiguration() {
        }

        @Override
        public boolean checkConnection() {
            return true;
        }

        @Override
        public int getBufferSize() {
            return PropServerConfiguration.this.netTestConnectionBufferSize;
        }

        @Override
        public int getCircuitBreakerThrottle() {
            return PropServerConfiguration.this.circuitBreakerThrottle;
        }

        @Override
        @NotNull
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        @NotNull
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public long getQueryTimeout() {
            return PropServerConfiguration.this.queryTimeout;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.interruptOnClosedConnection;
        }
    }

    public class PropHttpConcurrentCacheConfiguration
    implements ConcurrentCacheConfiguration {
        @Override
        public int getBlocks() {
            return PropServerConfiguration.this.httpSqlCacheBlockCount;
        }

        @Override
        public LongGauge getCachedGauge() {
            return PropServerConfiguration.this.metrics.jsonQueryMetrics().cachedQueriesGauge();
        }

        @Override
        public Counter getHiCounter() {
            return PropServerConfiguration.this.metrics.jsonQueryMetrics().cacheHitCounter();
        }

        @Override
        public Counter getMissCounter() {
            return PropServerConfiguration.this.metrics.jsonQueryMetrics().cacheMissCounter();
        }

        @Override
        public int getRows() {
            return PropServerConfiguration.this.httpSqlCacheRowCount;
        }
    }

    private class PropWaitProcessorConfiguration
    implements WaitProcessorConfiguration {
        private PropWaitProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public double getExponentialWaitMultiplier() {
            return PropServerConfiguration.this.rerunExponentialWaitMultiplier;
        }

        @Override
        public int getInitialWaitQueueSize() {
            return PropServerConfiguration.this.rerunInitialWaitQueueSize;
        }

        @Override
        public int getMaxProcessingQueueSize() {
            return PropServerConfiguration.this.rerunMaxProcessingQueueSize;
        }

        @Override
        public long getMaxWaitCapMs() {
            return PropServerConfiguration.this.maxRerunWaitCapMs;
        }
    }

    private class PropLineHttpProcessorConfiguration
    implements LineHttpProcessorConfiguration {
        private PropLineHttpProcessorConfiguration() {
        }

        @Override
        public boolean autoCreateNewColumns() {
            return PropServerConfiguration.this.ilpAutoCreateNewColumns;
        }

        @Override
        public boolean autoCreateNewTables() {
            return PropServerConfiguration.this.ilpAutoCreateNewTables;
        }

        @Override
        public CairoConfiguration getCairoConfiguration() {
            return PropServerConfiguration.this.cairoConfiguration;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return PropServerConfiguration.this.floatDefaultColumnType;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return PropServerConfiguration.this.integerDefaultColumnType;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineTcpDefaultPartitionBy;
        }

        @Override
        public CharSequence getInfluxPingVersion() {
            return PropServerConfiguration.this.lineHttpPingVersion;
        }

        @Override
        public long getMaxRecvBufferSize() {
            return PropServerConfiguration.this.httpRecvMaxBufferSize;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return PropServerConfiguration.this.microsecondClock;
        }

        @Override
        public long getSymbolCacheWaitUsBeforeReload() {
            return PropServerConfiguration.this.symbolCacheWaitBeforeReload;
        }

        @Override
        public LineTcpTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineTcpTimestampAdapter;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineHttpEnabled;
        }

        @Override
        public boolean isStringToCharCastAllowed() {
            return PropServerConfiguration.this.stringToCharCastAllowed;
        }

        @Override
        public boolean isUseLegacyStringDefault() {
            return PropServerConfiguration.this.useLegacyStringDefault;
        }

        @Override
        public boolean logMessageOnError() {
            return PropServerConfiguration.this.lineLogMessageOnError;
        }
    }

    private class PropLineTcpIOWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropLineTcpIOWorkerPoolConfiguration() {
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerNapThreshold;
        }

        @Override
        public String getPoolName() {
            return "ilpio";
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerSleepThreshold;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpIOWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpIOWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolHaltOnError;
        }
    }

    private class PropLineTcpReceiverConfiguration
    implements LineTcpReceiverConfiguration {
        private PropLineTcpReceiverConfiguration() {
        }

        @Override
        public long getAcceptLoopTimeout() {
            return PropServerConfiguration.this.lineTcpNetAcceptLoopTimeout;
        }

        @Override
        public String getAuthDB() {
            return PropServerConfiguration.this.lineTcpAuthDB;
        }

        @Override
        public boolean getAutoCreateNewColumns() {
            return PropServerConfiguration.this.ilpAutoCreateNewColumns;
        }

        @Override
        public boolean getAutoCreateNewTables() {
            return PropServerConfiguration.this.ilpAutoCreateNewTables;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineTcpNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.lineTcpNetBindPort;
        }

        @Override
        public CairoConfiguration getCairoConfiguration() {
            return PropServerConfiguration.this.cairoConfiguration;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getCommitInterval() {
            return LineTcpReceiverConfigurationHelper.calcCommitInterval(PropServerConfiguration.this.cairoConfiguration.getO3MinLag(), this.getCommitIntervalFraction(), this.getCommitIntervalDefault());
        }

        @Override
        public long getCommitIntervalDefault() {
            return PropServerConfiguration.this.lineTcpCommitIntervalDefault;
        }

        @Override
        public double getCommitIntervalFraction() {
            return PropServerConfiguration.this.lineTcpCommitIntervalFraction;
        }

        @Override
        public LongGauge getConnectionCountGauge() {
            return PropServerConfiguration.this.metrics.lineMetrics().tcpConnectionCountGauge();
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.lineTcpConnectionPoolInitialCapacity;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return PropServerConfiguration.this.floatDefaultColumnType;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return PropServerConfiguration.this.integerDefaultColumnType;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineTcpDefaultPartitionBy;
        }

        @Override
        public boolean getDisconnectOnError() {
            return PropServerConfiguration.this.lineTcpDisconnectOnError;
        }

        @Override
        public String getDispatcherLogName() {
            return "tcp-line-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public long getHeartbeatInterval() {
            return PropServerConfiguration.this.lineTcpNetConnectionHeartbeatInterval;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.lineTcpNetConnectionHint;
        }

        @Override
        public KqueueFacade getKqueueFacade() {
            return KqueueFacadeImpl.INSTANCE;
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.lineTcpNetConnectionLimit;
        }

        @Override
        public long getMaintenanceInterval() {
            return PropServerConfiguration.this.lineTcpMaintenanceInterval;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMaxMeasurementSize() {
            return PropServerConfiguration.this.lineTcpMaxMeasurementSize;
        }

        @Override
        public long getMaxRecvBufferSize() {
            return PropServerConfiguration.this.lineTcpMaxRecvBufferSize;
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getNetRecvBufferSize() {
            return PropServerConfiguration.this.lineTcpNetConnectionRcvBuf;
        }

        @Override
        public int getNetSendBufferSize() {
            return -1;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public WorkerPoolConfiguration getNetworkWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolConfiguration;
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.lineTcpNetConnectionQueueTimeout;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.lineTcpRecvBufferSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSendBufferSize() {
            return -1;
        }

        @Override
        public long getSymbolCacheWaitBeforeReload() {
            return PropServerConfiguration.this.symbolCacheWaitBeforeReload;
        }

        @Override
        public int getTestConnectionBufferSize() {
            return PropServerConfiguration.this.netTestConnectionBufferSize;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.lineTcpNetConnectionTimeout;
        }

        @Override
        public LineTcpTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineTcpTimestampAdapter;
        }

        @Override
        public long getWriterIdleTimeout() {
            return PropServerConfiguration.this.minIdleMsBeforeWriterRelease;
        }

        @Override
        public int getWriterQueueCapacity() {
            return PropServerConfiguration.this.lineTcpWriterQueueCapacity;
        }

        @Override
        public WorkerPoolConfiguration getWriterWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolConfiguration;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineTcpEnabled;
        }

        @Override
        public boolean isStringToCharCastAllowed() {
            return PropServerConfiguration.this.stringToCharCastAllowed;
        }

        @Override
        public boolean isUseLegacyStringDefault() {
            return PropServerConfiguration.this.useLegacyStringDefault;
        }

        @Override
        public Counter listenerStateChangeCounter() {
            return PropServerConfiguration.this.metrics.lineMetrics().aboveMaxConnectionCountCounter();
        }

        @Override
        public boolean logMessageOnError() {
            return PropServerConfiguration.this.lineLogMessageOnError;
        }
    }

    private class PropLineTcpWriterWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropLineTcpWriterWorkerPoolConfiguration() {
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerNapThreshold;
        }

        @Override
        public String getPoolName() {
            return "ilpwriter";
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerSleepThreshold;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpWriterWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpWriterWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolHaltOnError;
        }
    }

    private class PropLineUdpReceiverConfiguration
    implements LineUdpReceiverConfiguration {
        private PropLineUdpReceiverConfiguration() {
        }

        @Override
        public boolean getAutoCreateNewColumns() {
            return PropServerConfiguration.this.ilpAutoCreateNewColumns;
        }

        @Override
        public boolean getAutoCreateNewTables() {
            return PropServerConfiguration.this.ilpAutoCreateNewTables;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineUdpBindIPV4Address;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.lineUdpCommitMode;
        }

        @Override
        public int getCommitRate() {
            return PropServerConfiguration.this.lineUdpCommitRate;
        }

        @Override
        public short getDefaultColumnTypeForFloat() {
            return PropServerConfiguration.this.floatDefaultColumnType;
        }

        @Override
        public short getDefaultColumnTypeForInteger() {
            return PropServerConfiguration.this.integerDefaultColumnType;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineUdpDefaultPartitionBy;
        }

        @Override
        public int getGroupIPv4Address() {
            return PropServerConfiguration.this.lineUdpGroupIPv4Address;
        }

        @Override
        public int getMaxFileNameLength() {
            return PropServerConfiguration.this.maxFileNameLength;
        }

        @Override
        public int getMsgBufferSize() {
            return PropServerConfiguration.this.lineUdpMsgBufferSize;
        }

        @Override
        public int getMsgCount() {
            return PropServerConfiguration.this.lineUdpMsgCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPort() {
            return PropServerConfiguration.this.lineUdpPort;
        }

        @Override
        public int getReceiveBufferSize() {
            return PropServerConfiguration.this.lineUdpReceiveBufferSize;
        }

        @Override
        public LineTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineUdpTimestampAdapter;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineUdpEnabled;
        }

        @Override
        public boolean isUnicast() {
            return PropServerConfiguration.this.lineUdpUnicast;
        }

        @Override
        public boolean isUseLegacyStringDefault() {
            return PropServerConfiguration.this.useLegacyStringDefault;
        }

        @Override
        public boolean ownThread() {
            return PropServerConfiguration.this.lineUdpOwnThread;
        }

        @Override
        public int ownThreadAffinity() {
            return PropServerConfiguration.this.lineUdpOwnThreadAffinity;
        }
    }

    private class PropMatViewRefreshPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropMatViewRefreshPoolConfiguration() {
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.matViewRefreshWorkerNapThreshold;
        }

        @Override
        public String getPoolName() {
            return "mat-view-refresh";
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.matViewRefreshWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.matViewRefreshSleepTimeout;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.matViewRefreshWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.matViewRefreshWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.matViewRefreshWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.matViewRefreshWorkerHaltOnError;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.matViewRefreshWorkerCount > 0;
        }
    }

    private class PropMetricsConfiguration
    implements MetricsConfiguration {
        private PropMetricsConfiguration() {
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.metricsEnabled;
        }
    }

    private static class PropWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private final String name;
        public Metrics metrics;
        public int[] sharedWorkerAffinity;
        public int sharedWorkerCount;
        public boolean sharedWorkerHaltOnError;
        public long sharedWorkerNapThreshold;
        public long sharedWorkerSleepThreshold;
        public long sharedWorkerSleepTimeout;
        public long sharedWorkerYieldThreshold;
        public int workerPoolPriority = 5;

        private PropWorkerPoolConfiguration(String name) {
            this.name = name;
        }

        @Override
        public Metrics getMetrics() {
            return this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return this.sharedWorkerNapThreshold;
        }

        @Override
        public String getPoolName() {
            return this.name;
        }

        @Override
        public long getSleepThreshold() {
            return this.sharedWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return this.sharedWorkerSleepTimeout;
        }

        @Override
        public int[] getWorkerAffinity() {
            return this.sharedWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return this.sharedWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return this.sharedWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return this.sharedWorkerHaltOnError;
        }

        @Override
        public int workerPoolPriority() {
            return this.workerPoolPriority;
        }
    }

    private class PropPGWireConcurrentCacheConfiguration
    implements ConcurrentCacheConfiguration {
        private PropPGWireConcurrentCacheConfiguration() {
        }

        @Override
        public int getBlocks() {
            return PropServerConfiguration.this.pgSelectCacheBlockCount;
        }

        @Override
        public LongGauge getCachedGauge() {
            return PropServerConfiguration.this.metrics.pgWireMetrics().cachedSelectsGauge();
        }

        @Override
        public Counter getHiCounter() {
            return PropServerConfiguration.this.metrics.pgWireMetrics().selectCacheHitCounter();
        }

        @Override
        public Counter getMissCounter() {
            return PropServerConfiguration.this.metrics.pgWireMetrics().selectCacheMissCounter();
        }

        @Override
        public int getRows() {
            return PropServerConfiguration.this.pgSelectCacheRowCount;
        }
    }

    private class PropPGConfiguration
    implements PGConfiguration {
        private PropPGConfiguration() {
        }

        @Override
        public long getAcceptLoopTimeout() {
            return PropServerConfiguration.this.pgNetAcceptLoopTimeout;
        }

        @Override
        public int getBinParamCountCapacity() {
            return PropServerConfiguration.this.pgBinaryParamsCapacity;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.pgNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.pgNetBindPort;
        }

        @Override
        public int getCharacterStoreCapacity() {
            return PropServerConfiguration.this.pgCharacterStoreCapacity;
        }

        @Override
        public int getCharacterStorePoolCapacity() {
            return PropServerConfiguration.this.pgCharacterStorePoolCapacity;
        }

        @Override
        public SqlExecutionCircuitBreakerConfiguration getCircuitBreakerConfiguration() {
            return PropServerConfiguration.this.circuitBreakerConfiguration;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public ConcurrentCacheConfiguration getConcurrentCacheConfiguration() {
            return PropServerConfiguration.this.pgWireConcurrentCacheConfiguration;
        }

        @Override
        public LongGauge getConnectionCountGauge() {
            return PropServerConfiguration.this.metrics.pgWireMetrics().connectionCountGauge();
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.pgConnectionPoolInitialCapacity;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.pgDefaultLocale;
        }

        @Override
        public String getDefaultPassword() {
            return PropServerConfiguration.this.pgPassword;
        }

        @Override
        public String getDefaultUsername() {
            return PropServerConfiguration.this.pgUsername;
        }

        @Override
        public String getDispatcherLogName() {
            return "pg-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public int getForceRecvFragmentationChunkSize() {
            return PropServerConfiguration.this.pgForceRecvFragmentationChunkSize;
        }

        @Override
        public int getForceSendFragmentationChunkSize() {
            return PropServerConfiguration.this.pgForceSendFragmentationChunkSize;
        }

        @Override
        public long getHeartbeatInterval() {
            return -1L;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.pgNetConnectionHint;
        }

        @Override
        public int getInsertCacheBlockCount() {
            return PropServerConfiguration.this.pgInsertCacheBlockCount;
        }

        @Override
        public int getInsertCacheRowCount() {
            return PropServerConfiguration.this.pgInsertCacheRowCount;
        }

        @Override
        public KqueueFacade getKqueueFacade() {
            return KqueueFacadeImpl.INSTANCE;
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.pgNetConnectionLimit;
        }

        @Override
        public int getMaxBlobSizeOnQuery() {
            return PropServerConfiguration.this.pgMaxBlobSizeOnQuery;
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public int getNamedStatementCacheCapacity() {
            return PropServerConfiguration.this.pgNamedStatementCacheCapacity;
        }

        @Override
        public int getNamedStatementLimit() {
            return PropServerConfiguration.this.pgNamedStatementLimit;
        }

        @Override
        public int getNamesStatementPoolCapacity() {
            return PropServerConfiguration.this.pgNamesStatementPoolCapacity;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.pgWorkerNapThreshold;
        }

        @Override
        public int getNetRecvBufferSize() {
            return PropServerConfiguration.this.pgNetConnectionRcvBuf;
        }

        @Override
        public int getNetSendBufferSize() {
            return PropServerConfiguration.this.pgNetConnectionSndBuf;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPendingWritersCacheSize() {
            return PropServerConfiguration.this.pgPendingWritersCacheCapacity;
        }

        @Override
        public int getPipelineCapacity() {
            return PropServerConfiguration.this.pgPipelineCapacity;
        }

        @Override
        public String getPoolName() {
            return "pgwire";
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.pgNetConnectionQueueTimeout;
        }

        @Override
        public String getReadOnlyPassword() {
            return PropServerConfiguration.this.pgReadOnlyPassword;
        }

        @Override
        public String getReadOnlyUsername() {
            return PropServerConfiguration.this.pgReadOnlyUsername;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.pgRecvBufferSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.pgSendBufferSize;
        }

        @Override
        public String getServerVersion() {
            return "11.3";
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.pgWorkerSleepThreshold;
        }

        @Override
        public int getTestConnectionBufferSize() {
            return PropServerConfiguration.this.netTestConnectionBufferSize;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.pgNetIdleConnectionTimeout;
        }

        @Override
        public int getUpdateCacheBlockCount() {
            return PropServerConfiguration.this.pgUpdateCacheBlockCount;
        }

        @Override
        public int getUpdateCacheRowCount() {
            return PropServerConfiguration.this.pgUpdateCacheRowCount;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.pgWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.pgWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.pgWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.pgHaltOnError;
        }

        @Override
        public boolean isDaemonPool() {
            return PropServerConfiguration.this.pgDaemonPool;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.pgEnabled;
        }

        @Override
        public boolean isInsertCacheEnabled() {
            return PropServerConfiguration.this.pgInsertCacheEnabled;
        }

        @Override
        public boolean isReadOnlyUserEnabled() {
            return PropServerConfiguration.this.pgReadOnlyUserEnabled;
        }

        @Override
        public boolean isSelectCacheEnabled() {
            return PropServerConfiguration.this.pgSelectCacheEnabled;
        }

        @Override
        public boolean isUpdateCacheEnabled() {
            return PropServerConfiguration.this.pgUpdateCacheEnabled;
        }

        @Override
        public Counter listenerStateChangeCounter() {
            return PropServerConfiguration.this.metrics.pgWireMetrics().listenerStateChangeCounter();
        }

        @Override
        public boolean readOnlySecurityContext() {
            return PropServerConfiguration.this.pgReadOnlySecurityContext || PropServerConfiguration.this.isReadOnlyInstance;
        }
    }

    class PropPublicPassthroughConfiguration
    implements PublicPassthroughConfiguration {
        PropPublicPassthroughConfiguration() {
        }

        @Override
        public boolean exportConfiguration(CharSink<?> sink) {
            JsonPropertyValueFormatter.bool(PropertyKey.POSTHOG_ENABLED.getPropertyPath(), this.isPosthogEnabled(), sink);
            JsonPropertyValueFormatter.str(PropertyKey.POSTHOG_API_KEY.getPropertyPath(), this.getPosthogApiKey(), sink);
            JsonPropertyValueFormatter.integer(PropertyKey.CAIRO_MAX_FILE_NAME_LENGTH.toString(), PropServerConfiguration.this.maxFileNameLength, sink);
            return true;
        }

        @Override
        public String getPosthogApiKey() {
            return PropServerConfiguration.this.posthogApiKey;
        }

        @Override
        public boolean isPosthogEnabled() {
            return PropServerConfiguration.this.posthogEnabled;
        }
    }

    private class PropTelemetryConfiguration
    implements TelemetryConfiguration {
        private PropTelemetryConfiguration() {
        }

        @Override
        public long getDbSizeEstimateTimeout() {
            return PropServerConfiguration.this.telemetryDbSizeEstimateTimeout;
        }

        @Override
        public boolean getDisableCompletely() {
            return PropServerConfiguration.this.telemetryDisableCompletely;
        }

        @Override
        public boolean getEnabled() {
            return PropServerConfiguration.this.telemetryEnabled;
        }

        @Override
        public int getQueueCapacity() {
            return PropServerConfiguration.this.telemetryQueueCapacity;
        }

        @Override
        public boolean hideTables() {
            return PropServerConfiguration.this.telemetryHideTables;
        }
    }

    private class PropTextConfiguration
    implements TextConfiguration {
        private PropTextConfiguration() {
        }

        @Override
        public int getDateAdapterPoolCapacity() {
            return PropServerConfiguration.this.dateAdapterPoolCapacity;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }

        @Override
        public InputFormatConfiguration getInputFormatConfiguration() {
            return PropServerConfiguration.this.inputFormatConfiguration;
        }

        @Override
        public int getJsonCacheLimit() {
            return PropServerConfiguration.this.jsonCacheLimit;
        }

        @Override
        public int getJsonCacheSize() {
            return PropServerConfiguration.this.jsonCacheSize;
        }

        @Override
        public double getMaxRequiredDelimiterStdDev() {
            return PropServerConfiguration.this.maxRequiredDelimiterStdDev;
        }

        @Override
        public double getMaxRequiredLineLengthStdDev() {
            return PropServerConfiguration.this.maxRequiredLineLengthStdDev;
        }

        @Override
        public int getMetadataStringPoolCapacity() {
            return PropServerConfiguration.this.metadataStringPoolCapacity;
        }

        @Override
        public int getRollBufferLimit() {
            return PropServerConfiguration.this.rollBufferLimit;
        }

        @Override
        public int getRollBufferSize() {
            return PropServerConfiguration.this.rollBufferSize;
        }

        @Override
        public int getTextAnalysisMaxLines() {
            return PropServerConfiguration.this.textAnalysisMaxLines;
        }

        @Override
        public int getTextLexerStringPoolCapacity() {
            return PropServerConfiguration.this.textLexerStringPoolCapacity;
        }

        @Override
        public int getTimestampAdapterPoolCapacity() {
            return PropServerConfiguration.this.timestampAdapterPoolCapacity;
        }

        @Override
        public int getUtf8SinkSize() {
            return PropServerConfiguration.this.utf8SinkSize;
        }

        @Override
        public boolean isUseLegacyStringDefault() {
            return PropServerConfiguration.this.useLegacyStringDefault;
        }
    }

    private class PropWalApplyPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropWalApplyPoolConfiguration() {
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.walApplyWorkerNapThreshold;
        }

        @Override
        public String getPoolName() {
            return "wal-apply";
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.walApplyWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.walApplySleepTimeout;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.walApplyWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.walApplyWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.walApplyWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.walApplyWorkerHaltOnError;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.walApplyWorkerCount > 0;
        }
    }

    public class PropHttpMinServerConfiguration
    implements HttpServerConfiguration {
        @Override
        public long getAcceptLoopTimeout() {
            return PropServerConfiguration.this.httpMinNetAcceptLoopTimeout;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpMinBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpMinBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public LongGauge getConnectionCountGauge() {
            return PropServerConfiguration.this.metrics.httpMetrics().connectionCountGauge();
        }

        @Override
        public String getDispatcherLogName() {
            return "http-min-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public long getHeartbeatInterval() {
            return -1L;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.httpMinNetConnectionHint;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpMinContextConfiguration;
        }

        @Override
        public KqueueFacade getKqueueFacade() {
            return KqueueFacadeImpl.INSTANCE;
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.httpMinNetConnectionLimit;
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.httpMinWorkerNapThreshold;
        }

        @Override
        public int getNetRecvBufferSize() {
            return PropServerConfiguration.this.httpMinNetConnectionRcvBuf;
        }

        @Override
        public int getNetSendBufferSize() {
            return PropServerConfiguration.this.httpMinNetConnectionSndBuf;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public String getPoolName() {
            return "minhttp";
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.httpMinNetConnectionQueueTimeout;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.httpMinRecvBufferSize;
        }

        @Override
        public byte getRequiredAuthType() {
            return PropServerConfiguration.this.httpHealthCheckAuthType;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.httpMinSendBufferSize;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpMinWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.httpMinWorkerSleepTimeout;
        }

        @Override
        public int getTestConnectionBufferSize() {
            return PropServerConfiguration.this.netTestConnectionBufferSize;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.httpMinNetConnectionTimeout;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpMinWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpMinWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpMinWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpMinWorkerHaltOnError;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpMinServerEnabled;
        }

        @Override
        public boolean isPessimisticHealthCheckEnabled() {
            return PropServerConfiguration.this.httpPessimisticHealthCheckEnabled;
        }

        @Override
        public Counter listenerStateChangeCounter() {
            return PropServerConfiguration.this.metrics.httpMetrics().listenerStateChangeCounter();
        }

        @Override
        public boolean preAllocateBuffers() {
            return true;
        }

        @Override
        public int workerPoolPriority() {
            return PropServerConfiguration.this.httpMinWorkerPoolPriority;
        }
    }

    public class PropHttpServerConfiguration
    implements HttpFullFatServerConfiguration {
        @Override
        public long getAcceptLoopTimeout() {
            return PropServerConfiguration.this.httpNetAcceptLoopTimeout;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public ConcurrentCacheConfiguration getConcurrentCacheConfiguration() {
            return PropServerConfiguration.this.httpMinConcurrentCacheConfiguration;
        }

        @Override
        public LongGauge getConnectionCountGauge() {
            return PropServerConfiguration.this.metrics.httpMetrics().connectionCountGauge();
        }

        @Override
        public ObjList<String> getContextPathExec() {
            return PropServerConfiguration.this.httpContextPathExec;
        }

        @Override
        public ObjList<String> getContextPathExport() {
            return PropServerConfiguration.this.httpContextPathExport;
        }

        @Override
        public ObjList<String> getContextPathILP() {
            return PropServerConfiguration.this.httpContextPathILP;
        }

        @Override
        public ObjList<String> getContextPathILPPing() {
            return PropServerConfiguration.this.httpContextPathILPPing;
        }

        @Override
        public ObjList<String> getContextPathImport() {
            return PropServerConfiguration.this.httpContextPathImport;
        }

        @Override
        public ObjList<String> getContextPathSettings() {
            return PropServerConfiguration.this.httpContextPathSettings;
        }

        @Override
        public ObjList<String> getContextPathTableStatus() {
            return PropServerConfiguration.this.httpContextPathTableStatus;
        }

        @Override
        public ObjList<String> getContextPathWarnings() {
            return PropServerConfiguration.this.httpContextPathWarnings;
        }

        @Override
        public String getContextPathWebConsole() {
            return PropServerConfiguration.this.httpContextWebConsole;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public long getHeartbeatInterval() {
            return -1L;
        }

        @Override
        public boolean getHint() {
            return PropServerConfiguration.this.httpNetConnectionHint;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpContextConfiguration;
        }

        @Override
        public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
            return PropServerConfiguration.this.jsonQueryProcessorConfiguration;
        }

        @Override
        public KqueueFacade getKqueueFacade() {
            return KqueueFacadeImpl.INSTANCE;
        }

        @Override
        public int getLimit() {
            return PropServerConfiguration.this.httpNetConnectionLimit;
        }

        @Override
        public LineHttpProcessorConfiguration getLineHttpProcessorConfiguration() {
            return PropServerConfiguration.this.lineHttpProcessorConfiguration;
        }

        @Override
        public Metrics getMetrics() {
            return PropServerConfiguration.this.metrics;
        }

        @Override
        public long getNapThreshold() {
            return PropServerConfiguration.this.httpWorkerNapThreshold;
        }

        @Override
        public int getNetRecvBufferSize() {
            return PropServerConfiguration.this.httpNetConnectionRcvBuf;
        }

        @Override
        public int getNetSendBufferSize() {
            return PropServerConfiguration.this.httpNetConnectionSndBuf;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public String getPassword() {
            return PropServerConfiguration.this.httpPassword;
        }

        @Override
        public String getPoolName() {
            return "http";
        }

        @Override
        public long getQueueTimeout() {
            return PropServerConfiguration.this.httpNetConnectionQueueTimeout;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.httpRecvBufferSize;
        }

        @Override
        public byte getRequiredAuthType() {
            return PropServerConfiguration.this.httpHealthCheckAuthType;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.httpSendBufferSize;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpWorkerSleepThreshold;
        }

        @Override
        public long getSleepTimeout() {
            return PropServerConfiguration.this.httpWorkerSleepTimeout;
        }

        @Override
        public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
            return PropServerConfiguration.this.staticContentProcessorConfiguration;
        }

        @Override
        public int getTestConnectionBufferSize() {
            return PropServerConfiguration.this.netTestConnectionBufferSize;
        }

        @Override
        public long getTimeout() {
            return PropServerConfiguration.this.httpNetConnectionTimeout;
        }

        @Override
        public String getUsername() {
            return PropServerConfiguration.this.httpUsername;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpWorkerCount;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpWorkerYieldThreshold;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpWorkerHaltOnError;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpServerEnabled;
        }

        @Override
        public boolean isPessimisticHealthCheckEnabled() {
            return PropServerConfiguration.this.httpPessimisticHealthCheckEnabled;
        }

        @Override
        public boolean isQueryCacheEnabled() {
            return PropServerConfiguration.this.httpSqlCacheEnabled;
        }

        @Override
        public boolean isSettingsReadOnly() {
            return PropServerConfiguration.this.httpSettingsReadOnly;
        }

        @Override
        public Counter listenerStateChangeCounter() {
            return PropServerConfiguration.this.metrics.httpMetrics().listenerStateChangeCounter();
        }

        @Override
        public boolean preAllocateBuffers() {
            return false;
        }
    }

    public class PropJsonQueryProcessorConfiguration
    implements JsonQueryProcessorConfiguration {
        @Override
        public int getConnectionCheckFrequency() {
            return PropServerConfiguration.this.jsonQueryConnectionCheckFrequency;
        }

        @Override
        public FactoryProvider getFactoryProvider() {
            return PropServerConfiguration.this.factoryProvider;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }

        @Override
        public long getMaxQueryResponseRowLimit() {
            return PropServerConfiguration.this.maxHttpQueryResponseRowLimit;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public NanosecondClock getNanosecondClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryNanosClock.INSTANCE : NanosecondClockImpl.INSTANCE;
        }
    }

    public static class PropertyValidator {
        protected final Map<ConfigPropertyKey, String> deprecatedSettings = new HashMap<ConfigPropertyKey, String>();
        protected final Map<String, String> obsoleteSettings = new HashMap<String, String>();

        public PropertyValidator() {
            this.registerObsolete("line.tcp.commit.timeout", PropertyKey.LINE_TCP_COMMIT_INTERVAL_DEFAULT, PropertyKey.LINE_TCP_COMMIT_INTERVAL_FRACTION);
            this.registerObsolete("cairo.timestamp.locale", PropertyKey.CAIRO_DATE_LOCALE);
            this.registerObsolete("pg.timestamp.locale", PropertyKey.PG_DATE_LOCALE);
            this.registerObsolete("cairo.sql.append.page.size", PropertyKey.CAIRO_WRITER_DATA_APPEND_PAGE_SIZE);
            this.registerDeprecated(PropertyKey.HTTP_MIN_BIND_TO, PropertyKey.HTTP_MIN_NET_BIND_TO);
            this.registerDeprecated(PropertyKey.HTTP_MIN_NET_IDLE_CONNECTION_TIMEOUT, PropertyKey.HTTP_MIN_NET_CONNECTION_TIMEOUT);
            this.registerDeprecated(PropertyKey.HTTP_MIN_NET_QUEUED_CONNECTION_TIMEOUT, PropertyKey.HTTP_MIN_NET_CONNECTION_QUEUE_TIMEOUT);
            this.registerDeprecated(PropertyKey.HTTP_MIN_NET_SND_BUF_SIZE, PropertyKey.HTTP_MIN_NET_CONNECTION_SNDBUF);
            this.registerDeprecated(PropertyKey.HTTP_MIN_RECEIVE_BUFFER_SIZE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.HTTP_RECEIVE_BUFFER_SIZE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.HTTP_NET_RCV_BUF_SIZE, PropertyKey.HTTP_MIN_NET_CONNECTION_RCVBUF, PropertyKey.HTTP_NET_CONNECTION_RCVBUF);
            this.registerDeprecated(PropertyKey.HTTP_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.HTTP_NET_CONNECTION_LIMIT);
            this.registerDeprecated(PropertyKey.HTTP_NET_IDLE_CONNECTION_TIMEOUT, PropertyKey.HTTP_NET_CONNECTION_TIMEOUT);
            this.registerDeprecated(PropertyKey.HTTP_NET_QUEUED_CONNECTION_TIMEOUT, PropertyKey.HTTP_NET_CONNECTION_QUEUE_TIMEOUT);
            this.registerDeprecated(PropertyKey.HTTP_NET_SND_BUF_SIZE, PropertyKey.HTTP_NET_CONNECTION_SNDBUF);
            this.registerDeprecated(PropertyKey.PG_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.PG_NET_CONNECTION_LIMIT);
            this.registerDeprecated(PropertyKey.PG_NET_IDLE_TIMEOUT, PropertyKey.PG_NET_CONNECTION_TIMEOUT);
            this.registerDeprecated(PropertyKey.PG_NET_RECV_BUF_SIZE, PropertyKey.PG_NET_CONNECTION_RCVBUF);
            this.registerDeprecated(PropertyKey.PG_NET_SEND_BUF_SIZE, PropertyKey.PG_NET_CONNECTION_SNDBUF);
            this.registerDeprecated(PropertyKey.LINE_TCP_NET_ACTIVE_CONNECTION_LIMIT, PropertyKey.LINE_TCP_NET_CONNECTION_LIMIT);
            this.registerDeprecated(PropertyKey.LINE_TCP_NET_IDLE_TIMEOUT, PropertyKey.LINE_TCP_NET_CONNECTION_TIMEOUT);
            this.registerDeprecated(PropertyKey.LINE_TCP_NET_QUEUED_TIMEOUT, PropertyKey.LINE_TCP_NET_CONNECTION_QUEUE_TIMEOUT);
            this.registerDeprecated(PropertyKey.LINE_TCP_NET_RECV_BUF_SIZE, PropertyKey.LINE_TCP_NET_CONNECTION_RCVBUF);
            this.registerDeprecated(PropertyKey.LINE_TCP_MSG_BUFFER_SIZE, PropertyKey.LINE_TCP_RECV_BUFFER_SIZE);
            this.registerDeprecated(PropertyKey.LINE_TCP_DEFAULT_PARTITION_BY, PropertyKey.LINE_DEFAULT_PARTITION_BY);
            this.registerDeprecated(PropertyKey.CAIRO_REPLACE_BUFFER_MAX_SIZE, PropertyKey.CAIRO_SQL_STR_FUNCTION_BUFFER_MAX_SIZE);
            this.registerDeprecated(PropertyKey.CIRCUIT_BREAKER_BUFFER_SIZE, PropertyKey.NET_TEST_CONNECTION_BUFFER_SIZE);
            this.registerDeprecated(PropertyKey.QUERY_TIMEOUT_SEC, PropertyKey.QUERY_TIMEOUT);
            this.registerDeprecated(PropertyKey.CAIRO_PAGE_FRAME_TASK_POOL_CAPACITY, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_MAP_PAGE_SIZE, PropertyKey.CAIRO_SQL_SMALL_MAP_PAGE_SIZE);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_MAP_KEY_CAPACITY, PropertyKey.CAIRO_SQL_SMALL_MAP_KEY_CAPACITY);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_COLUMN_POOL_CAPACITY, PropertyKey.CAIRO_SQL_WINDOW_COLUMN_POOL_CAPACITY);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_STORE_PAGE_SIZE, PropertyKey.CAIRO_SQL_WINDOW_STORE_PAGE_SIZE);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_STORE_MAX_PAGES, PropertyKey.CAIRO_SQL_WINDOW_STORE_MAX_PAGES);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_PAGE_SIZE, PropertyKey.CAIRO_SQL_WINDOW_ROWID_PAGE_SIZE);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_ROWID_MAX_PAGES, PropertyKey.CAIRO_SQL_WINDOW_ROWID_MAX_PAGES);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_TREE_PAGE_SIZE, PropertyKey.CAIRO_SQL_WINDOW_TREE_PAGE_SIZE);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_ANALYTIC_TREE_MAX_PAGES, PropertyKey.CAIRO_SQL_WINDOW_TREE_MAX_PAGES);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_COLUMN_CAST_MODEL_POOL_CAPACITY, PropertyKey.CAIRO_SQL_CREATE_TABLE_COLUMN_MODEL_POOL_CAPACITY);
            this.registerDeprecated(PropertyKey.PG_INSERT_POOL_CAPACITY, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.LINE_UDP_TIMESTAMP, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.LINE_TCP_TIMESTAMP, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_JIT_ROWS_THRESHOLD, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_COMPACT_MAP_LOAD_FACTOR, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_DEFAULT_MAP_TYPE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.HTTP_JSON_QUERY_DOUBLE_SCALE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.HTTP_JSON_QUERY_FLOAT_SCALE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_DOUBLE_CAST_SCALE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_SQL_FLOAT_CAST_SCALE, new ConfigPropertyKey[0]);
            this.registerDeprecated(PropertyKey.CAIRO_MAT_VIEW_MIN_REFRESH_INTERVAL, new ConfigPropertyKey[0]);
        }

        public ValidationResult validate(Properties properties) {
            HashMap<String, String> obsolete = new HashMap<String, String>();
            HashMap<String, String> deprecated = new HashMap<String, String>();
            HashSet<String> incorrect = new HashSet<String>();
            for (String propName : properties.stringPropertyNames()) {
                Optional<ConfigPropertyKey> prop = this.lookupConfigProperty(propName);
                if (prop.isPresent()) {
                    String string = this.deprecatedSettings.get(prop.get());
                    if (string == null) continue;
                    deprecated.put(propName, string);
                    continue;
                }
                String string = this.obsoleteSettings.get(propName);
                if (string != null) {
                    obsolete.put(propName, string);
                    continue;
                }
                incorrect.add(propName);
            }
            if (obsolete.isEmpty() && deprecated.isEmpty() && incorrect.isEmpty()) {
                return null;
            }
            boolean isError = false;
            StringBuilder sb = new StringBuilder("Configuration issues:\n");
            if (!incorrect.isEmpty()) {
                isError = true;
                sb.append("    Invalid settings (not recognized, probable typos):\n");
                for (String string : incorrect) {
                    sb.append("        * ");
                    sb.append(string);
                    sb.append('\n');
                }
            }
            if (!obsolete.isEmpty()) {
                isError = true;
                sb.append("    Obsolete settings (no longer recognized):\n");
                for (Map.Entry entry : obsolete.entrySet()) {
                    sb.append("        * ");
                    sb.append((String)entry.getKey());
                    sb.append(": ");
                    sb.append((String)entry.getValue());
                    sb.append('\n');
                }
            }
            if (!deprecated.isEmpty()) {
                sb.append("    Deprecated settings (recognized but superseded by newer settings):\n");
                for (Map.Entry entry : deprecated.entrySet()) {
                    sb.append("        * ");
                    sb.append((String)entry.getKey());
                    sb.append(": ");
                    sb.append((String)entry.getValue());
                    sb.append('\n');
                }
            }
            return new ValidationResult(isError, sb.toString());
        }

        private static <KeyT> void registerReplacements(Map<KeyT, String> map, KeyT old, ConfigPropertyKey ... replacements) {
            if (replacements.length > 0) {
                StringBuilder sb = new StringBuilder("Replaced by ");
                for (int index = 0; index < replacements.length; ++index) {
                    if (index > 0) {
                        sb.append(index < replacements.length - 1 ? ", " : " and ");
                    }
                    String replacement = replacements[index].getPropertyPath();
                    sb.append('`');
                    sb.append(replacement);
                    sb.append('`');
                }
                map.put(old, sb.toString());
            } else {
                map.put(old, "No longer used");
            }
        }

        protected Optional<ConfigPropertyKey> lookupConfigProperty(String propName) {
            return PropertyKey.getByString(propName).map(prop -> prop);
        }

        protected void registerDeprecated(ConfigPropertyKey old, ConfigPropertyKey ... replacements) {
            PropertyValidator.registerReplacements(this.deprecatedSettings, old, replacements);
        }

        protected void registerObsolete(String old, ConfigPropertyKey ... replacements) {
            PropertyValidator.registerReplacements(this.obsoleteSettings, old, replacements);
        }
    }

    public class PropStaticContentProcessorConfiguration
    implements StaticContentProcessorConfiguration {
        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public String getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return PropServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return PropServerConfiguration.this.publicDirectory;
        }

        @Override
        public Utf8SequenceObjHashMap<Utf8Sequence> getRedirectMap() {
            return PropServerConfiguration.this.redirectMap;
        }

        @Override
        public byte getRequiredAuthType() {
            return 0;
        }
    }

    @FunctionalInterface
    protected static interface BindToParser {
        public void onReady(int var1, int var2);
    }

    private static class RedirectPropertyKey
    implements ConfigPropertyKey {
        final String envVarName;
        final String propertyPath;

        public RedirectPropertyKey(int index) {
            this.propertyPath = PropertyKey.HTTP_REDIRECT_PREFIX.getPropertyPath() + index;
            this.envVarName = ServerMain.propertyPathToEnvVarName(this.propertyPath);
        }

        @Override
        public String getEnvVarName() {
            return this.envVarName;
        }

        @Override
        public String getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        public boolean isDebug() {
            return false;
        }

        @Override
        public boolean isSensitive() {
            return false;
        }
    }

    public static class ValidationResult {
        public final boolean isError;
        public final String message;

        private ValidationResult(boolean isError, String message) {
            this.isError = isError;
            this.message = message;
        }
    }

    public static class JsonPropertyValueFormatter {
        public static void arrayStr(CharSequence key, String value, CharSink<?> sink) {
            sink.putQuoted(key).putAscii(':').put(value).putAscii(',');
        }

        public static void bool(CharSequence key, boolean value, CharSink<?> sink) {
            sink.putQuoted(key).putAscii(':').put(value).putAscii(',');
        }

        public static void integer(CharSequence key, long value, CharSink<?> sink) {
            sink.putQuoted(key).putAscii(':').put(value).putAscii(',');
        }

        public static void str(CharSequence key, CharSequence value, CharSink<?> sink) {
            sink.putQuoted(key).putAscii(':');
            if (value != null) {
                sink.putQuoted(value);
            } else {
                sink.put("null");
            }
            sink.putAscii(',');
        }
    }
}

