/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.string.immutable;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Spliterator;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.IntLists;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;
import org.eclipse.collections.impl.primitive.AbstractIntIterable;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.eclipse.collections.impl.utility.Iterate;

public class CodePointList
extends AbstractIntIterable
implements CharSequence,
ImmutableIntList,
Serializable {
    private static final long serialVersionUID = 2L;
    private final ImmutableIntList codePoints;

    public CodePointList(String value) {
        int codePoint;
        int stringSize = value.length();
        MutableIntList list = IntLists.mutable.withInitialCapacity(stringSize);
        for (int i = 0; i < stringSize; i += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(i);
            list.add(codePoint);
        }
        this.codePoints = list.toImmutable();
    }

    private CodePointList(ImmutableIntList points) {
        this.codePoints = points;
    }

    private CodePointList(int ... codePoints) {
        this.codePoints = IntLists.immutable.with(codePoints);
    }

    public static CodePointList from(String value) {
        return new CodePointList(value);
    }

    public static CodePointList from(int ... codePoints) {
        return new CodePointList(codePoints);
    }

    public static CodePointList from(IntIterable iterable) {
        if (iterable instanceof ImmutableIntList) {
            return new CodePointList((ImmutableIntList)iterable);
        }
        return new CodePointList(iterable.toArray());
    }

    public StringBuilder toStringBuilder() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            builder.appendCodePoint(this.get(i));
        }
        return builder;
    }

    @Override
    public char charAt(int index) {
        int currentIndex = 0;
        for (int i = 0; i < this.codePoints.size(); ++i) {
            int codePoint = this.codePoints.get(i);
            int charCount = Character.charCount(codePoint);
            if (index < currentIndex + charCount) {
                if (charCount == 1) {
                    return (char)codePoint;
                }
                if (index == currentIndex) {
                    return Character.highSurrogate(codePoint);
                }
                return Character.lowSurrogate(codePoint);
            }
            currentIndex += charCount;
        }
        throw new IndexOutOfBoundsException("Char value at " + index + " is out of bounds for length " + currentIndex);
    }

    @Override
    public int length() {
        int length = 0;
        for (int i = 0; i < this.codePoints.size(); ++i) {
            length += Character.charCount(this.codePoints.get(i));
        }
        return length;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public String subSequence(int start, int end) {
        StringBuilder builder = this.toStringBuilder();
        return builder.substring(start, end);
    }

    @Override
    public String toString() {
        return this.toStringBuilder().toString();
    }

    public IntIterator intIterator() {
        return this.codePoints.intIterator();
    }

    public int[] toArray() {
        return this.codePoints.toArray();
    }

    public int[] toArray(int[] target) {
        return this.codePoints.toArray(target);
    }

    public boolean contains(int expected) {
        return this.codePoints.contains(expected);
    }

    public void each(IntProcedure procedure) {
        this.codePoints.each(procedure);
    }

    public CodePointList distinct() {
        return new CodePointList(this.codePoints.distinct());
    }

    public CodePointList newWith(int element) {
        return new CodePointList(this.codePoints.newWith(element));
    }

    public CodePointList newWithout(int element) {
        return new CodePointList(this.codePoints.newWithout(element));
    }

    public CodePointList newWithAll(IntIterable elements) {
        return new CodePointList(this.codePoints.newWithAll(elements));
    }

    public CodePointList newWithoutAll(IntIterable elements) {
        return new CodePointList(this.codePoints.newWithoutAll(elements));
    }

    public CodePointList toReversed() {
        return new CodePointList(this.codePoints.toReversed());
    }

    public ImmutableIntList subList(int fromIndex, int toIndex) {
        return this.codePoints.subList(fromIndex, toIndex);
    }

    public int get(int index) {
        return this.codePoints.get(index);
    }

    public long dotProduct(IntList list) {
        return this.codePoints.dotProduct(list);
    }

    public int binarySearch(int value) {
        return this.codePoints.binarySearch(value);
    }

    public int lastIndexOf(int value) {
        return this.codePoints.lastIndexOf(value);
    }

    public ImmutableIntList toImmutable() {
        return this;
    }

    public int getLast() {
        return this.codePoints.getLast();
    }

    public LazyIntIterable asReversed() {
        return this.codePoints.asReversed();
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.codePoints.injectIntoWithIndex(injectedValue, function);
    }

    public int getFirst() {
        return this.codePoints.getFirst();
    }

    public int indexOf(int value) {
        return this.codePoints.indexOf(value);
    }

    public void forEachWithIndex(IntIntProcedure procedure) {
        this.codePoints.forEachWithIndex(procedure);
    }

    public CodePointList select(IntPredicate predicate) {
        return new CodePointList(this.codePoints.select(predicate));
    }

    public CodePointList reject(IntPredicate predicate) {
        return new CodePointList(this.codePoints.reject(predicate));
    }

    public <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function) {
        return this.codePoints.collect(function);
    }

    public CodePointList collectInt(IntToIntFunction function) {
        MutableIntList collected = IntLists.mutable.withInitialCapacity(this.size());
        for (int i = 0; i < this.size(); ++i) {
            int codePoint = this.get(i);
            collected.add(function.valueOf(codePoint));
        }
        return new CodePointList(collected.toImmutable());
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.codePoints.detectIfNone(predicate, ifNone);
    }

    public int count(IntPredicate predicate) {
        return this.codePoints.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.codePoints.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.codePoints.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.codePoints.noneSatisfy(predicate);
    }

    @Override
    public MutableIntList toList() {
        return this.codePoints.toList();
    }

    @Override
    public MutableIntSet toSet() {
        return this.codePoints.toSet();
    }

    @Override
    public MutableIntBag toBag() {
        return this.codePoints.toBag();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.codePoints.injectInto(injectedValue, function);
    }

    public RichIterable<IntIterable> chunk(int size) {
        return this.codePoints.chunk(size);
    }

    public long sum() {
        return this.codePoints.sum();
    }

    public int max() {
        return this.codePoints.max();
    }

    public int min() {
        return this.codePoints.min();
    }

    public int size() {
        return this.codePoints.size();
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                char[] chars;
                if (i > 0) {
                    appendable.append(separator);
                }
                int codePoint = this.get(i);
                if (appendable instanceof StringBuilder) {
                    ((StringBuilder)appendable).appendCodePoint(codePoint);
                    continue;
                }
                if (appendable instanceof StringBuffer) {
                    ((StringBuffer)appendable).appendCodePoint(codePoint);
                    continue;
                }
                for (char aChar : chars = Character.toChars(codePoint)) {
                    appendable.append(aChar);
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object otherList) {
        return this.codePoints.equals(otherList);
    }

    public int hashCode() {
        return this.codePoints.hashCode();
    }

    public ImmutableList<IntIntPair> zipInt(IntIterable iterable) {
        int size = this.size();
        int othersize = iterable.size();
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        IntIterator iterator = iterable.intIterator();
        for (int i = 0; i < size && i < othersize; ++i) {
            target.add((Object)PrimitiveTuples.pair(this.get(i), iterator.next()));
        }
        return target.toImmutable();
    }

    public <T> ImmutableList<IntObjectPair<T>> zip(Iterable<T> iterable) {
        int size = this.size();
        int othersize = Iterate.sizeOf(iterable);
        MutableList target = Lists.mutable.withInitialCapacity(Math.min(size, othersize));
        Iterator<T> iterator = iterable.iterator();
        for (int i = 0; i < size && i < othersize; ++i) {
            target.add(PrimitiveTuples.pair(this.get(i), iterator.next()));
        }
        return target.toImmutable();
    }

    public Spliterator.OfInt spliterator() {
        return this.codePoints.spliterator();
    }
}

