/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.common.utils;

import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineSchedulerExtractorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CaffeineSchedulerExtractorUtils.class);

    private CaffeineSchedulerExtractorUtils() {
    }

    public static ScheduledExecutorService extractSchedulerExecutor(Object cache) {
        try {
            Object cacheImpl = CaffeineSchedulerExtractorUtils.unwrapCache(cache);
            Object pacer = CaffeineSchedulerExtractorUtils.getPacerFromCache(cacheImpl);
            if (pacer == null) {
                return null;
            }
            Scheduler scheduler = CaffeineSchedulerExtractorUtils.getSchedulerFromPacer(pacer);
            if (scheduler == null) {
                return null;
            }
            ScheduledExecutorService executorService = CaffeineSchedulerExtractorUtils.getExecutorServiceFromScheduler(scheduler);
            if (executorService != null) {
                LOG.info("Successfully extracted ScheduledExecutorService from Caffeine cache");
                return executorService;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to extract scheduler from Caffeine cache: {}", (Object)e.getMessage());
        }
        return null;
    }

    @VisibleForTesting
    public static Object unwrapCache(Object cache) {
        if (cache == null) {
            return null;
        }
        try {
            Object innerCache = FieldUtils.readField((Object)cache, (String)"cache", (boolean)true);
            if (innerCache != null) {
                return innerCache;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return cache;
    }

    @VisibleForTesting
    public static Object getPacerFromCache(Object cacheImpl) {
        if (cacheImpl == null) {
            return null;
        }
        for (Class<?> clazz = cacheImpl.getClass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                Object pacer = FieldUtils.readField((Object)cacheImpl, (String)"pacer", (boolean)true);
                if (pacer == null || !"Pacer".equals(pacer.getClass().getSimpleName())) continue;
                return pacer;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @VisibleForTesting
    public static Scheduler getSchedulerFromPacer(Object pacer) {
        if (pacer == null) {
            return null;
        }
        try {
            Object scheduler = FieldUtils.readField((Object)pacer, (String)"scheduler", (boolean)true);
            if (scheduler instanceof Scheduler) {
                return (Scheduler)scheduler;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @VisibleForTesting
    public static ScheduledExecutorService getExecutorServiceFromScheduler(Scheduler scheduler) {
        if (scheduler == null) {
            return null;
        }
        Object actualScheduler = scheduler;
        if ("GuardedScheduler".equals(scheduler.getClass().getSimpleName())) {
            try {
                Object delegate = FieldUtils.readField((Object)scheduler, (String)"delegate", (boolean)true);
                if (delegate != null) {
                    actualScheduler = delegate;
                }
            }
            catch (IllegalAccessException delegate) {
                // empty catch block
            }
        }
        if ("ExecutorServiceScheduler".equals(actualScheduler.getClass().getSimpleName())) {
            try {
                Object executorService = FieldUtils.readField((Object)actualScheduler, (String)"scheduledExecutorService", (boolean)true);
                if (executorService instanceof ScheduledExecutorService) {
                    return (ScheduledExecutorService)executorService;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }
}

