/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.IcebergAuthorizationMetadata;
import org.apache.gravitino.server.web.filter.BaseMetadataAuthorizationMethodInterceptor;
import org.apache.gravitino.server.web.filter.LoadTableAuthzHandler;
import org.apache.gravitino.server.web.filter.RenameTableAuthzHandler;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;

public class IcebergMetadataAuthorizationMethodInterceptor
extends BaseMetadataAuthorizationMethodInterceptor {
    private final String metalakeName = IcebergRESTServerContext.getInstance().metalakeName();

    @Override
    protected Map<Entity.EntityType, NameIdentifier> extractNameIdentifierFromParameters(Parameter[] parameters, Object[] args) {
        HashMap<Entity.EntityType, NameIdentifier> nameIdentifierMap = new HashMap<Entity.EntityType, NameIdentifier>();
        nameIdentifierMap.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)this.metalakeName));
        String catalog = null;
        String schema = null;
        Namespace rawNamespace = null;
        block5: for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            AuthorizationMetadata authorizeResource = parameter.getAnnotation(AuthorizationMetadata.class);
            if (authorizeResource == null) continue;
            Entity.EntityType type = authorizeResource.type();
            String value = String.valueOf(args[i]);
            switch (type) {
                case CATALOG: {
                    catalog = IcebergRESTUtils.getCatalogName(value);
                    nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.ofCatalog((String)this.metalakeName, (String)catalog));
                    continue block5;
                }
                case SCHEMA: {
                    rawNamespace = RESTUtil.decodeNamespace((String)value);
                    schema = rawNamespace.level(rawNamespace.length() - 1);
                    nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.ofSchema((String)this.metalakeName, (String)catalog, (String)schema));
                    continue block5;
                }
                case TABLE: {
                    nameIdentifierMap.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)this.metalakeName, (String)catalog, schema, (String)value));
                    continue block5;
                }
            }
        }
        return nameIdentifierMap;
    }

    @Override
    protected Optional<BaseMetadataAuthorizationMethodInterceptor.AuthorizationHandler> createAuthorizationHandler(Parameter[] parameters, Object[] args) {
        for (Parameter parameter : parameters) {
            IcebergAuthorizationMetadata icebergMetadata = parameter.getAnnotation(IcebergAuthorizationMetadata.class);
            if (icebergMetadata == null) continue;
            IcebergAuthorizationMetadata.RequestType type = icebergMetadata.type();
            switch (type) {
                case LOAD_TABLE: {
                    return Optional.of(new LoadTableAuthzHandler(parameters, args));
                }
                case RENAME_TABLE: {
                    return Optional.of(new RenameTableAuthzHandler(parameters, args));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    protected boolean isExceptionPropagate(Exception e) {
        return e.getClass().getName().startsWith("org.apache.iceberg.exceptions");
    }
}

