/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.postgresql;

import org.apache.gravitino.storage.relational.mapper.provider.base.JobTemplateMetaBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.JobTemplatePO;
import org.apache.ibatis.annotations.Param;

public class JobTemplateMetaPostgreSQLProvider
extends JobTemplateMetaBaseSQLProvider {
    @Override
    public String softDeleteJobTemplateMetaByMetalakeAndName(@Param(value="metalakeName") String metalakeName, @Param(value="jobTemplateName") String jobTemplateName) {
        return "UPDATE job_template_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id IN ( SELECT metalake_id FROM metalake_meta WHERE metalake_name = #{metalakeName} AND deleted_at = 0) AND job_template_name = #{jobTemplateName} AND deleted_at = 0";
    }

    @Override
    public String softDeleteJobTemplateMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE job_template_meta SET deleted_at = CAST(EXTRACT(EPOCH FROM CURRENT_TIMESTAMP) * 1000 AS BIGINT) WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    @Override
    public String insertJobTemplateMetaOnDuplicateKeyUpdate(@Param(value="jobTemplateMeta") JobTemplatePO jobTemplatePO) {
        return "INSERT INTO job_template_meta (job_template_id, job_template_name, metalake_id, job_template_comment, job_template_content, audit_info, current_version, last_version, deleted_at) VALUES (#{jobTemplateMeta.jobTemplateId}, #{jobTemplateMeta.jobTemplateName}, #{jobTemplateMeta.metalakeId}, #{jobTemplateMeta.jobTemplateComment}, #{jobTemplateMeta.jobTemplateContent}, #{jobTemplateMeta.auditInfo}, #{jobTemplateMeta.currentVersion}, #{jobTemplateMeta.lastVersion}, #{jobTemplateMeta.deletedAt}) ON CONFLICT(job_template_id) DO UPDATE SET job_template_name = #{jobTemplateMeta.jobTemplateName}, metalake_id = #{jobTemplateMeta.metalakeId}, job_template_comment = #{jobTemplateMeta.jobTemplateComment}, job_template_content = #{jobTemplateMeta.jobTemplateContent}, audit_info = #{jobTemplateMeta.auditInfo}, current_version = #{jobTemplateMeta.currentVersion}, last_version = #{jobTemplateMeta.lastVersion}, deleted_at = #{jobTemplateMeta.deletedAt}";
    }

    @Override
    public String deleteJobTemplateMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return "DELETE FROM job_template_meta WHERE job_template_id IN (SELECT job_template_id FROM job_template_meta WHERE deleted_at < #{legacyTimeline} AND deleted_at > 0 LIMIT #{limit})";
    }
}

