/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.requests.StatisticsDropRequest;
import org.apache.gravitino.dto.requests.StatisticsUpdateRequest;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.StatisticListResponse;
import org.apache.gravitino.exceptions.IllegalStatisticNameException;
import org.apache.gravitino.exceptions.UnmodifiableStatisticException;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.stats.Statistic;
import org.apache.gravitino.stats.StatisticValue;
import org.apache.gravitino.stats.SupportsStatistics;

class MetadataObjectStatisticsOperations
implements SupportsStatistics {
    private final RESTClient restClient;
    private final String statisticsRequestPath;

    MetadataObjectStatisticsOperations(String metalakeName, MetadataObject metadataObject, RESTClient restClient) {
        this.restClient = restClient;
        this.statisticsRequestPath = String.format("api/metalakes/%s/objects/%s/%s/statistics", RESTUtils.encodeString((String)metalakeName), metadataObject.type().name().toLowerCase(Locale.ROOT), RESTUtils.encodeString((String)metadataObject.fullName()));
    }

    public List<Statistic> listStatistics() {
        StatisticListResponse resp = this.restClient.get(this.statisticsRequestPath, StatisticListResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        resp.validate();
        return Arrays.asList(resp.getStatistics());
    }

    public void updateStatistics(Map<String, StatisticValue<?>> statistics) throws UnmodifiableStatisticException, IllegalStatisticNameException {
        Preconditions.checkArgument((statistics != null && !statistics.isEmpty() ? 1 : 0) != 0, (Object)"Statistics map must not be null or empty");
        StatisticsUpdateRequest request = StatisticsUpdateRequest.builder().updates(statistics).build();
        request.validate();
        BaseResponse resp = this.restClient.put(this.statisticsRequestPath, (RESTRequest)request, BaseResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        resp.validate();
    }

    public boolean dropStatistics(List<String> statistics) throws UnmodifiableStatisticException {
        StatisticsDropRequest request = new StatisticsDropRequest(statistics.toArray(new String[0]));
        request.validate();
        DropResponse resp = this.restClient.post(this.statisticsRequestPath, (RESTRequest)request, DropResponse.class, Collections.emptyMap(), ErrorHandlers.statisticsErrorHandler());
        resp.validate();
        return resp.dropped();
    }
}

