/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.compiler.ast.AllArtefactClassInjector;
import grails.compiler.ast.AnnotatedClassInjector;
import grails.compiler.ast.ClassInjector;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.TransformWithPriority;
import org.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.grails.compiler.injection.ArtefactTypeAstTransformation;
import org.grails.compiler.injection.GrailsAwareInjectionOperation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public abstract class AbstractArtefactTypeAstTransformation
implements ASTTransformation,
TransformWithPriority {
    protected void performInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        try {
            ClassInjector[] classInjectors = GrailsAwareInjectionOperation.getClassInjectors();
            List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, classInjectors);
            if (!injectors.isEmpty()) {
                AbstractGrailsArtefactTransformer.addToTransformedClasses(cNode.getName());
                for (ClassInjector injector : injectors) {
                    if (injector instanceof AllArtefactClassInjector) {
                        injector.performInjection(sourceUnit, cNode);
                        continue;
                    }
                    if (!(injector instanceof AnnotatedClassInjector)) continue;
                    ((AnnotatedClassInjector)((Object)injector)).performInjectionOnAnnotatedClass(sourceUnit, null, cNode);
                }
            }
        }
        catch (RuntimeException e) {
            System.err.println("Error occurred calling AST injector [" + String.valueOf(this.getClass()) + "]: " + e.getMessage());
            throw e;
        }
    }
}

