/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.account.data.AccountTransfersDetailDataValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountTransfersDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final AccountTransfersDetailDataValidator accountTransfersDetailDataValidator;
    private static final Set<String> REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("locale", "dateFormat", "fromOfficeId", "fromClientId", "fromAccountType", "fromAccountId", "toOfficeId", "toClientId", "toAccountType", "toAccountId", "transferDate", "transferAmount", "transferDescription"));

    @Autowired
    public AccountTransfersDataValidator(FromJsonHelper fromApiJsonHelper, AccountTransfersDetailDataValidator accountTransfersDetailDataValidator) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.accountTransfersDetailDataValidator = accountTransfersDetailDataValidator;
    }

    public void validate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("accounttransfer");
        JsonElement element = command.parsedJson();
        this.accountTransfersDetailDataValidator.validate(command, baseDataValidator);
        LocalDate transactionDate = this.fromApiJsonHelper.extractLocalDateNamed("transferDate", element);
        baseDataValidator.reset().parameter("transferDate").value((Object)transactionDate).notNull();
        BigDecimal transactionAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("transferAmount", element);
        baseDataValidator.reset().parameter("transferAmount").value((Object)transactionAmount).notNull().positiveAmount();
        String transactionDescription = this.fromApiJsonHelper.extractStringNamed("transferDescription", element);
        baseDataValidator.reset().parameter("transferDescription").value((Object)transactionDescription).notBlank().notExceedingLengthOf(Integer.valueOf(200));
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

